/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.cas;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordAlreadyExistsException;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordNotFoundException;
import org.exoplatform.services.jcr.impl.storage.value.cas.VCASException;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCValueContentAddressStorageImpl
implements ValueContentAddressStorage {
    public static final String JDBC_SOURCE_NAME_PARAM = "jdbc-source-name";
    public static final String JDBC_DIALECT_PARAM = "jdbc-dialect";
    public static final String TABLE_NAME_PARAM = "jdbc-table-name";
    public static final String DEFAULT_TABLE_NAME = "JCR_VCAS";
    private static final Log LOG = ExoLogger.getLogger((String)"jcr.JDBCValueContentAddressStorageImpl");
    private static final String MYSQL_PK_CONSTRAINT_DETECT_PATTERN = "(.*Constraint+.*Violation+.*Duplicate+.*entry+.*)+?";
    private static final Pattern MYSQL_PK_CONSTRAINT_DETECT = Pattern.compile("(.*Constraint+.*Violation+.*Duplicate+.*entry+.*)+?", 2);
    protected DataSource dataSource;
    protected String tableName;
    protected String dialect;
    protected String sqlAddRecord;
    protected String sqlDeleteRecord;
    protected String sqlDeleteValueRecord;
    protected String sqlSelectRecord;
    protected String sqlSelectRecords;
    protected String sqlSelectOwnRecords;
    protected String sqlSelectSharingProps;
    protected String sqlConstraintPK;
    protected String sqlVCASIDX;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Properties props) throws RepositoryConfigurationException, VCASException {
        block12: {
            String tn = props.getProperty(TABLE_NAME_PARAM);
            this.tableName = tn != null ? tn : DEFAULT_TABLE_NAME;
            this.dialect = props.getProperty(JDBC_DIALECT_PARAM, DBConstants.DB_DIALECT_GENERIC);
            this.sqlConstraintPK = this.tableName + "_PK";
            this.sqlVCASIDX = this.tableName + "_IDX";
            if (DBConstants.DB_DIALECT_PGSQL.equalsIgnoreCase(this.dialect) || DBConstants.DB_DIALECT_INGRES.equalsIgnoreCase(this.dialect)) {
                this.tableName = this.tableName.toUpperCase().toLowerCase();
                this.sqlConstraintPK = this.sqlConstraintPK.toUpperCase().toLowerCase();
                this.sqlVCASIDX = this.sqlVCASIDX.toUpperCase().toLowerCase();
            }
            this.sqlAddRecord = "INSERT INTO " + this.tableName + " (PROPERTY_ID, ORDER_NUM, CAS_ID) VALUES(?,?,?)";
            this.sqlDeleteRecord = "DELETE FROM " + this.tableName + " WHERE PROPERTY_ID=?";
            this.sqlDeleteValueRecord = "DELETE FROM " + this.tableName + " WHERE PROPERTY_ID=? AND ORDER_NUM=?";
            this.sqlSelectRecord = "SELECT CAS_ID FROM " + this.tableName + " WHERE PROPERTY_ID=? AND ORDER_NUM=?";
            this.sqlSelectRecords = "SELECT CAS_ID, ORDER_NUM FROM " + this.tableName + " WHERE PROPERTY_ID=? ORDER BY ORDER_NUM";
            this.sqlSelectOwnRecords = "SELECT P.CAS_ID, P.ORDER_NUM, S.CAS_ID as SHARED_ID FROM " + this.tableName + " P LEFT JOIN " + this.tableName + " S ON P.PROPERTY_ID<>S.PROPERTY_ID AND P.CAS_ID=S.CAS_ID " + "WHERE P.PROPERTY_ID=? GROUP BY P.CAS_ID, P.ORDER_NUM, S.CAS_ID ORDER BY P.ORDER_NUM";
            this.sqlSelectSharingProps = "SELECT DISTINCT C.PROPERTY_ID AS PROPERTY_ID FROM " + this.tableName + " C, " + this.tableName + " P " + "WHERE C.CAS_ID=P.CAS_ID AND C.PROPERTY_ID<>P.PROPERTY_ID AND P.PROPERTY_ID=?";
            String sn = props.getProperty(JDBC_SOURCE_NAME_PARAM);
            if (sn != null) {
                try {
                    this.dataSource = (DataSource)new InitialContext().lookup(sn);
                    try {
                        Connection con = this.dataSource.getConnection();
                        try {
                            ResultSet trs = con.getMetaData().getTables(null, null, this.tableName, null);
                            if (!trs.next()) {
                                con.createStatement().executeUpdate("CREATE TABLE " + this.tableName + " (PROPERTY_ID VARCHAR(96) NOT NULL, ORDER_NUM INTEGER NOT NULL, CAS_ID VARCHAR(512) NOT NULL, " + "CONSTRAINT " + this.sqlConstraintPK + " PRIMARY KEY(PROPERTY_ID, ORDER_NUM))");
                                con.createStatement().executeUpdate("CREATE INDEX " + this.sqlVCASIDX + " ON " + this.tableName + "(CAS_ID, PROPERTY_ID, ORDER_NUM)");
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("JDBC Value Content Address Storage initialized in database " + sn));
                                }
                            } else if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("JDBC Value Content Address Storage already initialized in database " + sn));
                            }
                            Object var7_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_9 = null;
                            con.close();
                            throw throwable;
                        }
                        con.close();
                        {
                            break block12;
                        }
                    }
                    catch (SQLException e) {
                        throw new VCASException("VCAS INIT database error: " + e, e);
                    }
                }
                catch (NamingException e) {
                    throw new RepositoryConfigurationException("JDBC data source is not available in JNDI with name '" + sn + "'. Error: " + e);
                }
            }
            throw new RepositoryConfigurationException("jdbc-source-name parameter should be set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValue(String propertyId, int orderNum, String identifier) throws VCASException {
        try {
            Connection con = this.dataSource.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement(this.sqlAddRecord);
                ps.setString(1, propertyId);
                ps.setInt(2, orderNum);
                ps.setString(3, identifier);
                ps.executeUpdate();
                ps.close();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            if (this.isRecordAlreadyExistsException(e)) {
                throw new RecordAlreadyExistsException("Record already exists, propertyId=" + propertyId + " orderNum=" + orderNum + ". Error: " + e, e);
            }
            throw new VCASException("VCAS ADD database error: " + e, e);
        }
    }

    private boolean isRecordAlreadyExistsException(SQLException e) {
        String err = e.toString();
        if (DBConstants.DB_DIALECT_MYSQL.equalsIgnoreCase(this.dialect) || DBConstants.DB_DIALECT_MYSQL_UTF8.equalsIgnoreCase(this.dialect)) {
            return MYSQL_PK_CONSTRAINT_DETECT.matcher(err).find();
        }
        return err.toLowerCase().toUpperCase().indexOf(this.sqlConstraintPK.toLowerCase().toUpperCase()) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProperty(String propertyId) throws VCASException {
        try {
            Connection con = this.dataSource.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement(this.sqlDeleteRecord);
                ps.setString(1, propertyId);
                int res = ps.executeUpdate();
                ps.close();
                if (res <= 0) {
                    throw new RecordNotFoundException("Record not found, propertyId=" + propertyId);
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            throw new VCASException("VCAS DELETE database error: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteValue(String propertyId, int orderNumb) throws VCASException {
        try {
            Connection con = this.dataSource.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement(this.sqlDeleteValueRecord);
                ps.setString(1, propertyId);
                ps.setInt(2, orderNumb);
                int res = ps.executeUpdate();
                ps.close();
                if (res <= 0) {
                    throw new RecordNotFoundException("Value record not found, propertyId=" + propertyId + " orderNumb=" + orderNumb);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            throw new VCASException("VCAS Value DELETE database error: " + e, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getIdentifier(String propertyId, int orderNum) throws VCASException {
        try {
            String string;
            Connection con = this.dataSource.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement(this.sqlSelectRecord);
                ps.setString(1, propertyId);
                ps.setInt(2, orderNum);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new RecordNotFoundException("No record found with propertyId=" + propertyId + " orderNum=" + orderNum);
                }
                string = rs.getString("CAS_ID");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                con.close();
                throw throwable;
            }
            con.close();
            return string;
        }
        catch (SQLException e) {
            throw new VCASException("VCAS GET ID database error: " + e, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getIdentifiers(String propertyId, boolean ownOnly) throws VCASException {
        try {
            ArrayList<String> arrayList;
            Connection con;
            block10: {
                ArrayList<String> arrayList2;
                block9: {
                    con = this.dataSource.getConnection();
                    try {
                        ArrayList<String> ids = new ArrayList<String>();
                        if (ownOnly) {
                            PreparedStatement ps = con.prepareStatement(this.sqlSelectOwnRecords);
                            ps.setString(1, propertyId);
                            ResultSet rs = ps.executeQuery();
                            if (!rs.next()) {
                                throw new RecordNotFoundException("No records found with propertyId=" + propertyId);
                            }
                            do {
                                rs.getString("SHARED_ID");
                                if (!rs.wasNull()) continue;
                                ids.add(rs.getString("CAS_ID"));
                            } while (rs.next());
                            arrayList2 = ids;
                            Object var9_12 = null;
                            break block9;
                        }
                        PreparedStatement ps = con.prepareStatement(this.sqlSelectRecords);
                        ps.setString(1, propertyId);
                        ResultSet rs = ps.executeQuery();
                        if (!rs.next()) {
                            throw new RecordNotFoundException("No records found with propertyId=" + propertyId);
                        }
                        do {
                            ids.add(rs.getString("CAS_ID"));
                        } while (rs.next());
                        arrayList = ids;
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var9_14 = null;
                        con.close();
                        throw throwable;
                    }
                }
                con.close();
                return arrayList2;
            }
            Object var9_13 = null;
            con.close();
            return arrayList;
        }
        catch (SQLException e) {
            throw new VCASException("VCAS GET IDs database error: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasSharedContent(String propertyId) throws VCASException {
        try {
            boolean bl;
            Connection con = this.dataSource.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement(this.sqlSelectSharingProps);
                ps.setString(1, propertyId);
                bl = ps.executeQuery().next();
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                con.close();
                throw throwable;
            }
            con.close();
            return bl;
        }
        catch (SQLException e) {
            throw new VCASException("VCAS HAS SHARED IDs database error: " + e, e);
        }
    }
}

