/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.management.Descriptor;
import javax.management.IntrospectionException;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.exoplatform.container.management.ManagedMethodMetaData;
import org.exoplatform.container.management.ManagedMethodParameterMetaData;
import org.exoplatform.container.management.ManagedPropertyMetaData;
import org.exoplatform.container.management.ManagedTypeMetaData;
import org.exoplatform.container.management.MetaDataBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoMBeanInfoBuilder {
    private MetaDataBuilder metaDataBuilder;

    public ExoMBeanInfoBuilder(Class clazz) throws IllegalArgumentException {
        this.metaDataBuilder = new MetaDataBuilder(clazz);
    }

    public boolean isBuildable() {
        return this.metaDataBuilder.isBuildable();
    }

    private ModelMBeanOperationInfo buildOperationInfo(Method method, String description, Role role, Collection<ManagedMethodParameterMetaData> parametersMD) {
        ModelMBeanOperationInfo operationInfo = new ModelMBeanOperationInfo(description, method);
        if (description == null) {
            description = "Management operation";
        }
        MBeanParameterInfo[] parameterInfos = operationInfo.getSignature();
        for (ManagedMethodParameterMetaData parameterMD : parametersMD) {
            int i = parameterMD.getIndex();
            MBeanParameterInfo parameterInfo = parameterInfos[i];
            String parameterName = parameterInfo.getName();
            String parameterDescription = operationInfo.getSignature()[i].getDescription();
            if (parameterMD.getName() != null) {
                parameterName = parameterMD.getName();
            } else if (parameterMD.getDescription() != null) {
                parameterDescription = parameterMD.getDescription();
            }
            parameterInfos[i] = new MBeanParameterInfo(parameterName, parameterInfo.getType(), parameterDescription);
        }
        Descriptor operationDescriptor = operationInfo.getDescriptor();
        operationDescriptor.setField("role", role.name);
        return new ModelMBeanOperationInfo(operationInfo.getName(), description, parameterInfos, operationInfo.getReturnType(), operationInfo.getImpact(), operationDescriptor);
    }

    public ModelMBeanInfo build() throws IllegalStateException {
        ManagedTypeMetaData typeMD = this.metaDataBuilder.build();
        String mbeanDescription = "Exo model mbean";
        if (typeMD.getDescription() != null) {
            mbeanDescription = typeMD.getDescription();
        }
        ArrayList<ModelMBeanOperationInfo> operations = new ArrayList<ModelMBeanOperationInfo>();
        for (ManagedMethodMetaData methodMD : typeMD.getMethods()) {
            ModelMBeanOperationInfo operationInfo = this.buildOperationInfo(methodMD.getMethod(), methodMD.getDescription(), Role.OP, methodMD.getParameters());
            operations.add(operationInfo);
        }
        HashMap<String, ModelMBeanAttributeInfo> attributeInfos = new HashMap<String, ModelMBeanAttributeInfo>();
        for (ManagedPropertyMetaData propertyMD : typeMD.getProperties()) {
            Method setter;
            ModelMBeanOperationInfo operationInfo;
            List<ManagedMethodParameterMetaData> blah;
            Method getter = propertyMD.getGetter();
            if (getter != null) {
                Role role;
                String getterName = getter.getName();
                if (getterName.startsWith("get") && getterName.length() > 3) {
                    role = Role.GET;
                } else if (getterName.startsWith("is") && getterName.length() > 2) {
                    role = Role.IS;
                } else {
                    throw new AssertionError();
                }
                blah = Collections.emptyList();
                operationInfo = this.buildOperationInfo(getter, propertyMD.getGetterDescription(), role, blah);
                operations.add(operationInfo);
            }
            if ((setter = propertyMD.getSetter()) != null) {
                ManagedMethodParameterMetaData s = new ManagedMethodParameterMetaData(0);
                s.setDescription(propertyMD.getSetterParameter().getDescription());
                s.setName(propertyMD.getSetterParameter().getName());
                blah = Collections.singletonList(s);
                operationInfo = this.buildOperationInfo(setter, propertyMD.getSetterDescription(), Role.SET, blah);
                operations.add(operationInfo);
            }
            try {
                String attributeDescription = propertyMD.getDescription() != null ? propertyMD.getDescription() : "Managed attribute " + propertyMD.getName();
                ModelMBeanAttributeInfo attributeInfo = new ModelMBeanAttributeInfo(propertyMD.getName(), attributeDescription, getter, setter);
                Descriptor attributeDescriptor = attributeInfo.getDescriptor();
                if (getter != null) {
                    attributeDescriptor.setField("getMethod", getter.getName());
                }
                if (setter != null) {
                    attributeDescriptor.setField("setMethod", setter.getName());
                }
                attributeDescriptor.setField("currencyTimeLimit", "-1");
                attributeDescriptor.setField("persistPolicy", "Never");
                attributeInfo.setDescriptor(attributeDescriptor);
                ModelMBeanAttributeInfo previous = attributeInfos.put(propertyMD.getName(), attributeInfo);
                if (previous == null) continue;
                throw new IllegalArgumentException();
            }
            catch (IntrospectionException e) {
                throw new AssertionError((Object)e);
            }
        }
        return new ModelMBeanInfoSupport(typeMD.getType().getName(), mbeanDescription, attributeInfos.values().toArray(new ModelMBeanAttributeInfo[attributeInfos.size()]), new ModelMBeanConstructorInfo[0], operations.toArray(new ModelMBeanOperationInfo[operations.size()]), new ModelMBeanNotificationInfo[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Role {
        SET("setter"),
        IS("getter"),
        GET("getter"),
        OP("operation");

        private final String name;

        private Role(String role) {
            this.name = role;
        }
    }
}

