/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.jmx.ExoMBeanInfoBuilder;
import org.exoplatform.container.jmx.ExoModelMBean;
import org.exoplatform.container.jmx.JMX;
import org.exoplatform.container.jmx.ManageableContainer;
import org.exoplatform.container.jmx.PropertiesInfo;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.management.jmx.annotations.NameTemplate;

public class ManagementContextImpl
implements ManagementContext {
    Map<String, String> scopingProperties;
    private final Map<Object, ObjectName> registrations;
    private final ManagementContextImpl parent;
    final MBeanServer server;
    ManageableContainer container;

    public ManagementContextImpl() {
        this(MBeanServerFactory.createMBeanServer());
    }

    public ManagementContextImpl(MBeanServer server) {
        if (server == null) {
            throw new NullPointerException();
        }
        this.registrations = new HashMap<Object, ObjectName>();
        this.parent = null;
        this.scopingProperties = Collections.emptyMap();
        this.server = server;
    }

    public ManagementContextImpl(ManagementContextImpl parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.registrations = new HashMap<Object, ObjectName>();
        this.parent = parent;
        this.scopingProperties = null;
        this.server = parent.server;
    }

    public ManagementContext getParent() {
        return this.parent;
    }

    public void register(Object o) {
        ObjectName name = this.manageMBean(o);
        if (name != null) {
            this.registrations.put(o, name);
        }
    }

    public void unregister(Object o) {
        ObjectName name = this.registrations.remove(o);
        if (name != null) {
            this.unmanageMBean(name);
        }
    }

    private ExoModelMBean createExoMBean(Object bean) {
        ExoMBeanInfoBuilder infoBuilder;
        Object view = null;
        ManagedBy managedBy = bean.getClass().getAnnotation(ManagedBy.class);
        if (managedBy != null) {
            try {
                Class managedByClass = managedBy.value();
                Constructor blah = managedByClass.getConstructor(bean.getClass());
                view = blah.newInstance(bean);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            view = bean;
        }
        if (view != null && (infoBuilder = new ExoMBeanInfoBuilder(view.getClass())).isBuildable()) {
            try {
                ModelMBeanInfo info = infoBuilder.build();
                return new ExoModelMBean(this, view, info);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ObjectName manageMBean(Object bean) {
        ExoModelMBean mbean = this.createExoMBean(bean);
        if (mbean != null) {
            Object mr = mbean.getManagedResource();
            ObjectName on = null;
            PropertiesInfo oni = PropertiesInfo.resolve(mr.getClass(), NameTemplate.class);
            if (oni != null) {
                try {
                    Map<String, String> foo = oni.resolve(mr);
                    on = JMX.createObjectName("exo", foo);
                }
                catch (MalformedObjectNameException e) {
                    e.printStackTrace();
                }
            }
            if (on != null) {
                try {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    Iterator<Map.Entry<String, String>> i$ = on.getKeyPropertyList().entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry<String, String> o;
                        Map.Entry<String, String> entry = o = i$.next();
                        String key = entry.getKey();
                        String value = entry.getValue();
                        props.put(key, value);
                    }
                    ManagementContextImpl current = this;
                    while (current != null) {
                        if (current.scopingProperties != null) {
                            props.putAll(current.scopingProperties);
                        }
                        current = current.parent;
                    }
                    on = JMX.createObjectName(on.getDomain(), props);
                    this.attemptToRegister(on, mbean);
                    return on;
                }
                catch (MalformedObjectNameException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void unmanageMBean(ObjectName name) {
        try {
            this.server.unregisterMBean(name);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void attemptToRegister(ObjectName name, Object mbean) {
        MBeanServer mBeanServer = this.server;
        synchronized (mBeanServer) {
            try {
                this.server.registerMBean(mbean, name);
            }
            catch (InstanceAlreadyExistsException e) {
                try {
                    this.server.unregisterMBean(name);
                    this.server.registerMBean(mbean, name);
                }
                catch (Exception e1) {
                    throw new RuntimeException("Failed to register MBean '" + name + " due to " + e.getMessage(), e);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register MBean '" + name + " due to " + e.getMessage(), e);
            }
        }
    }

    public ExoContainer findContainer() {
        ManagementContextImpl current = this;
        while (!(current.container instanceof ExoContainer)) {
            if (current.parent == null) {
                return null;
            }
            current = current.parent;
        }
        return (ExoContainer)current.container;
    }

    public String toString() {
        return "ManagementContextImpl[container=" + (Object)((Object)this.container) + "]";
    }
}

