/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.replication.model;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.exoplatform.webui.application.replication.model.TypeModel;

public final class FieldModel {
    private final Field field;
    private final TypeModel type;
    private boolean _transient;

    FieldModel(Field field, TypeModel type) {
        this.field = field;
        this.type = type;
        this._transient = Modifier.isTransient(field.getModifiers());
    }

    public String getName() {
        return this.field.getName();
    }

    public boolean isTransient() {
        return this._transient;
    }

    public TypeModel getType() {
        return this.type;
    }

    public Object getValue(Object o) {
        try {
            return this.field.get(o);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setValue(Object o, Object value) {
        try {
            this.field.set(o, value);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

