/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.sync;

import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryRootMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.AbstractContentModificationGenerator;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationPolicy;

public class RemoteContentModificationGenerator
extends AbstractContentModificationGenerator {
    private final SynchronizationPolicy policy;
    private final RepositoryContentMetadata baseRemoteContent;
    private final boolean merge;

    public RemoteContentModificationGenerator(SynchronizationPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Null policy");
        }
        this.policy = policy;
        this.baseRemoteContent = null;
        this.merge = true;
    }

    public RemoteContentModificationGenerator(SynchronizationPolicy policy, RepositoryContentMetadata baseRemoteContent) {
        if (policy == null) {
            throw new IllegalArgumentException("Null policy");
        }
        if (baseRemoteContent == null) {
            throw new IllegalArgumentException("Null baseRemoteContent");
        }
        this.policy = policy;
        this.baseRemoteContent = baseRemoteContent;
        this.merge = false;
    }

    protected void handleAddition(String rootName, RepositoryItemMetadata item, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.handleAddition(rootName, item, null, mods);
    }

    protected void handleMissing(String rootName, RepositoryItemMetadata item, AbstractContentModificationGenerator.GeneratedModifications mods) {
        if (!item.isRemoved()) {
            this.handleRemoval(rootName, item, mods);
        } else {
            this.drainPrerejectedAdds(mods);
            mods.setPreapprovedAddParent(null);
            RepositoryItemMetadata prerejectedRemove = mods.getPrerejectedRemoveParent();
            if (prerejectedRemove != null && !item.isChildOf(prerejectedRemove)) {
                mods.setPrerejectedRemoveParent(null);
            }
            ContentModification preapprovedRemove = mods.peekPreapprovedRemoveParent();
            while (preapprovedRemove != null && !item.isChildOf(preapprovedRemove.getItem())) {
                mods.addModification(mods.popPreapprovedRemoveParent());
                preapprovedRemove = mods.peekPreapprovedRemoveParent();
            }
            ContentModification mod = new ContentModification(ContentModification.Type.REMOVAL_METADATA_FROM_CLUSTER, rootName, item);
            if (item.isDirectory()) {
                mods.pushPreapprovedRemoveParent(mod);
            } else {
                mods.addModification(mod);
            }
        }
    }

    protected void handleAddition(String rootName, RepositoryItemMetadata item, RepositoryItemMetadata removedVersion, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.drainPreapprovedRemovals(mods);
        mods.setPrerejectedRemoveParent(null);
        Boolean allow = null;
        RepositoryItemMetadata preapprovedAdd = mods.getPreapprovedAddParent();
        if (preapprovedAdd != null) {
            if (item.isChildOf(preapprovedAdd)) {
                allow = Boolean.TRUE;
            } else {
                mods.setPreapprovedAddParent(null);
            }
        } else {
            ContentModification prerejectedParentMod = mods.peekPrerejectedAddParent();
            while (prerejectedParentMod != null) {
                if (item.isChildOf(prerejectedParentMod.getItem())) {
                    allow = Boolean.FALSE;
                    break;
                }
                mods.addModification(mods.popPrerejectedAddParent());
                prerejectedParentMod = mods.peekPrerejectedAddParent();
            }
        }
        if (allow == null) {
            allow = this.isAdditionApproved(rootName, item, removedVersion);
        }
        if (allow.booleanValue()) {
            ContentModification.Type type = item.isDirectory() ? ContentModification.Type.MKDIR_TO_CLUSTER : ContentModification.Type.PUSH_TO_CLUSTER;
            mods.addModification(new ContentModification(type, rootName, item));
            if (mods.getPreapprovedAddParent() == null && item.isDirectory()) {
                mods.setPreapprovedAddParent(item);
            }
        } else {
            RepositoryItemMetadata modItem = removedVersion == null ? item : removedVersion;
            ContentModification mod = new ContentModification(ContentModification.Type.REMOVE_FROM_CLUSTER, rootName, modItem);
            if (item.isDirectory()) {
                mods.addModification(new ContentModification(ContentModification.Type.PREPARE_RMDIR_FROM_CLUSTER, rootName, modItem));
                mods.pushPrerejectedAddParent(mod);
            } else {
                mods.addModification(mod);
            }
            mods.setPreapprovedAddParent(null);
        }
    }

    protected void handleChangeFromDirectory(String rootName, RepositoryItemMetadata base, RepositoryItemMetadata modified, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.drainPreapprovedRemovals(mods);
        mods.setPrerejectedRemoveParent(null);
        this.drainPrerejectedAdds(mods);
        mods.setPreapprovedAddParent(null);
        boolean allow = this.checkAllowUpdate(base, modified);
        if (allow) {
            ContentModification mod = new ContentModification(ContentModification.Type.PUSH_TO_CLUSTER, rootName, modified);
            mods.pushPreapprovedRemoveParent(mod);
        } else {
            mods.setPrerejectedRemoveParent(base);
            mods.addModification(new ContentModification(ContentModification.Type.MKDIR_FROM_CLUSTER, rootName, base));
        }
    }

    protected void handleChangeToDirectory(String rootName, RepositoryItemMetadata base, RepositoryItemMetadata modified, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.drainPreapprovedRemovals(mods);
        mods.setPrerejectedRemoveParent(null);
        this.drainPrerejectedAdds(mods);
        mods.setPreapprovedAddParent(null);
        boolean allow = this.checkAllowUpdate(base, modified);
        if (allow) {
            mods.setPreapprovedAddParent(modified);
            mods.addModification(new ContentModification(ContentModification.Type.MKDIR_TO_CLUSTER, rootName, modified));
        } else {
            ContentModification mod = new ContentModification(ContentModification.Type.PULL_FROM_CLUSTER, rootName, base);
            mods.pushPrerejectedAddParent(mod);
        }
    }

    protected void handleRemoval(String rootName, RepositoryItemMetadata item, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.drainPrerejectedAdds(mods);
        mods.setPreapprovedAddParent(null);
        Boolean allow = null;
        RepositoryItemMetadata prerejected = mods.getPrerejectedRemoveParent();
        if (prerejected != null) {
            if (item.isChildOf(prerejected)) {
                allow = Boolean.FALSE;
            } else {
                mods.setPrerejectedRemoveParent(null);
            }
        } else {
            ContentModification preapprovedRemove = mods.peekPreapprovedRemoveParent();
            while (preapprovedRemove != null) {
                if (item.isChildOf(preapprovedRemove.getItem())) {
                    allow = Boolean.TRUE;
                    break;
                }
                mods.addModification(mods.popPreapprovedRemoveParent());
                preapprovedRemove = mods.peekPreapprovedRemoveParent();
            }
        }
        if (allow == null) {
            if (this.merge) {
                allow = this.policy.acceptMergeRemoval(item, null);
            } else {
                RepositoryItemMetadata baseRemoteItem = this.getBaseRemoteItem(rootName, item);
                allow = this.policy.acceptJoinRemoval(item, baseRemoteItem);
            }
        }
        if (allow.booleanValue()) {
            ContentModification mod = new ContentModification(ContentModification.Type.REMOVE_TO_CLUSTER, rootName, item);
            if (item.isDirectory()) {
                mods.addModification(new ContentModification(ContentModification.Type.PREPARE_RMDIR_TO_CLUSTER, rootName, item));
                mods.pushPreapprovedRemoveParent(mod);
            } else {
                mods.addModification(mod);
            }
        } else {
            ContentModification.Type type = item.isDirectory() ? ContentModification.Type.MKDIR_FROM_CLUSTER : ContentModification.Type.PULL_FROM_CLUSTER;
            mods.addModification(new ContentModification(type, rootName, item));
            if (mods.getPrerejectedRemoveParent() == null && item.isDirectory()) {
                mods.setPrerejectedRemoveParent(item);
            }
        }
    }

    protected void handleSimpleModification(String rootName, RepositoryItemMetadata base, RepositoryItemMetadata modified, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.drainPreapprovedRemovals(mods);
        mods.setPrerejectedRemoveParent(null);
        this.drainPrerejectedAdds(mods);
        mods.setPreapprovedAddParent(null);
        if (this.checkAllowUpdate(base, modified)) {
            mods.addModification(new ContentModification(ContentModification.Type.PUSH_TO_CLUSTER, rootName, modified));
        } else {
            mods.addModification(new ContentModification(ContentModification.Type.PULL_FROM_CLUSTER, rootName, base));
        }
    }

    protected void handleDirectoryTimestampModification(String rootName, RepositoryItemMetadata base, RepositoryItemMetadata modified, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.drainPreapprovedRemovals(mods);
        mods.setPrerejectedRemoveParent(null);
        this.drainPrerejectedAdds(mods);
        mods.setPreapprovedAddParent(null);
        mods.addModification(new ContentModification(ContentModification.Type.DIR_TIMESTAMP_MISMATCH, rootName, base));
    }

    private boolean checkAllowUpdate(RepositoryItemMetadata current, RepositoryItemMetadata update) {
        boolean allow = false;
        allow = this.merge ? this.policy.acceptMergeUpdate(update, current) : this.policy.acceptJoinUpdate(update, current);
        return allow;
    }

    private RepositoryItemMetadata getBaseRemoteItem(String rootName, RepositoryItemMetadata item) {
        RepositoryRootMetadata existingRoot;
        RepositoryItemMetadata existingItem = null;
        if (this.baseRemoteContent != null && (existingRoot = this.baseRemoteContent.getRepositoryRootMetadata(rootName)) != null) {
            existingItem = existingRoot.getItemMetadata(item.getRelativePathElements());
        }
        return existingItem;
    }

    private boolean isAdditionApproved(String rootName, RepositoryItemMetadata item, RepositoryItemMetadata removedVersion) {
        boolean allow;
        if (removedVersion == null) {
            if (this.merge) {
                allow = this.policy.acceptMergeAddition(item);
            } else {
                RepositoryItemMetadata baseRemoteItem = this.getBaseRemoteItem(rootName, item);
                allow = this.policy.acceptJoinAddition(item, baseRemoteItem);
            }
        } else {
            allow = this.merge ? this.policy.acceptMergeReincarnation(item, removedVersion) : this.policy.acceptJoinReincarnation(item, removedVersion);
        }
        return allow;
    }

    private void drainPrerejectedAdds(AbstractContentModificationGenerator.GeneratedModifications mods) {
        ContentModification prerejectedAdd;
        while ((prerejectedAdd = mods.popPrerejectedAddParent()) != null) {
            mods.addModification(prerejectedAdd);
        }
    }
}

