/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.collection;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.pojo.collection.CachedListAbstract;
import org.jboss.cache.pojo.collection.IntegerCache;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;
import org.jboss.cache.pojo.util.AopUtil;
import org.jboss.cache.pojo.util.CacheApiUtil;
import org.jboss.cache.pojo.util.Null;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedListImpl
extends CachedListAbstract {
    private static Log log_ = LogFactory.getLog((String)CachedListImpl.class.getName());
    private Cache<Object, Object> cache;
    private PojoCacheImpl pojoCache;
    private AbstractCollectionInterceptor interceptor;

    public CachedListImpl(PojoCacheImpl cache, AbstractCollectionInterceptor interceptor) {
        this.pojoCache = cache;
        this.cache = this.pojoCache.getCache();
        this.interceptor = interceptor;
    }

    private Fqn getFqn() {
        return this.interceptor.getFqn();
    }

    private Set<Node> getNodeChildren() {
        return CacheApiUtil.getNodeChildren(this.cache, this.getFqn());
    }

    private Object XwriteReplace() throws ObjectStreamException {
        log_.warn((Object)"writeReplace(): this calss is not suppored to be serialized. Will substitue with a normal ArryList");
        ArrayList toSerialize = new ArrayList();
        toSerialize.addAll(this);
        return toSerialize;
    }

    public Object get(int index) {
        CachedListImpl.checkIndex();
        return Null.toNullValue(this.pojoCache.find(AopUtil.constructFqn(this.getFqn(), IntegerCache.toString(index))));
    }

    private static void checkIndex() {
    }

    @Override
    public int size() {
        Set<Node> children = this.getNodeChildren();
        return children == null ? 0 : children.size();
    }

    public Object set(int index, Object element) {
        if (index != 0) {
            CachedListImpl.checkIndex();
        }
        return Null.toNullValue(this.attach(index, element, "SET"));
    }

    public void add(int index, Object element) {
        if (index != 0) {
            CachedListImpl.checkIndex();
        }
        for (int i = this.size(); i > index; --i) {
            Object obj = this.detach(i - 1);
            this.attach(i, obj);
        }
        this.attach(index, element, "ADD");
    }

    private Object attach(int i, Object obj) {
        return this.attach(i, obj, null);
    }

    private Object attach(int i, Object obj, String operation) {
        Fqn fqn = AopUtil.constructFqn(this.getFqn(), IntegerCache.toString(i));
        Object o = this.pojoCache.attach(fqn, Null.toNullObject(obj));
        if (operation != null) {
            this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)operation);
        }
        return o;
    }

    private Object detach(int i) {
        return this.detach(i, null);
    }

    private Object detach(int i, String operation) {
        Fqn fqn = AopUtil.constructFqn(this.getFqn(), IntegerCache.toString(i));
        if (operation != null) {
            this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)operation);
        }
        return this.pojoCache.detach(fqn);
    }

    @Override
    public int indexOf(Object o) {
        int size = this.size();
        if (o == null) {
            for (int i = 0; i < size; ++i) {
                if (null != this.get(i)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!o.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (null != this.get(i)) continue;
                return i;
            }
        } else {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (!o.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public Object remove(int index) {
        CachedListImpl.checkIndex();
        int size = this.size();
        Object result = Null.toNullValue(this.detach(index, "REMOVE"));
        if (size == index + 1) {
            return result;
        }
        for (int i = index; i < size - 1; ++i) {
            Object obj = this.detach(i + 1);
            this.attach(i, obj);
        }
        return result;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            int current = -1;
            int size = CachedListImpl.this.size();

            public boolean hasNext() {
                if (this.size == 0) {
                    return false;
                }
                if (this.current > this.size) {
                    throw new NoSuchElementException("CachedSetImpl.iterator.hasNext().  Cursor position " + this.current + " is greater than the size " + CachedListImpl.this.size());
                }
                return this.current < this.size - 1;
            }

            public Object next() {
                if (this.current == this.size) {
                    throw new NoSuchElementException("CachedSetImpl.iterator.next().  Cursor position " + this.current + " is greater than the size " + CachedListImpl.this.size());
                }
                return Null.toNullValue(CachedListImpl.this.pojoCache.find(AopUtil.constructFqn(CachedListImpl.this.getFqn(), IntegerCache.toString(++this.current))));
            }

            public void remove() {
                if (this.size == 0) {
                    return;
                }
                if (this.current == this.size) {
                    throw new IllegalStateException("CachedSetImpl.iterator.remove().  Cursor position " + this.current + " is greater than the size " + this.size);
                }
                if (this.current < this.size - 1) {
                    Object last = CachedListImpl.this.detach(this.current, "REMOVE");
                    for (int i = this.current + 1; i < this.size; ++i) {
                        last = CachedListImpl.this.detach(i);
                        CachedListImpl.this.attach(i - 1, last);
                    }
                } else {
                    CachedListImpl.this.detach(this.current, "REMOVE");
                }
                --this.current;
                --this.size;
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex + " but size() =" + this.size());
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex (" + fromIndex + ") must be less than toIndex(" + toIndex + ")");
        }
        if (fromIndex == toIndex) {
            return new LinkedList();
        }
        return new MyCachedSubListImpl(this, fromIndex, toIndex);
    }

    public ListIterator listIterator() {
        return new MyListIterator(this, 0);
    }

    public ListIterator listIterator(int index) {
        return new MyListIterator(this, index);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object key = this.get(i);
            if (key == this.interceptor.getBoundProxy()) {
                key = "(this list)";
            }
            buf.append("[").append(key).append("]");
            if (i > size) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static class MyCachedSubListImpl
    extends CachedListAbstract
    implements List {
        private List backStore_;
        private int fromIndex_;
        private int toIndex_;

        MyCachedSubListImpl(List backStore, int fromIndex, int toIndex) {
            this.backStore_ = backStore;
            this.fromIndex_ = fromIndex;
            this.toIndex_ = toIndex;
        }

        public int size() {
            int size = this.backStore_.size();
            if (size > this.toIndex_) {
                size = this.toIndex_;
            }
            return size -= this.fromIndex_;
        }

        public Iterator iterator() {
            return new Iterator(){
                int current = -1;
                Iterator iter_ = this.initializeIter();

                private Iterator initializeIter() {
                    Iterator iter = MyCachedSubListImpl.this.backStore_.iterator();
                    for (int looper = 0; looper < MyCachedSubListImpl.this.fromIndex_; ++looper) {
                        if (!iter.hasNext()) continue;
                        iter.next();
                    }
                    return iter;
                }

                public boolean hasNext() {
                    int size = MyCachedSubListImpl.this.size();
                    if (size == 0) {
                        return false;
                    }
                    if (this.current > size) {
                        throw new IllegalStateException("CachedSetImpl.MyCachedSubListImpl.iterator.hasNext().  Cursor position " + this.current + " is greater than the size " + MyCachedSubListImpl.this.size());
                    }
                    return this.current < MyCachedSubListImpl.this.size() - 1;
                }

                public Object next() {
                    if (this.current == MyCachedSubListImpl.this.size()) {
                        throw new IllegalStateException("CachedSetImpl.MyCachedSubListImpl.iterator.next().  Cursor position " + this.current + " is greater than the size " + MyCachedSubListImpl.this.size());
                    }
                    ++this.current;
                    return this.iter_.next();
                }

                public void remove() {
                    this.iter_.remove();
                    --this.current;
                }
            };
        }

        public Object get(int index) {
            this.checkIndex(index);
            return this.backStore_.get(index + this.fromIndex_);
        }

        public Object set(int index, Object element) {
            this.checkIndex(index);
            return this.backStore_.set(index + this.fromIndex_, element);
        }

        public void add(int index, Object element) {
            this.backStore_.add(index + this.fromIndex_, element);
        }

        public Object remove(int index) {
            return this.backStore_.remove(index + this.fromIndex_);
        }

        public int indexOf(Object o) {
            int index = this.backStore_.indexOf(o);
            index = index < this.fromIndex_ || index >= this.toIndex_ ? -1 : (index -= this.fromIndex_);
            return index;
        }

        public int lastIndexOf(Object o) {
            int index = this.backStore_.lastIndexOf(o);
            index = index < this.fromIndex_ || index >= this.toIndex_ ? -1 : (index -= this.fromIndex_);
            return index;
        }

        public ListIterator listIterator() {
            return new MyListIterator(this, 0);
        }

        public ListIterator listIterator(int index) {
            return new MyListIterator(this, index);
        }

        public List subList(int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > this.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex + " but size() =" + this.size());
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex (" + fromIndex + ") must be less than toIndex(" + toIndex + ")");
            }
            if (fromIndex == toIndex) {
                return new LinkedList();
            }
            return new MyCachedSubListImpl(this, fromIndex, toIndex);
        }

        private void checkIndex(int i) {
            if (this.size() == 0) {
                return;
            }
            if (i < 0 || i >= this.size()) {
                throw new IndexOutOfBoundsException("Index out of bound at CachedListImpl(). Index is " + i + " but size is " + this.size());
            }
        }
    }

    static class MyListIterator
    implements ListIterator {
        int index = 0;
        List list_;

        public MyListIterator(List list, int index) {
            this.list_ = list;
            if (index < 0 || index > this.list_.size()) {
                throw new IndexOutOfBoundsException("CachedListImpl: MyListIterator construction.  Index is out of bound : " + index);
            }
            this.index = index;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            int size = this.list_.size();
            if (size == 0) {
                return;
            }
            if (this.previousIndex() == size) {
                throw new IllegalStateException("CachedSetImpl.MyListIterator.remove().  Cursor position " + this.index + " is greater than the size " + size);
            }
            if (this.previousIndex() < size) {
                this.list_.remove(this.previousIndex());
                --this.index;
            }
        }

        public boolean hasNext() {
            return this.index < this.list_.size();
        }

        public boolean hasPrevious() {
            return this.index != 0;
        }

        public Object next() {
            if (this.index == this.list_.size()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return this.list_.get(this.index - 1);
        }

        public Object previous() {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            --this.index;
            return this.list_.get(this.index);
        }

        public void add(Object o) {
            int size = this.list_.size();
            if (size == 0) {
                return;
            }
            if (this.previousIndex() == size) {
                throw new IllegalStateException("CachedSetImpl.MyListIterator.add().  Cursor position " + this.index + " is greater than the size " + size);
            }
            if (this.previousIndex() < size) {
                this.list_.add(this.previousIndex(), o);
            }
        }

        public void set(Object o) {
            int size = this.list_.size();
            if (size == 0) {
                return;
            }
            if (this.previousIndex() == size) {
                throw new IllegalStateException("CachedSetImpl.MyListIterator.set().  Cursor position " + this.index + " is greater than the size " + size);
            }
            if (this.previousIndex() < size) {
                this.list_.set(this.previousIndex(), o);
            }
        }
    }
}

