/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm;

import org.jboss.ws.extensions.wsrm.RMDeliveryAssurance;
import org.jboss.ws.extensions.wsrm.RMDeliveryQuality;

public final class RMDeliveryAssuranceFactory {
    private static final RMDeliveryAssuranceFactory INSTANCE = new RMDeliveryAssuranceFactory();
    private static final String[] ACCEPTABLE_IN_ORDER_VALUES = new String[]{"0", "1", "false", "true"};
    private static final RMDeliveryAssurance EXACTLY_ONCE_WITH_ORDER = new DeliveryAssuranceImpl(RMDeliveryQuality.EXACTLY_ONCE, true);
    private static final RMDeliveryAssurance EXACTLY_ONCE_WITHOUT_ORDER = new DeliveryAssuranceImpl(RMDeliveryQuality.EXACTLY_ONCE, false);
    private static final RMDeliveryAssurance AT_MOST_ONCE_WITH_ORDER = new DeliveryAssuranceImpl(RMDeliveryQuality.AT_MOST_ONCE, true);
    private static final RMDeliveryAssurance AT_MOST_ONCE_WITHOUT_ORDER = new DeliveryAssuranceImpl(RMDeliveryQuality.AT_MOST_ONCE, false);
    private static final RMDeliveryAssurance AT_LEAST_ONCE_WITH_ORDER = new DeliveryAssuranceImpl(RMDeliveryQuality.AT_LEAST_ONCE, true);
    private static final RMDeliveryAssurance AT_LEAST_ONCE_WITHOUT_ORDER = new DeliveryAssuranceImpl(RMDeliveryQuality.AT_LEAST_ONCE, false);

    private RMDeliveryAssuranceFactory() {
    }

    public static RMDeliveryAssuranceFactory getInstance() {
        return INSTANCE;
    }

    public static RMDeliveryAssurance getDeliveryAssurance(String quality, String inOrder) {
        if (quality == null || inOrder == null) {
            throw new IllegalArgumentException("Neither quality nor inOrder parameter cannot be null");
        }
        Boolean inOrderBoolean = null;
        for (int i = 0; i < ACCEPTABLE_IN_ORDER_VALUES.length; ++i) {
            if (!ACCEPTABLE_IN_ORDER_VALUES[i].equals(inOrder)) continue;
            inOrderBoolean = i % 2 == 0 ? Boolean.FALSE : Boolean.TRUE;
            break;
        }
        if (inOrderBoolean == null) {
            throw new IllegalArgumentException("Incorrect inOrder value: " + inOrder);
        }
        return RMDeliveryAssuranceFactory.getDeliveryAssurance(RMDeliveryQuality.parseDeliveryQuality(quality), inOrderBoolean);
    }

    public static RMDeliveryAssurance getDeliveryAssurance(RMDeliveryQuality quality, boolean inOrder) {
        if (quality == null) {
            throw new IllegalArgumentException("Quality cannot be null");
        }
        if (inOrder) {
            if (quality == RMDeliveryQuality.EXACTLY_ONCE) {
                return EXACTLY_ONCE_WITH_ORDER;
            }
            if (quality == RMDeliveryQuality.AT_LEAST_ONCE) {
                return AT_LEAST_ONCE_WITH_ORDER;
            }
            if (quality == RMDeliveryQuality.AT_MOST_ONCE) {
                return AT_MOST_ONCE_WITH_ORDER;
            }
        } else {
            if (quality == RMDeliveryQuality.EXACTLY_ONCE) {
                return EXACTLY_ONCE_WITHOUT_ORDER;
            }
            if (quality == RMDeliveryQuality.AT_LEAST_ONCE) {
                return AT_LEAST_ONCE_WITHOUT_ORDER;
            }
            if (quality == RMDeliveryQuality.AT_MOST_ONCE) {
                return AT_MOST_ONCE_WITHOUT_ORDER;
            }
        }
        return null;
    }

    private static final class DeliveryAssuranceImpl
    implements RMDeliveryAssurance {
        private final RMDeliveryQuality quality;
        private final boolean inOrder;

        private DeliveryAssuranceImpl(RMDeliveryQuality quality, boolean inOrder) {
            this.quality = quality;
            this.inOrder = inOrder;
        }

        public RMDeliveryQuality getDeliveryQuality() {
            return this.quality;
        }

        public boolean inOrder() {
            return this.inOrder;
        }
    }
}

