/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.forum.service.Utils;

public class UserProfile {
    public static final long ADMIN = 0L;
    public static final long MODERATOR = 1L;
    public static final long USER = 2L;
    public static final long GUEST = 3L;
    public static final String USER_GUEST = "user_gest_uoom";
    private String userId = "user_gest_uoom";
    private String screenName;
    private String userTitle = "Guest";
    private long userRole = 3L;
    private String signature = "";
    private long totalPost = 0L;
    private long totalTopic = 0L;
    private long jobWattingForModerator = 0L;
    private boolean isOnline = false;
    private String[] moderateForums;
    private String[] moderateCategory;
    private String[] readTopic;
    private Map<String, Long> lastAccessTopics = new HashMap<String, Long>();
    private String[] readForum;
    private Map<String, Long> lastAccessForums = new HashMap<String, Long>();
    private String[] bookmark;
    private String[] lastReadPostOfTopic;
    private String[] lastReadPostOfForum;
    private Map<String, String> lastPostIdReadOfTopic = new HashMap<String, String>();
    private Map<String, String> lastPostIdReadOfForum = new HashMap<String, String>();
    private Date joinedDate = null;
    private Date lastLoginDate = null;
    private String fullName = "";
    private String firstName = "";
    private String lastName = "";
    private String email = "";
    private Date lastPostDate = null;
    private boolean isDisplaySignature = true;
    private boolean isDisplayAvatar = true;
    private Double timeZone;
    private String shortDateformat;
    private String longDateformat;
    private String timeFormat;
    private long maxTopic = 10L;
    private long maxPost = 10L;
    private boolean isShowForumJump = true;
    private boolean isAutoWatchMyTopics = false;
    private boolean isAutoWatchTopicIPost = false;
    private String[] collapCategories;
    private boolean isBanned = false;
    private long banUntil = 0L;
    private String banReason;
    private int banCounter = 0;
    private String[] banReasonSummary;
    private Date createdDateBan;
    private long newMessage = 0L;
    private long totalMessage = 0L;

    public UserProfile() {
        this.moderateForums = new String[0];
        this.readTopic = new String[0];
        this.bookmark = new String[0];
        this.banReasonSummary = new String[0];
        this.collapCategories = new String[0];
        this.lastReadPostOfTopic = new String[]{" "};
        this.lastReadPostOfForum = new String[]{" "};
        Date dateHost = new Date();
        this.timeZone = (double)dateHost.getTimezoneOffset() / 60.0;
        this.shortDateformat = "MM/dd/yyyy";
        this.longDateformat = "DDD,MMM dd,yyyy";
        this.timeFormat = "hh:mm a";
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserTitle(String userTitle) {
        this.userTitle = userTitle;
    }

    public String getUserTitle() {
        return this.userTitle;
    }

    public void setUserRole(Long userRole) {
        this.userRole = userRole;
    }

    public Long getUserRole() {
        return this.userRole;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setTotalPost(Long totalPost) {
        this.totalPost = totalPost;
    }

    public Long getTotalPost() {
        return this.totalPost;
    }

    public void setTotalTopic(Long totalTopic) {
        this.totalTopic = totalTopic;
    }

    public Long getTotalTopic() {
        return this.totalTopic;
    }

    public long getJobWattingForModerator() {
        return this.jobWattingForModerator;
    }

    public void setJobWattingForModerator(long jobWattingForModerator) {
        this.jobWattingForModerator = jobWattingForModerator;
    }

    public void setModerateForums(String[] moderateForums) {
        this.moderateForums = Utils.arrayCopy(moderateForums);
    }

    public String[] getModerateForums() {
        return this.moderateForums;
    }

    public String[] getModerateCategory() {
        return this.moderateCategory;
    }

    public void setModerateCategory(String[] moderateCategory) {
        this.moderateCategory = Utils.arrayCopy(moderateCategory);
    }

    public String[] getReadTopic() {
        return this.readTopic;
    }

    public void setReadTopic(String[] readTopic) {
        this.readTopic = readTopic;
    }

    public String[] getReadForum() {
        return this.readForum;
    }

    public void setReadForum(String[] readForum) {
        this.readForum = readForum;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setJoinedDate(Date joinDate) {
        this.joinedDate = joinDate;
    }

    public Date getJoinedDate() {
        return this.joinedDate;
    }

    public void setLastPostDate(Date lastPostDate) {
        this.lastPostDate = lastPostDate;
    }

    public Date getLastPostDate() {
        return this.lastPostDate;
    }

    public void setIsDisplaySignature(boolean isDisplaySignature) {
        this.isDisplaySignature = isDisplaySignature;
    }

    public boolean getIsDisplaySignature() {
        return this.isDisplaySignature;
    }

    public void setIsDisplayAvatar(boolean isDisplayAvatar) {
        this.isDisplayAvatar = isDisplayAvatar;
    }

    public boolean getIsDisplayAvatar() {
        return this.isDisplayAvatar;
    }

    public void setTimeZone(Double timeZone) {
        this.timeZone = timeZone;
    }

    public double getTimeZone() {
        return this.timeZone;
    }

    public void setShortDateFormat(String shortDateformat) {
        this.shortDateformat = shortDateformat;
    }

    public String getShortDateFormat() {
        return this.shortDateformat;
    }

    public void setLongDateFormat(String longDateformat) {
        this.longDateformat = longDateformat;
    }

    public String getLongDateFormat() {
        return this.longDateformat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setMaxTopicInPage(long maxTopic) {
        this.maxTopic = maxTopic;
    }

    public Long getMaxTopicInPage() {
        return this.maxTopic;
    }

    public void setMaxPostInPage(long maxPost) {
        this.maxPost = maxPost;
    }

    public Long getMaxPostInPage() {
        return this.maxPost;
    }

    public void setIsShowForumJump(boolean isShowForumJump) {
        this.isShowForumJump = isShowForumJump;
    }

    public boolean getIsShowForumJump() {
        return this.isShowForumJump;
    }

    public boolean getIsAutoWatchMyTopics() {
        return this.isAutoWatchMyTopics;
    }

    public void setIsAutoWatchMyTopics(boolean isAutoWatchMyTopics) {
        this.isAutoWatchMyTopics = isAutoWatchMyTopics;
    }

    public boolean getIsAutoWatchTopicIPost() {
        return this.isAutoWatchTopicIPost;
    }

    public void setIsAutoWatchTopicIPost(boolean isAutoWatchTopicIPost) {
        this.isAutoWatchTopicIPost = isAutoWatchTopicIPost;
    }

    public String[] getCollapCategories() {
        return this.collapCategories;
    }

    public void setCollapCategories(String[] collapCategories) {
        this.collapCategories = Utils.arrayCopy(collapCategories);
    }

    public void setIsBanned(boolean isBanned) {
        this.isBanned = isBanned;
    }

    public boolean getIsBanned() {
        return this.isBanned;
    }

    public void setBanUntil(long banUntil) {
        this.banUntil = banUntil;
    }

    public Long getBanUntil() {
        return this.banUntil;
    }

    public void setBanReason(String banReason) {
        this.banReason = banReason;
    }

    public String getBanReason() {
        return this.banReason;
    }

    public void setBanCounter(int banCounter) {
        this.banCounter = banCounter;
    }

    public int getBanCounter() {
        return this.banCounter;
    }

    public void setBanReasonSummary(String[] banReasonSummary) {
        this.banReasonSummary = Utils.arrayCopy(banReasonSummary);
    }

    public String[] getBanReasonSummary() {
        return this.banReasonSummary;
    }

    public void setCreatedDateBan(Date createdDate) {
        this.createdDateBan = createdDate;
    }

    public Date getCreatedDateBan() {
        return this.createdDateBan;
    }

    public String[] getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(String[] bookmark) {
        this.bookmark = Utils.arrayCopy(bookmark);
    }

    public String[] getLastReadPostOfTopic() {
        return this.lastReadPostOfTopic;
    }

    public void setLastReadPostOfTopic(String[] lastReadPostOfTopic) {
        this.lastReadPostOfTopic = lastReadPostOfTopic;
        this.lastPostIdReadOfTopic = Utils.arrayToMap(lastReadPostOfTopic);
    }

    public String getLastPostIdReadOfTopic(String topicId) {
        if (this.lastPostIdReadOfTopic.containsKey(topicId)) {
            return this.lastPostIdReadOfTopic.get(topicId);
        }
        return "";
    }

    public void addLastPostIdReadOfTopic(String topicId, String postId) {
        this.lastPostIdReadOfTopic.put(topicId, postId);
        this.lastReadPostOfTopic = Utils.mapToArray(this.lastPostIdReadOfTopic);
    }

    public String[] getLastReadPostOfForum() {
        return this.lastReadPostOfForum;
    }

    public void setLastReadPostOfForum(String[] lastReadPostOfForum) {
        this.lastReadPostOfForum = lastReadPostOfForum;
        this.lastPostIdReadOfForum = Utils.arrayToMap(lastReadPostOfForum);
    }

    public String getLastPostIdReadOfForum(String forumId) {
        if (this.lastPostIdReadOfForum.containsKey(forumId)) {
            return this.lastPostIdReadOfForum.get(forumId);
        }
        return "";
    }

    public void addLastPostIdReadOfForum(String forumId, String postId) {
        this.lastPostIdReadOfForum.put(forumId, postId);
        this.lastReadPostOfForum = Utils.mapToArray(this.lastPostIdReadOfForum);
    }

    public boolean getIsOnline() {
        return this.isOnline;
    }

    public void setIsOnline(boolean isOnline) {
        this.isOnline = isOnline;
    }

    public long getNewMessage() {
        return this.newMessage;
    }

    public void setNewMessage(long isNewMessage) {
        this.newMessage = isNewMessage;
    }

    public long getTotalMessage() {
        return this.totalMessage;
    }

    public void setTotalMessage(long totalMessage) {
        this.totalMessage = totalMessage;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getScreenName() {
        if (this.screenName == null || this.screenName.trim().length() == 0) {
            this.screenName = this.userId;
        }
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setLastTimeAccessTopic(String topicId, long lastTime) throws Exception {
        this.lastAccessTopics.put(topicId, lastTime);
    }

    public long getLastTimeAccessTopic(String topicId) throws Exception {
        if (this.lastAccessTopics.get(topicId) != null) {
            return this.lastAccessTopics.get(topicId);
        }
        return 0L;
    }

    public void setLastTimeAccessForum(String forumId, long lastTime) throws Exception {
        this.lastAccessForums.put(forumId, lastTime);
    }

    public long getLastTimeAccessForum(String forumId) throws Exception {
        if (this.lastAccessForums.get(forumId) != null) {
            return this.lastAccessForums.get(forumId);
        }
        return 0L;
    }
}

