/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.Identity;
import java.security.Principal;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulSessionContextDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulSessionContextImpl
implements Serializable,
SessionContext {
    private static final long serialVersionUID = 1L;
    private String containerGuid;
    private String containerClusterUid;
    private Object id;
    private boolean isClustered;
    private transient SessionContext delegate;

    public StatefulSessionContextImpl(String containerGuid, String containerClusterUid, Object id, boolean isClustered) {
        assert (containerGuid != null) : "containerGuid is null";
        assert (containerClusterUid != null) : "containerClusterUid is null";
        this.containerGuid = containerGuid;
        this.containerClusterUid = containerClusterUid;
        this.id = id;
        this.isClustered = isClustered;
    }

    public StatefulSessionContextImpl(StatefulBeanContext beanContext) {
        assert (beanContext != null) : "beanContext is null";
        this.delegate = new StatefulSessionContextDelegate(beanContext);
        this.containerGuid = Ejb3Registry.guid(beanContext.getContainer());
        this.containerClusterUid = Ejb3Registry.clusterUid(beanContext.getContainer());
        this.id = beanContext.getId();
        this.isClustered = beanContext.getContainer().isClustered();
    }

    private Object writeReplace() throws ObjectStreamException {
        Serialized s = new Serialized();
        s.containerGuid = this.containerGuid;
        s.containerClusterUid = this.containerClusterUid;
        s.id = this.id;
        s.isClustered = this.isClustered;
        return s;
    }

    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        return (T)this.getDelegate().getBusinessObject(businessInterface);
    }

    protected SessionContext getDelegate() {
        if (this.delegate == null) {
            StatefulContainer container = (StatefulContainer)Ejb3Registry.getContainer(this.containerGuid);
            if (container == null && this.isClustered) {
                container = (StatefulContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid);
            }
            this.delegate = new StatefulSessionContextDelegate(container.getCache().get(this.id, false));
        }
        return this.delegate;
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        return this.getDelegate().getEJBLocalObject();
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        return this.getDelegate().getEJBObject();
    }

    public Class<?> getInvokedBusinessInterface() throws IllegalStateException {
        return this.getDelegate().getInvokedBusinessInterface();
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        return this.getDelegate().getMessageContext();
    }

    public Identity getCallerIdentity() {
        return this.getDelegate().getCallerIdentity();
    }

    public Principal getCallerPrincipal() {
        return this.getDelegate().getCallerPrincipal();
    }

    public EJBHome getEJBHome() {
        return this.getDelegate().getEJBHome();
    }

    public EJBLocalHome getEJBLocalHome() {
        return this.getDelegate().getEJBLocalHome();
    }

    public Properties getEnvironment() {
        return this.getDelegate().getEnvironment();
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        return this.getDelegate().getRollbackOnly();
    }

    public TimerService getTimerService() throws IllegalStateException {
        return this.getDelegate().getTimerService();
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        return this.getDelegate().getUserTransaction();
    }

    public boolean isCallerInRole(Identity role) {
        return this.getDelegate().isCallerInRole(role);
    }

    public boolean isCallerInRole(String roleName) {
        return this.getDelegate().isCallerInRole(roleName);
    }

    public Object lookup(String name) {
        return this.getDelegate().lookup(name);
    }

    public void setRollbackOnly() throws IllegalStateException {
        this.getDelegate().setRollbackOnly();
    }

    public String toString() {
        return super.toString() + "{containerGuid=" + this.containerGuid + ",id=" + this.id + "}";
    }

    private static class Serialized
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Object id;
        private String containerClusterUid;
        private String containerGuid;
        private boolean isClustered;

        private Serialized() {
        }

        private Object readResolve() throws ObjectStreamException {
            return new StatefulSessionContextImpl(this.containerGuid, this.containerClusterUid, this.id, this.isClustered);
        }
    }
}

