/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap.api.helpers;

import org.jboss.webbeans.bootstrap.api.Bootstrap;
import org.jboss.webbeans.bootstrap.api.Environment;
import org.jboss.webbeans.bootstrap.api.Environments;
import org.jboss.webbeans.bootstrap.api.Service;
import org.jboss.webbeans.bootstrap.api.ServiceRegistry;
import org.jboss.webbeans.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.transaction.spi.TransactionServices;

public abstract class AbstractBootstrap
implements Bootstrap {
    private final ServiceRegistry simpleServiceRegistry;
    private Environment environment = Environments.EE;
    private BeanStore applicationContext;

    public AbstractBootstrap() {
        this.simpleServiceRegistry = new SimpleServiceRegistry();
    }

    @Deprecated
    public void setEjbServices(EjbServices ejbServices) {
        this.getServices().add(EjbServices.class, ejbServices);
    }

    @Deprecated
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.getServices().add(ResourceLoader.class, resourceLoader);
    }

    @Deprecated
    public void setWebBeanDiscovery(WebBeanDiscovery webBeanDiscovery) {
        this.getServices().add(WebBeanDiscovery.class, webBeanDiscovery);
    }

    @Deprecated
    public void setTransactionServices(TransactionServices transactionServices) {
        this.getServices().add(TransactionServices.class, transactionServices);
    }

    @Deprecated
    public WebBeanDiscovery getWebBeanDiscovery() {
        return this.getServices().get(WebBeanDiscovery.class);
    }

    @Deprecated
    public ResourceLoader getResourceLoader() {
        return this.getServices().get(ResourceLoader.class);
    }

    @Deprecated
    public EjbServices getEjbServices() {
        return this.getServices().get(EjbServices.class);
    }

    @Deprecated
    public TransactionServices getTransactionServices() {
        return this.getServices().get(TransactionServices.class);
    }

    public BeanStore getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(BeanStore applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected void verify() {
        for (Class<? extends Service> serviceType : this.environment.getRequiredServices()) {
            if (this.getServices().contains(serviceType)) continue;
            throw new IllegalStateException("Required service " + serviceType.getName() + " has not been specified");
        }
    }

    public ServiceRegistry getServices() {
        return this.simpleServiceRegistry;
    }
}

