/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.el.Expression;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;

public final class DevTools {
    private static final String TS = "&lt;";
    private static final String ERROR_TEMPLATE = "META-INF/rsc/facelet-dev-error.xml";
    private static String[] ERROR_PARTS;
    private static final String DEBUG_TEMPLATE = "META-INF/rsc/facelet-dev-debug.xml";
    private static String[] DEBUG_PARTS;
    private static final String[] IGNORE;

    public static void main(String[] argv) throws Exception {
        DevTools.init();
    }

    private static void init() throws IOException {
        if (ERROR_PARTS == null) {
            ERROR_PARTS = DevTools.splitTemplate(ERROR_TEMPLATE);
        }
        if (DEBUG_PARTS == null) {
            DEBUG_PARTS = DevTools.splitTemplate(DEBUG_TEMPLATE);
        }
    }

    private static String[] splitTemplate(String rsc) throws IOException {
        int read;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(rsc);
        if (is == null) {
            throw new FileNotFoundException(rsc);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[512];
        while ((read = is.read(buff)) != -1) {
            baos.write(buff, 0, read);
        }
        String str = baos.toString();
        return str.split("@@");
    }

    public static void debugHtml(Writer writer, FacesContext faces, Exception e) throws IOException {
        DevTools.init();
        Date now = new Date();
        for (int i = 0; i < ERROR_PARTS.length; ++i) {
            if ("message".equals(ERROR_PARTS[i])) {
                String msg = e.getMessage();
                if (msg != null) {
                    writer.write(msg.replaceAll("<", TS));
                    continue;
                }
                writer.write(e.getClass().getName());
                continue;
            }
            if ("trace".equals(ERROR_PARTS[i])) {
                DevTools.writeException(writer, e);
                continue;
            }
            if ("now".equals(ERROR_PARTS[i])) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(ERROR_PARTS[i])) {
                DevTools.writeComponent(writer, (UIComponent)faces.getViewRoot());
                continue;
            }
            if ("vars".equals(ERROR_PARTS[i])) {
                DevTools.writeVariables(writer, faces);
                continue;
            }
            writer.write(ERROR_PARTS[i]);
        }
    }

    private static void writeException(Writer writer, Exception e) throws IOException {
        StringWriter str = new StringWriter(256);
        PrintWriter pstr = new PrintWriter(str);
        e.printStackTrace(pstr);
        pstr.close();
        writer.write(str.toString().replaceAll("<", TS));
    }

    public static void debugHtml(Writer writer, FacesContext faces) throws IOException {
        DevTools.init();
        Date now = new Date();
        for (int i = 0; i < DEBUG_PARTS.length; ++i) {
            if ("message".equals(DEBUG_PARTS[i])) {
                writer.write(faces.getViewRoot().getViewId());
                continue;
            }
            if ("now".equals(DEBUG_PARTS[i])) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(DEBUG_PARTS[i])) {
                DevTools.writeComponent(writer, (UIComponent)faces.getViewRoot());
                continue;
            }
            if ("vars".equals(DEBUG_PARTS[i])) {
                DevTools.writeVariables(writer, faces);
                continue;
            }
            writer.write(DEBUG_PARTS[i]);
        }
    }

    private static void writeVariables(Writer writer, FacesContext faces) throws IOException {
        ExternalContext ctx = faces.getExternalContext();
        DevTools.writeVariables(writer, ctx.getRequestParameterMap(), "Request Parameters");
        DevTools.writeVariables(writer, ctx.getRequestMap(), "Request Attributes");
        if (ctx.getSession(false) != null) {
            DevTools.writeVariables(writer, ctx.getSessionMap(), "Session Attributes");
        }
        DevTools.writeVariables(writer, ctx.getApplicationMap(), "Application Attributes");
    }

    private static void writeVariables(Writer writer, Map vars, String caption) throws IOException {
        writer.write("<table><caption>");
        writer.write(caption);
        writer.write("</caption><thead><tr><th style=\"width: 10%; \">Name</th><th style=\"width: 90%; \">Value</th></tr></thead><tbody>");
        boolean written = false;
        if (!vars.isEmpty()) {
            TreeMap map = new TreeMap(vars);
            Map.Entry entry = null;
            String key = null;
            Iterator itr = map.entrySet().iterator();
            while (itr.hasNext()) {
                entry = itr.next();
                key = entry.getKey().toString();
                if (key.indexOf(46) != -1) continue;
                writer.write("<tr><td>");
                writer.write(key.replaceAll("<", TS));
                writer.write("</td><td>");
                writer.write(entry.getValue() == null ? "null" : entry.getValue().toString().replaceAll("<", TS));
                writer.write("</td></tr>");
                written = true;
            }
        }
        if (!written) {
            writer.write("<tr><td colspan=\"2\"><em>None</em></td></tr>");
        }
        writer.write("</tbody></table>");
    }

    private static void writeComponent(Writer writer, UIComponent c) throws IOException {
        writer.write("<dl><dt");
        if (DevTools.isText(c)) {
            writer.write(" class=\"uicText\"");
        }
        writer.write(">");
        boolean hasChildren = c.getChildCount() > 0 || c.getFacets().size() > 0;
        DevTools.writeStart(writer, c, hasChildren);
        writer.write("</dt>");
        if (hasChildren) {
            if (c.getFacets().size() > 0) {
                Iterator itr = c.getFacets().entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    writer.write("<dd class=\"uicFacet\">");
                    writer.write("<span>");
                    writer.write((String)entry.getKey());
                    writer.write("</span>");
                    DevTools.writeComponent(writer, (UIComponent)entry.getValue());
                    writer.write("</dd>");
                }
            }
            if (c.getChildCount() > 0) {
                Iterator itr = c.getChildren().iterator();
                while (itr.hasNext()) {
                    writer.write("<dd>");
                    DevTools.writeComponent(writer, (UIComponent)itr.next());
                    writer.write("</dd>");
                }
            }
            writer.write("<dt>");
            DevTools.writeEnd(writer, c);
            writer.write("</dt>");
        }
        writer.write("</dl>");
    }

    private static void writeEnd(Writer writer, UIComponent c) throws IOException {
        if (!DevTools.isText(c)) {
            writer.write(TS);
            writer.write(47);
            writer.write(DevTools.getName(c));
            writer.write(62);
        }
    }

    private static void writeAttributes(Writer writer, UIComponent c) {
        try {
            BeanInfo info = Introspector.getBeanInfo(c.getClass());
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            Method m = null;
            Object v = null;
            String str = null;
            for (int i = 0; i < pd.length; ++i) {
                if (pd[i].getWriteMethod() == null || Arrays.binarySearch(IGNORE, pd[i].getName()) >= 0) continue;
                m = pd[i].getReadMethod();
                try {
                    v = m.invoke((Object)c, null);
                    if (v == null || v instanceof Collection || v instanceof Map || v instanceof Iterator) continue;
                    writer.write(" ");
                    writer.write(pd[i].getName());
                    writer.write("=\"");
                    str = v instanceof Expression ? ((Expression)v).getExpressionString() : (v instanceof ValueBinding ? ((ValueBinding)v).getExpressionString() : (v instanceof MethodBinding ? ((MethodBinding)v).getExpressionString() : v.toString()));
                    writer.write(str.replaceAll("<", TS));
                    writer.write("\"");
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ValueBinding binding = c.getValueBinding("binding");
            if (binding != null) {
                writer.write(" binding=\"");
                writer.write(binding.getExpressionString().replaceAll("<", TS));
                writer.write("\"");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void writeStart(Writer writer, UIComponent c, boolean children) throws IOException {
        if (DevTools.isText(c)) {
            String str = c.toString().trim();
            writer.write(str.replaceAll("<", TS));
        } else {
            writer.write(TS);
            writer.write(DevTools.getName(c));
            DevTools.writeAttributes(writer, c);
            if (children) {
                writer.write(62);
            } else {
                writer.write("/>");
            }
        }
    }

    private static String getName(UIComponent c) {
        String nm = c.getClass().getName();
        return nm.substring(nm.lastIndexOf(46) + 1);
    }

    private static boolean isText(UIComponent c) {
        return c.getClass().getName().startsWith("com.sun.facelets.compiler");
    }

    static {
        IGNORE = new String[]{"parent", "rendererType"};
    }
}

