/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.bayeux.request;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.apache.tomcat.bayeux.BayeuxException;
import org.apache.tomcat.bayeux.BayeuxRequest;
import org.apache.tomcat.bayeux.ChannelImpl;
import org.apache.tomcat.bayeux.ClientImpl;
import org.apache.tomcat.bayeux.HttpError;
import org.apache.tomcat.bayeux.MessageImpl;
import org.apache.tomcat.bayeux.RequestBase;
import org.apache.tomcat.bayeux.TomcatBayeux;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.jboss.servlet.http.HttpEvent;

public class PublishRequest
extends RequestBase
implements BayeuxRequest {
    JSONObject msgData = null;
    protected static HashMap<String, Object> responseTemplate = new HashMap();

    public PublishRequest(TomcatBayeux tb, HttpEvent event, JSONObject jsReq) throws JSONException {
        super(tb, event, jsReq);
    }

    public HttpError validate() {
        if (this.channel == null || !this.getTomcatBayeux().hasChannel(this.channel)) {
            return new HttpError(400, "Channel Id not valid.", null);
        }
        if (this.data == null || this.data.length() == 0) {
            return new HttpError(400, "Message data missing.", null);
        }
        try {
            this.msgData = new JSONObject(this.data);
        }
        catch (JSONException x) {
            return new HttpError(400, "Invalid JSON object in data attribute.", x);
        }
        if (this.clientId == null || !this.getTomcatBayeux().hasClient(this.clientId)) {
            return new HttpError(400, "Client Id not valid.", null);
        }
        return null;
    }

    public int process(int prevops) throws BayeuxException {
        prevops = super.process(prevops);
        this.response = (HashMap)responseTemplate.clone();
        ClientImpl client = this.clientId != null ? (ClientImpl)this.getTomcatBayeux().getClient(this.clientId) : (ClientImpl)this.event.getHttpServletRequest().getAttribute("client");
        boolean success = false;
        HttpError error = this.validate();
        if (error == null) {
            ChannelImpl chimpl = (ChannelImpl)this.getTomcatBayeux().getChannel(this.channel, false);
            MessageImpl mimpl = (MessageImpl)this.getTomcatBayeux().newMessage(client);
            try {
                String[] keys = JSONObject.getNames(this.msgData);
                for (int i = 0; i < keys.length; ++i) {
                    mimpl.put(keys[i], this.msgData.get(keys[i]));
                }
                success = true;
                ((HashMap)this.response.get("advice")).put("reconnect", "retry");
                ((HashMap)this.response.get("advice")).put("interval", this.getReconnectInterval());
            }
            catch (JSONException x) {
                throw new BayeuxException(x);
            }
            chimpl.publish(mimpl);
        }
        if (!success) {
            this.response.put("successful", Boolean.FALSE);
            this.response.put("error", error.toString());
            ((HashMap)this.response.get("advice")).put("reconnect", "handshake");
            if (client == null) {
                client = TomcatBayeux.getErrorClient();
            }
        }
        this.response.put("channel", this.channel);
        this.response.put("clientId", client.getId());
        try {
            JSONObject obj = new JSONObject(this.response);
            this.addToDeliveryQueue(client, obj);
        }
        catch (ServletException x) {
            throw new BayeuxException(x);
        }
        catch (IOException x) {
            throw new BayeuxException(x);
        }
        if (success && client != null && client.hasMessages()) {
            this.flushMessages(client);
        }
        return 0;
    }

    static {
        responseTemplate.put("successful", Boolean.TRUE);
        responseTemplate.put("advice", new HashMap());
    }
}

