/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.jbosssx;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSSecurityException;
import javax.security.auth.Subject;
import org.jboss.jms.server.SecurityStore;
import org.jboss.jms.server.jbosssx.MemorySecurityStoreMBean;
import org.jboss.jms.server.security.CheckType;
import org.jboss.jms.server.security.SecurityMetadata;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;
import org.w3c.dom.Element;

public class MemorySecurityStore
implements SecurityStore,
MemorySecurityStoreMBean {
    private Map<String, SecurityMetadata> queueSecurityConf = new ConcurrentHashMap<String, SecurityMetadata>();
    private Map<String, SecurityMetadata> topicSecurityConf = new ConcurrentHashMap<String, SecurityMetadata>();
    private SecurityMetadata defaultSecurityConfig;
    private String securityDomain;
    private String suckerPassword;
    private AuthenticationManager authenticationMgr;
    private RealmMapping authorizationMgr;

    public SecurityMetadata getDefaultSecurityConfig() {
        return this.defaultSecurityConfig;
    }

    public void setDefaultSecurityConfig(SecurityMetadata defaultSecurityConfig) {
        this.defaultSecurityConfig = defaultSecurityConfig;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public String getSuckerPassword() {
        return this.suckerPassword;
    }

    public void setSuckerPassword(String suckerPassword) {
        this.suckerPassword = suckerPassword;
    }

    public AuthenticationManager getAuthenticationMgr() {
        return this.authenticationMgr;
    }

    public void setAuthenticationMgr(AuthenticationManager authenticationMgr) {
        this.authenticationMgr = authenticationMgr;
    }

    public RealmMapping getAuthorizationMgr() {
        return this.authorizationMgr;
    }

    public void setAuthorizationMgr(RealmMapping authorizationMgr) {
        this.authorizationMgr = authorizationMgr;
    }

    public Subject authenticate(String user, String password) throws JMSSecurityException {
        SimplePrincipal principal = new SimplePrincipal(user);
        Subject subject = new Subject();
        if (!this.authenticationMgr.isValid((Principal)principal, (Object)password, subject)) {
            subject = null;
        }
        return subject;
    }

    public boolean authorize(String user, Set rolePrincipals, CheckType checkType) {
        if ("JBM.SUCKER".equals(user)) {
            return checkType.equals((Object)CheckType.READ) || checkType.equals((Object)CheckType.WRITE);
        }
        SimplePrincipal principal = user == null ? null : new SimplePrincipal(user);
        boolean hasRole = this.authorizationMgr.doesUserHaveRole((Principal)principal, rolePrincipals);
        return hasRole;
    }

    public void clearSecurityConfig(boolean isQueue, String destName) throws Exception {
        if (isQueue) {
            this.queueSecurityConf.remove(destName);
        } else {
            this.topicSecurityConf.remove(destName);
        }
    }

    public SecurityMetadata getSecurityMetadata(boolean isQueue, String destName) {
        SecurityMetadata smd = this.defaultSecurityConfig;
        smd = isQueue ? this.queueSecurityConf.get(destName) : this.topicSecurityConf.get(destName);
        return smd;
    }

    public void setSecurityConfig(boolean isQueue, String destName, Element conf) throws Exception {
        SecurityMetadata smd = new SecurityMetadata(conf);
        if (isQueue) {
            this.queueSecurityConf.put(destName, smd);
        } else {
            this.topicSecurityConf.put(destName, smd);
        }
    }
}

