/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration.propset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.gui.configuration.helper.ConfigurationUtility;
import org.rhq.core.gui.configuration.helper.PropertyRenderingUtility;
import org.rhq.core.gui.configuration.propset.ConfigurationSetMember;
import org.rhq.core.gui.configuration.propset.PropertySetComponent;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.FacesExpressionUtility;
import org.rhq.core.util.sort.HumaneStringComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySetRenderer
extends Renderer {
    static final String RENDERER_TYPE = "org.rhq.PropertySet";
    private static final String INIT_INPUTS_JAVA_SCRIPT_COMPONENT_ID_SUFFIX = "-initInputsJavaScript";
    private static final String PROPERTY_ALL_TO_SAME_VALUE_CONTROLS_COLUMN_CLASSES = ",property-value-cell-borderless,";
    private static final String OPTIONAL_PROPERTY_ALL_TO_SAME_VALUE_CONTROLS_COLUMN_CLASSES = ",property-value-cell-borderless,,,";

    public void decode(FacesContext facesContext, UIComponent component) {
        PropertySetComponent propertySetComponent = (PropertySetComponent)component;
        this.validateAttributes(propertySetComponent);
        String id = this.getInitInputsJavaScriptComponentId(propertySetComponent);
        UIComponent initInputsJavaScriptComponent = propertySetComponent.findComponent(id);
        if (initInputsJavaScriptComponent != null) {
            FacesComponentUtility.detachComponent(initInputsJavaScriptComponent);
            PropertyRenderingUtility.addInitInputsJavaScript((UIComponent)propertySetComponent, id, false, true);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        PropertySetComponent propertySetComponent = (PropertySetComponent)component;
        this.validateAttributes(propertySetComponent);
        String refresh = FacesContextUtility.getOptionalRequestParameter("refresh");
        if (refresh != null && refresh.equals("rhq_propSet")) {
            propertySetComponent.getConfigurationSet().applyAggregateConfiguration();
            component.getChildren().clear();
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        writer.write(10);
        writer.writeComment((Object)("********** Start of " + component.getClass().getSimpleName() + " component **********"));
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)clientId, "clientId");
        if (component.getChildCount() != 0) {
            return;
        }
        PropertySimple propertySimple = propertySetComponent.getProperty();
        if (propertySimple == null) {
            return;
        }
        PropertyDefinitionSimple propertyDefinitionSimple = propertySetComponent.getPropertyDefinition();
        this.addPropertyDisplayNameAndDescription(propertySetComponent, propertyDefinitionSimple, propertySimple);
        boolean configReadOnly = propertySetComponent.getReadOnly() != null && propertySetComponent.getReadOnly() != false;
        boolean propIsReadOnly = PropertyRenderingUtility.isReadOnly(propertyDefinitionSimple, null, configReadOnly, false);
        HtmlPanelGroup setAllToSameValueControlPanel = null;
        if (!propIsReadOnly) {
            FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<table class='member-properties-table'><tr><td align='center'>");
            setAllToSameValueControlPanel = FacesComponentUtility.addBlockPanel((UIComponent)propertySetComponent, null, null);
            FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "</td></tr></table>");
            FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<br/>\n");
        }
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "\n\n<table class='member-properties-table'>");
        this.addPropertiesTableHeaderRow(propertySetComponent, propertyDefinitionSimple);
        List<PropertyInfo> propertyInfos = this.createPropertyInfos(propertySetComponent, propertySimple);
        for (int i = 0; i < propertyInfos.size(); ++i) {
            PropertyInfo propertyInfo = propertyInfos.get(i);
            String rowStyleClass = i % 2 == 0 ? "OddRow" : "EvenRow";
            PropertySetRenderer.addPropertyRow(propertySetComponent, propertyDefinitionSimple, propertyInfo, rowStyleClass);
        }
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "</table>\n");
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<br/>\n");
        if (!propIsReadOnly) {
            this.addSetAllToSameValueControls(propertySetComponent, propertyDefinitionSimple, setAllToSameValueControlPanel, propertyInfos);
        }
        String id = this.getInitInputsJavaScriptComponentId(propertySetComponent);
        PropertyRenderingUtility.addInitInputsJavaScript((UIComponent)propertySetComponent, id, false, false);
    }

    private void addSetAllToSameValueControls(PropertySetComponent propertySetComponent, PropertyDefinitionSimple propertyDefinitionSimple, HtmlPanelGroup setAllToSameValueControlPanel, List<PropertyInfo> propertyInfos) {
        String masterInputId = propertySetComponent.getId() + "_setAllToSameValue";
        UIInput input = PropertyRenderingUtility.createInput(propertyDefinitionSimple);
        input.setId(masterInputId);
        HtmlPanelGrid panelGrid = FacesComponentUtility.createComponent(HtmlPanelGrid.class);
        if (PropertySetRenderer.isOptional(propertyDefinitionSimple)) {
            panelGrid.setColumns(5);
            panelGrid.setColumnClasses(OPTIONAL_PROPERTY_ALL_TO_SAME_VALUE_CONTROLS_COLUMN_CLASSES);
        } else {
            panelGrid.setColumns(3);
            panelGrid.setColumnClasses(PROPERTY_ALL_TO_SAME_VALUE_CONTROLS_COLUMN_CLASSES);
        }
        setAllToSameValueControlPanel.getChildren().add(panelGrid);
        FacesComponentUtility.addOutputText((UIComponent)panelGrid, null, "Set All Values To: ", null);
        panelGrid.getChildren().add(input);
        HtmlSelectBooleanCheckbox unsetCheckbox = null;
        if (PropertySetRenderer.isOptional(propertyDefinitionSimple)) {
            FacesComponentUtility.addOutputText((UIComponent)panelGrid, null, "Unset All: ", null);
            unsetCheckbox = PropertyRenderingUtility.addUnsetControl((UIComponent)panelGrid, propertyDefinitionSimple, null, propertySetComponent.getListIndex(), input, false, propertySetComponent.getReadOnly(), false);
        }
        UIForm form = FacesComponentUtility.getEnclosingForm((UIComponent)input);
        StringBuilder html = new StringBuilder();
        html.append("<button type='button' class='buttonsmall' onclick='");
        if (PropertySetRenderer.isOptional(propertyDefinitionSimple)) {
            html.append("setAllValuesForOptionalProperty(new Array(");
            for (PropertyInfo propertyInfo : propertyInfos) {
                String inputHtmlDomReference = PropertySetRenderer.getHtmlDomReference(propertyInfo.getInput(), form, '\"');
                html.append(inputHtmlDomReference).append(", ");
            }
            html.delete(html.length() - 2, html.length());
            html.append("), new Array(");
            for (PropertyInfo propertyInfo : propertyInfos) {
                String unsetCheckboxHtmlDomReference = PropertySetRenderer.getHtmlDomReference((UIInput)propertyInfo.getUnsetCheckbox(), form, '\"');
                html.append(unsetCheckboxHtmlDomReference).append(", ");
            }
            html.delete(html.length() - 2, html.length());
            String masterInputHtmlDomReference = PropertySetRenderer.getHtmlDomReference(input, form, '\"');
            html.append("), getElementValue(").append(masterInputHtmlDomReference);
            String masterUnsetCheckboxHtmlDomReference = PropertySetRenderer.getHtmlDomReference((UIInput)unsetCheckbox, form, '\"');
            html.append("), ").append(masterUnsetCheckboxHtmlDomReference).append(".checked);");
        } else {
            html.append("setInputsToValue(new Array(");
            for (PropertyInfo propertyInfo : propertyInfos) {
                String inputHtmlDomReference = PropertySetRenderer.getHtmlDomReference(propertyInfo.getInput(), form, '\"');
                html.append(inputHtmlDomReference).append(", ");
            }
            html.delete(html.length() - 2, html.length());
            html.append("), ");
            String masterInputHtmlDomReference = PropertySetRenderer.getHtmlDomReference(input, form, '\"');
            html.append("getElementValue(").append(masterInputHtmlDomReference).append("));");
        }
        html.append("'>Apply</button>");
        FacesComponentUtility.addVerbatimText((UIComponent)panelGrid, html);
    }

    private static String getHtmlDomReference(UIInput input, UIForm form, char quoteChar) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String inputHtmlDomReference = "document." + form.getClientId(facesContext) + "[" + quoteChar + input.getClientId(facesContext) + quoteChar + "]";
        return inputHtmlDomReference;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.writeText((Object)"\n", component, null);
        writer.endElement("div");
        writer.writeComment((Object)("********** End of " + component.getClass().getSimpleName() + " component **********"));
    }

    private void addPropertyDisplayNameAndDescription(PropertySetComponent propertySetComponent, PropertyDefinitionSimple propertyDefinitionSimple, PropertySimple propertySimple) {
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<br/>\n");
        PropertyRenderingUtility.addPropertyDisplayName((UIComponent)propertySetComponent, (PropertyDefinition)propertyDefinitionSimple, (Property)propertySimple, propertySetComponent.getReadOnly());
        if (propertyDefinitionSimple != null) {
            FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, " - ");
            PropertyRenderingUtility.addPropertyDescription((UIComponent)propertySetComponent, (PropertyDefinition)propertyDefinitionSimple);
        }
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<br/><br/>\n");
    }

    private List<PropertyInfo> createPropertyInfos(PropertySetComponent propertySetComponent, PropertySimple aggregatePropertySimple) {
        ValueExpression configurationInfosExpression = propertySetComponent.getValueExpression("configurationSet");
        String configurationInfosExpressionString = configurationInfosExpression.getExpressionString();
        String configurationExpressionStringFormat = "#{" + FacesExpressionUtility.unwrapExpressionString(configurationInfosExpressionString) + ".members[%d].configuration}";
        String propertyExpressionStringFormat = PropertySetRenderer.createPropertyExpressionFormat(configurationExpressionStringFormat, aggregatePropertySimple, propertySetComponent.getListIndex());
        String propertyValueExpressionStringFormat = "#{" + FacesExpressionUtility.unwrapExpressionString(propertyExpressionStringFormat) + ".stringValue}";
        List<ConfigurationSetMember> configurationSetMembers = propertySetComponent.getConfigurationSet().getMembers();
        ArrayList<PropertyInfo> propertyInfos = new ArrayList<PropertyInfo>(configurationSetMembers.size());
        for (int i = 0; i < configurationSetMembers.size(); ++i) {
            ConfigurationSetMember memberInfo = configurationSetMembers.get(i);
            String propertyExpressionString = String.format(propertyExpressionStringFormat, i);
            PropertySimple propertySimple = FacesExpressionUtility.getValue(propertyExpressionString, PropertySimple.class);
            String propertyValueExpressionString = String.format(propertyValueExpressionStringFormat, i);
            ValueExpression propertyValueExpression = FacesExpressionUtility.createValueExpression(propertyValueExpressionString, String.class);
            PropertyInfo propertyInfo = new PropertyInfo(memberInfo.getLabel(), propertySimple, propertyValueExpression);
            propertyInfos.add(propertyInfo);
        }
        Collections.sort(propertyInfos);
        return propertyInfos;
    }

    private void addPropertiesTableHeaderRow(PropertySetComponent propertySetComponent, PropertyDefinitionSimple propertyDefinitionSimple) {
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "\n\n<tr>");
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<th class='properties-table-header-cell'>");
        FacesComponentUtility.addOutputText((UIComponent)propertySetComponent, null, "Member", FacesComponentUtility.NO_STYLE_CLASS);
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "</th>");
        if (PropertySetRenderer.isOptional(propertyDefinitionSimple)) {
            FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<th class='properties-table-header-cell'>");
            FacesComponentUtility.addOutputText((UIComponent)propertySetComponent, null, "Unset", FacesComponentUtility.NO_STYLE_CLASS);
            FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "</th>");
        }
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<th class='properties-table-header-cell'>");
        FacesComponentUtility.addOutputText((UIComponent)propertySetComponent, null, "Value", FacesComponentUtility.NO_STYLE_CLASS);
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "</th>");
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "</tr>");
    }

    private void validateAttributes(PropertySetComponent propertySetComponent) {
        if (propertySetComponent.getValueExpression("configurationSet") == null) {
            throw new IllegalStateException("The " + propertySetComponent.getClass().getName() + " component requires a '" + "configurationSet" + "' attribute.");
        }
    }

    private static String createPropertyExpressionFormat(String configurationExpressionString, PropertySimple propertySimple, Integer listIndex) {
        StringBuilder stringBuilder = new StringBuilder("#{");
        stringBuilder.append(FacesExpressionUtility.unwrapExpressionString(configurationExpressionString));
        LinkedList<Property> propertyHierarchy = ConfigurationUtility.getPropertyHierarchy((Property)propertySimple);
        for (Property property : propertyHierarchy) {
            Property parentProperty = ConfigurationUtility.getParentProperty(property);
            stringBuilder.append(".");
            if (parentProperty == null || parentProperty instanceof PropertyMap) {
                stringBuilder.append("map['").append(property.getName()).append("']");
                continue;
            }
            stringBuilder.append("list[").append(listIndex).append("]");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String getInitInputsJavaScriptComponentId(PropertySetComponent propertySetComponent) {
        return propertySetComponent.getId() + INIT_INPUTS_JAVA_SCRIPT_COMPONENT_ID_SUFFIX;
    }

    private static void addPropertyRow(PropertySetComponent propertySetComponent, PropertyDefinitionSimple propertyDefinitionSimple, PropertyInfo propertyInfo, String rowStyleClass) {
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "\n\n<tr class='" + rowStyleClass + "'>");
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<td class='member-property-label-cell'>");
        FacesComponentUtility.addOutputText((UIComponent)propertySetComponent, null, propertyInfo.getLabel(), null);
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "</td>");
        UIInput input = propertyDefinitionSimple != null ? PropertyRenderingUtility.createInputForSimpleProperty(propertyDefinitionSimple, propertyInfo.getProperty(), propertyInfo.getPropertyValueExpression(), propertySetComponent.getListIndex(), false, propertySetComponent.getReadOnly(), false, true) : PropertyRenderingUtility.createInputForSimpleProperty(propertyInfo.getProperty(), propertyInfo.getPropertyValueExpression(), propertySetComponent.getReadOnly());
        propertyInfo.setInput(input);
        if (PropertySetRenderer.isOptional(propertyDefinitionSimple)) {
            FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<td class='member-property-unset-cell'>");
            HtmlSelectBooleanCheckbox unsetCheckbox = PropertyRenderingUtility.addUnsetControl((UIComponent)propertySetComponent, propertyDefinitionSimple, propertyInfo.getProperty(), propertySetComponent.getListIndex(), input, false, propertySetComponent.getReadOnly(), false);
            propertyInfo.setUnsetCheckbox(unsetCheckbox);
            FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "</td>");
        }
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<td class='member-property-value-cell'>");
        propertySetComponent.getChildren().add(input);
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "<br/>");
        PropertyRenderingUtility.addMessageComponentForInput((UIComponent)propertySetComponent, input);
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "</td>");
        FacesComponentUtility.addVerbatimText((UIComponent)propertySetComponent, "</tr>");
    }

    private static boolean isOptional(PropertyDefinitionSimple propertyDefinitionSimple) {
        return propertyDefinitionSimple == null || !propertyDefinitionSimple.isRequired();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyInfo
    implements Comparable<PropertyInfo> {
        private String label;
        private PropertySimple property;
        private ValueExpression propertyValueExpression;
        private UIInput input;
        private HtmlSelectBooleanCheckbox unsetCheckbox;

        PropertyInfo(String label, PropertySimple property, ValueExpression propertyValueExpression) {
            this.label = label != null ? label : "";
            this.property = property;
            this.propertyValueExpression = propertyValueExpression;
        }

        public String getLabel() {
            return this.label;
        }

        public PropertySimple getProperty() {
            return this.property;
        }

        public ValueExpression getPropertyValueExpression() {
            return this.propertyValueExpression;
        }

        public UIInput getInput() {
            return this.input;
        }

        public void setInput(UIInput input) {
            this.input = input;
        }

        public HtmlSelectBooleanCheckbox getUnsetCheckbox() {
            return this.unsetCheckbox;
        }

        public void setUnsetCheckbox(HtmlSelectBooleanCheckbox unsetCheckbox) {
            this.unsetCheckbox = unsetCheckbox;
        }

        @Override
        public int compareTo(PropertyInfo that) {
            return new HumaneStringComparator().compare(this.label, that.label);
        }
    }
}

