/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.alert.AlertDefinition;

@Entity
@NamedQueries(value={@NamedQuery(name="AlertDampeningEvent.findLatestByAlertDefinitionId", query="SELECT ade   FROM AlertDampeningEvent ade  WHERE ade.id =        ( SELECT max(iade.id) FROM AlertDampeningEvent iade          WHERE iade.alertDefinition.id = :alertDefinitionId )"), @NamedQuery(name="AlertDampeningEvent.findByTimeAndTypes", query="SELECT ade   FROM AlertDampeningEvent ade  WHERE ade.alertDefinition.id = :alertDefinitionId    AND ade.eventType IN (:eventTypes)    AND ade.eventTime > :oldestEventTime  ORDER BY ade.eventTime ASC"), @NamedQuery(name="AlertDampeningEvent.findByAlertDefinitionId", query="SELECT ade   FROM AlertDampeningEvent ade  WHERE ade.alertDefinition.id = :alertDefinitionId  ORDER BY ade.eventTime DESC "), @NamedQuery(name="AlertDampeningEvent.deleteByResources", query="DELETE AlertDampeningEvent ade  WHERE ade.alertDefinition IN        ( SELECT ad FROM AlertDefinition ad           WHERE ad.resource IN (:resources))"), @NamedQuery(name="AlertDampeningEvent.deleteByTimestamp", query="DELETE AlertDampeningEvent ade    WHERE ade.eventTime < :oldest      AND ade.alertDefinition.id = :alertDefinitionId "), @NamedQuery(name="AlertDampeningEvent.deleteByAlertDefinitionId", query="DELETE AlertDampeningEvent ade  WHERE ade.alertDefinition.id = :alertDefinitionId")})
@SequenceGenerator(name="RHQ_ALERT_DAMPEN_EVENT_ID_SEQ", sequenceName="RHQ_ALERT_DAMPEN_EVENT_ID_SEQ")
@Table(name="RHQ_ALERT_DAMPEN_EVENT")
public class AlertDampeningEvent
implements Serializable {
    public static final String QUERY_FIND_LATEST_BY_ALERT_DEFINITION_ID = "AlertDampeningEvent.findLatestByAlertDefinitionId";
    public static final String QUERY_FIND_BY_TIME_AND_TYPES = "AlertDampeningEvent.findByTimeAndTypes";
    public static final String QUERY_FIND_BY_ALERT_DEFINITION_ID = "AlertDampeningEvent.findByAlertDefinitionId";
    public static final String QUERY_DELETE_BY_RESOURCES = "AlertDampeningEvent.deleteByResources";
    public static final String QUERY_DELETE_BY_TIMESTAMP = "AlertDampeningEvent.deleteByTimestamp";
    public static final String QUERY_DELETE_BY_ALERT_DEFINITION_ID = "AlertDampeningEvent.deleteByAlertDefinitionId";
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="RHQ_ALERT_DAMPEN_EVENT_ID_SEQ")
    @Id
    private int id;
    @JoinColumn(name="ALERT_DEFINITION_ID", referencedColumnName="ID")
    @ManyToOne
    private AlertDefinition alertDefinition;
    @Column(name="EVENT_TYPE")
    @Enumerated(value=EnumType.ORDINAL)
    private Type eventType;
    @Column(name="EVENT_TIMESTAMP")
    private long eventTime;

    protected AlertDampeningEvent() {
    }

    public AlertDampeningEvent(AlertDefinition alertDefinition, Type type) {
        this.eventType = type;
        this.alertDefinition = alertDefinition;
        this.eventTime = System.currentTimeMillis();
    }

    public int getId() {
        return this.id;
    }

    public AlertDefinition getAlertDefinition() {
        return this.alertDefinition;
    }

    public void setAlertDefinition(AlertDefinition alertDefinition) {
        this.alertDefinition = alertDefinition;
    }

    public Type getEventType() {
        return this.eventType;
    }

    public Long getEventTime() {
        return this.eventTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlertDampeningEvent)) {
            return false;
        }
        AlertDampeningEvent other = (AlertDampeningEvent)o;
        if (this.eventTime != other.eventTime) {
            return false;
        }
        return !(this.eventType == null ? other.eventType != null : !this.eventType.equals((Object)other.eventType));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.eventTime ^ this.eventTime >>> 32);
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        return result;
    }

    public String toString() {
        return "org.rhq.core.domain.alert.AlertDampeningEvent[ id=" + this.id + ", " + "eventType=" + (Object)((Object)this.eventType) + ", " + "eventTime=" + new SimpleDateFormat("MMM d, hh:mm:ss a").format(this.eventTime) + " ]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        POSITIVE,
        POSITIVE_AGAIN,
        NEGATIVE,
        UNCHANGED;

    }
}

