/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlForm;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.component.html.HtmlAjaxCommandLink;
import org.ajax4jsf.component.html.HtmlAjaxOutputPanel;
import org.ajax4jsf.component.html.HtmlAjaxRegion;
import org.ajax4jsf.context.AjaxContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.core.gui.configuration.AbstractConfigurationComponent;
import org.rhq.core.gui.configuration.ConfigUIComponent;
import org.rhq.core.gui.configuration.GroupUIComponentTreeFactory;
import org.rhq.core.gui.configuration.MapInListUIComponentTreeFactory;
import org.rhq.core.gui.configuration.helper.PropertyRenderingUtility;
import org.rhq.core.gui.configuration.propset.ConfigurationSetComponent;
import org.rhq.core.gui.configuration.propset.PropertySetComponent;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.FacesExpressionUtility;
import org.rhq.core.gui.util.PropertyIdGeneratorUtility;
import org.richfaces.component.html.HtmlModalPanel;
import org.richfaces.component.html.HtmlSimpleTogglePanel;

public class ConfigRenderer
extends Renderer {
    public static final String PROPERTY_SET_COMPONENT_ID = "rhq_propSet";
    protected static final String NOTE_PANEL_STYLE_CLASS = "note-panel";
    protected static final String PROPERTY_GROUP_HEADER_STYLE_CLASS = "BlockTitle";
    protected static final String PROPERTY_GROUP_BODY_STYLE_CLASS = "BlockContent";
    protected static final String UNGROUPED_PROPERTIES_STYLE_CLASS = "BlockContent";
    protected static final String REQUIRED_MARKER_TEXT_STYLE_CLASS = "required-marker-text";
    protected static final String GROUP_DESCRIPTION_PANEL_STYLE_CLASS = "group-description-panel";
    protected static final String GROUP_DESCRIPTION_TEXT_PANEL_STYLE_CLASS = "group-description-text-panel";
    private final Log LOG = LogFactory.getLog(ConfigRenderer.class);
    private static final String INIT_INPUTS_JAVA_SCRIPT_COMPONENT_ID_SUFFIX = "-initInputsJavaScript";

    public void decode(FacesContext facesContext, UIComponent component) {
        String id;
        UIComponent initInputsJavaScriptComponent;
        AbstractConfigurationComponent configurationComponent = (AbstractConfigurationComponent)component;
        this.validateAttributes(configurationComponent);
        String function = FacesContextUtility.getOptionalRequestParameter("function");
        if (function != null) {
            if (function.equals("DELETE_LIST_MEMBER_PROPERTY")) {
                this.deleteListMemberProperty(configurationComponent);
            } else if (function.equals("DELETE_OPEN_MAP_MEMBER_PROPERTY")) {
                this.deleteOpenMapMemberProperty(configurationComponent);
            }
        }
        if (configurationComponent.getConfiguration() != null && (initInputsJavaScriptComponent = configurationComponent.findComponent(id = this.getInitInputsJavaScriptComponentId(configurationComponent))) != null) {
            FacesComponentUtility.detachComponent(initInputsJavaScriptComponent);
            PropertyRenderingUtility.addInitInputsJavaScript((UIComponent)configurationComponent, id, configurationComponent.isFullyEditable(), true);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractConfigurationComponent configurationComponent = (AbstractConfigurationComponent)component;
        if (this.isAjaxRefresh(configurationComponent)) {
            if (configurationComponent instanceof ConfigUIComponent) {
                component.getChildren().clear();
            } else {
                ConfigurationSetComponent configurationSetComponent = (ConfigurationSetComponent)configurationComponent;
                HtmlModalPanel propSetModalPanel = configurationSetComponent.getPropSetModalPanel();
                if (ConfigRenderer.propertySetComponentContainsInvalidInputs(configurationSetComponent)) {
                    propSetModalPanel.setShowWhenRendered(true);
                } else {
                    propSetModalPanel.setShowWhenRendered(false);
                    configurationSetComponent.getConfigurationSet().calculateAggregateConfiguration();
                    component.getChildren().clear();
                }
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        writer.write(10);
        writer.writeComment((Object)("********** Start of " + component.getClass().getSimpleName() + " component **********"));
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)clientId, "clientId");
        if (component.getChildCount() == 0) {
            this.addChildComponents(configurationComponent);
        }
    }

    private boolean isAjaxRefresh(AbstractConfigurationComponent configurationComponent) {
        if (configurationComponent instanceof ConfigUIComponent) {
            return AjaxContext.getCurrentInstance().isAjaxRequest();
        }
        String refresh = FacesContextUtility.getOptionalRequestParameter("refresh");
        return configurationComponent.getId().equals(refresh);
    }

    private static boolean propertySetComponentContainsInvalidInputs(ConfigurationSetComponent configurationSetComponent) {
        HtmlModalPanel propSetModalPanel = configurationSetComponent.getPropSetModalPanel();
        boolean containsInvalidInputs = false;
        List<PropertySetComponent> propertySetComponents = FacesComponentUtility.getDescendantsOfType((UIComponent)propSetModalPanel, PropertySetComponent.class);
        if (propertySetComponents.size() == 1) {
            PropertySetComponent propertySetComponent = propertySetComponents.get(0);
            List<UIInput> inputs = FacesComponentUtility.getDescendantsOfType((UIComponent)propertySetComponent, UIInput.class);
            for (UIInput input : inputs) {
                if (input.isValid()) continue;
                containsInvalidInputs = true;
                break;
            }
        }
        return containsInvalidInputs;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.writeText((Object)"\n", component, null);
        writer.endElement("div");
        writer.writeComment((Object)("********** End of " + component.getClass().getSimpleName() + " component **********"));
    }

    public void addChildComponents(AbstractConfigurationComponent configurationComponent) {
        if (configurationComponent.getConfigurationDefinition() == null || configurationComponent.getConfiguration() != null && configurationComponent.getConfiguration().getMap().isEmpty()) {
            if (configurationComponent.getNullConfigurationDefinitionMessage() != null) {
                String styleClass = configurationComponent.getNullConfigurationStyle() == null ? "ErrorBlock" : configurationComponent.getNullConfigurationStyle();
                HtmlPanelGroup messagePanel = FacesComponentUtility.addBlockPanel((UIComponent)configurationComponent, configurationComponent, styleClass);
                FacesComponentUtility.addVerbatimText((UIComponent)messagePanel, configurationComponent.getNullConfigurationDefinitionMessage());
            }
            return;
        }
        if (configurationComponent.getConfiguration() == null) {
            if (configurationComponent.getNullConfigurationMessage() != null) {
                HtmlPanelGroup messagePanel = FacesComponentUtility.addBlockPanel((UIComponent)configurationComponent, configurationComponent, "WarnBlock");
                FacesComponentUtility.addVerbatimText((UIComponent)messagePanel, configurationComponent.getNullConfigurationMessage());
            }
            return;
        }
        ConfigurationUtility.normalizeConfiguration((Configuration)configurationComponent.getConfiguration(), (ConfigurationDefinition)configurationComponent.getConfigurationDefinition());
        if (configurationComponent instanceof ConfigurationSetComponent) {
            ConfigurationSetComponent configurationSetComponent = (ConfigurationSetComponent)configurationComponent;
            if (configurationSetComponent.getPropSetModalPanel() == null) {
                this.addPropSetModalPanel(configurationSetComponent);
            } else if (this.isAjaxRefresh(configurationSetComponent) && !ConfigRenderer.propertySetComponentContainsInvalidInputs(configurationSetComponent)) {
                HtmlModalPanel propSetModalPanel = configurationSetComponent.getPropSetModalPanel();
                String script = "Richfaces.hideModalPanel('" + propSetModalPanel.getClientId(FacesContext.getCurrentInstance()) + "');";
                FacesComponentUtility.addJavaScript((UIComponent)configurationSetComponent, null, null, script);
            }
        }
        if (!configurationComponent.isReadOnly()) {
            this.addRequiredNotationsKey(configurationComponent);
        }
        if (configurationComponent.getListName() != null) {
            if (configurationComponent.getListIndex() == null) {
                configurationComponent.setListIndex(this.addNewMap(configurationComponent));
            }
            this.addListMemberProperty(configurationComponent);
        } else {
            this.addConfiguration(configurationComponent);
        }
        String id = this.getInitInputsJavaScriptComponentId(configurationComponent);
        PropertyRenderingUtility.addInitInputsJavaScript((UIComponent)configurationComponent, id, configurationComponent.isFullyEditable(), false);
    }

    private void addListMemberProperty(AbstractConfigurationComponent configurationComponent) {
        if (configurationComponent instanceof ConfigurationSetComponent) {
            ConfigurationSetComponent configurationSetComponent = (ConfigurationSetComponent)configurationComponent;
            configurationSetComponent.getConfigurationSet().applyAggregateConfiguration();
        }
        MapInListUIComponentTreeFactory propertyListUIComponentTreeFactory = new MapInListUIComponentTreeFactory(configurationComponent, configurationComponent.getListName(), configurationComponent.getListIndex());
        HtmlPanelGroup propertiesPanel = FacesComponentUtility.addBlockPanel((UIComponent)configurationComponent, configurationComponent, "BlockContent");
        propertiesPanel.getChildren().add(propertyListUIComponentTreeFactory.createUIComponentTree(null));
    }

    private void deleteListMemberProperty(AbstractConfigurationComponent configurationComponent) {
        String listName = FacesContextUtility.getRequiredRequestParameter("listName");
        PropertyList propertyList = configurationComponent.getConfiguration().getList(listName);
        if (propertyList == null) {
            FacesContextUtility.addMessage(FacesMessage.SEVERITY_ERROR, "Configuration does not contain a list named '" + listName + "'.");
            return;
        }
        int listIndex = FacesContextUtility.getRequiredRequestParameter("listIndex", Integer.class);
        if (listIndex >= propertyList.getList().size()) {
            FacesContextUtility.addMessage(FacesMessage.SEVERITY_ERROR, "List '" + listName + "' does not contain an item at index " + listIndex + ".");
            return;
        }
        Property memberProperty = (Property)propertyList.getList().get(listIndex);
        String memberComponentId = PropertyIdGeneratorUtility.getIdentifier(memberProperty, listIndex, "-panel");
        UIComponent listMemberComponent = configurationComponent.findComponent(memberComponentId);
        if (listMemberComponent == null) {
            throw new IllegalStateException("JSF component with id '" + memberComponentId + "' not found for list '" + listName + "' item " + listIndex + ".");
        }
        FacesComponentUtility.detachComponent(listMemberComponent);
        this.correctListIndexesInSiblingMembers(configurationComponent, propertyList, listIndex);
        propertyList.getList().remove(listIndex);
        if (configurationComponent instanceof ConfigurationSetComponent) {
            ConfigurationSetComponent configurationSetComponent = (ConfigurationSetComponent)configurationComponent;
            configurationSetComponent.getConfigurationSet().applyAggregateConfiguration();
        }
        FacesContextUtility.addMessage(FacesMessage.SEVERITY_INFO, "Property at index " + listIndex + " deleted from list '" + listName + "'.");
    }

    private void correctListIndexesInSiblingMembers(AbstractConfigurationComponent config, PropertyList propertyList, int deletedMemberIndex) {
        for (int oldIndex = deletedMemberIndex + 1; oldIndex < propertyList.getList().size(); ++oldIndex) {
            int newIndex = oldIndex - 1;
            String listMemberComponentId = PropertyIdGeneratorUtility.getIdentifier((Property)propertyList.getList().get(oldIndex), oldIndex, "-panel");
            UIComponent listMemberComponent = config.findComponent(listMemberComponentId);
            String newListMemberComponentId = PropertyIdGeneratorUtility.getIdentifier((Property)propertyList.getList().get(newIndex), newIndex, "-panel");
            listMemberComponent.setId(newListMemberComponentId);
            String listIndexParamComponentId = PropertyIdGeneratorUtility.getIdentifier((Property)propertyList.getList().get(oldIndex), oldIndex, "-param");
            UIParameter listIndexParam = (UIParameter)config.findComponent(listIndexParamComponentId);
            String newListIndexParamComponentId = PropertyIdGeneratorUtility.getIdentifier((Property)propertyList.getList().get(newIndex), newIndex, "-param");
            listIndexParam.setId(newListIndexParamComponentId);
            listIndexParam.setValue((Object)newIndex);
        }
    }

    private void deleteOpenMapMemberProperty(AbstractConfigurationComponent configurationComponent) {
        String mapName = FacesContextUtility.getRequiredRequestParameter("mapName");
        PropertyMap propertyMap = configurationComponent.getConfiguration().getMap(mapName);
        if (propertyMap == null) {
            FacesContextUtility.addMessage(FacesMessage.SEVERITY_ERROR, "Configuration does not contain a map named '" + mapName + "'.");
            return;
        }
        String memberName = FacesContextUtility.getRequiredRequestParameter("memberName");
        if (!propertyMap.getMap().containsKey(memberName)) {
            FacesContextUtility.addMessage(FacesMessage.SEVERITY_ERROR, "Map '" + mapName + "' does not contain a member property named '" + memberName + "'.");
            return;
        }
        Property memberProperty = (Property)propertyMap.getMap().get(memberName);
        String memberComponentId = PropertyIdGeneratorUtility.getIdentifier(memberProperty, null, "-panel");
        UIComponent mapMemberComponent = configurationComponent.findComponent(memberComponentId);
        if (mapMemberComponent == null) {
            throw new IllegalStateException("JSF component with id '" + memberComponentId + "' not found for map '" + mapName + "' member property '" + memberName + "'.");
        }
        FacesComponentUtility.detachComponent(mapMemberComponent);
        propertyMap.getMap().remove(memberName);
        if (configurationComponent instanceof ConfigurationSetComponent) {
            ConfigurationSetComponent configurationSetComponent = (ConfigurationSetComponent)configurationComponent;
            configurationSetComponent.getConfigurationSet().applyAggregateConfiguration();
        }
        FacesContextUtility.addMessage(FacesMessage.SEVERITY_INFO, "Property '" + memberName + "' deleted from map '" + mapName + "'.");
    }

    private void addRequiredNotationsKey(AbstractConfigurationComponent config) {
        this.addDebug((UIComponent)config, true, ".addNotePanel()");
        HtmlPanelGroup footnotesPanel = FacesComponentUtility.addBlockPanel((UIComponent)config, config, NOTE_PANEL_STYLE_CLASS);
        FacesComponentUtility.addOutputText((UIComponent)footnotesPanel, config, "*", REQUIRED_MARKER_TEXT_STYLE_CLASS);
        FacesComponentUtility.addOutputText((UIComponent)footnotesPanel, config, " denotes a required field.", FacesComponentUtility.NO_STYLE_CLASS);
        if (config.isAggregate()) {
            HtmlPanelGroup overridePanel = FacesComponentUtility.addBlockPanel((UIComponent)config, config, NOTE_PANEL_STYLE_CLASS);
            FacesComponentUtility.addOutputText((UIComponent)overridePanel, config, "note: if override is not checked, that property will not be altered on any group members", FacesComponentUtility.NO_STYLE_CLASS);
        }
        this.addDebug((UIComponent)config, false, ".addNotePanel()");
    }

    private void addConfiguration(AbstractConfigurationComponent config) {
        this.addNonGroupedProperties(config);
        this.addGroupedProperties(config);
    }

    private void addNonGroupedProperties(AbstractConfigurationComponent config) {
        this.addDebug((UIComponent)config, true, ".addNonGroupedProperties()");
        HtmlPanelGroup propertiesPanel = FacesComponentUtility.addBlockPanel((UIComponent)config, config, "BlockContent");
        GroupUIComponentTreeFactory propertyListUIComponentTreeFactory = new GroupUIComponentTreeFactory(config, GroupUIComponentTreeFactory.NO_GROUP);
        propertiesPanel.getChildren().add(propertyListUIComponentTreeFactory.createUIComponentTree(null));
        this.addDebug((UIComponent)config, false, ".addNonGroupedProperties()");
    }

    private void addGroupedProperties(AbstractConfigurationComponent config) {
        this.addDebug((UIComponent)config, true, ".addGroupedProperties()");
        List groups = config.getConfigurationDefinition().getGroupDefinitions();
        for (PropertyGroupDefinition group : groups) {
            HtmlSimpleTogglePanel groupPanel = this.addGroupPanel(config, group);
            GroupUIComponentTreeFactory propertyListUIComponentTreeFactory = new GroupUIComponentTreeFactory(config, group.getName());
            groupPanel.getChildren().add(propertyListUIComponentTreeFactory.createUIComponentTree(null));
        }
        this.addDebug((UIComponent)config, false, ".addGroupedProperties()");
    }

    private HtmlSimpleTogglePanel addGroupPanel(AbstractConfigurationComponent config, PropertyGroupDefinition group) {
        this.addDebug((UIComponent)config, true, ".addGroupPanel()");
        HtmlSimpleTogglePanel groupPanel = FacesComponentUtility.addSimpleTogglePanel((UIComponent)config, config, null);
        groupPanel.setOpened(!group.isDefaultHidden());
        groupPanel.setHeaderClass(PROPERTY_GROUP_HEADER_STYLE_CLASS);
        groupPanel.setBodyClass("BlockContent");
        HtmlPanelGroup headerPanel = FacesComponentUtility.createBlockPanel(config, null);
        FacesComponentUtility.addOutputText((UIComponent)headerPanel, config, group.getDisplayName(), null);
        FacesComponentUtility.addOutputText((UIComponent)headerPanel, config, group.getDescription(), GROUP_DESCRIPTION_TEXT_PANEL_STYLE_CLASS);
        groupPanel.getFacets().put("header", headerPanel);
        HtmlPanelGroup closePanel = FacesComponentUtility.createBlockPanel(config, null);
        closePanel.setStyle("text-align: right; font-weight: normal; font-size: 0.8em; whitespace: nowrap;");
        FacesComponentUtility.addGraphicImage((UIComponent)closePanel, config, "/images/ico_trigger_wht_collapse.gif", "collapse");
        FacesComponentUtility.addOutputText((UIComponent)closePanel, config, " Collapse", null);
        groupPanel.getFacets().put("closeMarker", closePanel);
        HtmlPanelGroup openPanel = FacesComponentUtility.createBlockPanel(config, null);
        openPanel.setStyle("text-align: right; font-weight: normal; font-size: 0.8em; whitespace: nowrap;");
        FacesComponentUtility.addGraphicImage((UIComponent)openPanel, config, "/images/ico_trigger_wht_expand.gif", "expand");
        FacesComponentUtility.addOutputText((UIComponent)openPanel, config, " Expand", null);
        groupPanel.getFacets().put("openMarker", openPanel);
        this.addDebug((UIComponent)config, true, ".addGroupPanel()");
        return groupPanel;
    }

    private void validateAttributes(AbstractConfigurationComponent configurationComponent) {
    }

    private int addNewMap(AbstractConfigurationComponent config) {
        String listName = config.getListName();
        PropertyDefinitionMap mapDefinition = (PropertyDefinitionMap)config.getConfigurationDefinition().getPropertyDefinitionList(listName).getMemberDefinition();
        String mapName = mapDefinition.getName();
        PropertyMap newMap = new PropertyMap(mapName);
        Map mapMemberDefinitions = mapDefinition.getPropertyDefinitions();
        for (PropertyDefinition mapMemberDefinition : mapMemberDefinitions.values()) {
            PropertyDefinitionSimple simpleDefinition = (PropertyDefinitionSimple)mapMemberDefinition;
            newMap.put((Property)new PropertySimple(simpleDefinition.getName(), (Object)(simpleDefinition.isRequired() ? "" : null)));
        }
        PropertyList list = config.getConfiguration().getList(listName);
        list.add((Property)newMap);
        return list.getList().size() - 1;
    }

    private void addDebug(UIComponent component, boolean start, String methodName) {
        if (this.LOG.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder("\n<!--");
            msg.append(start ? " START " : " END ");
            msg.append(((Object)((Object)this)).getClass().getSimpleName());
            msg.append(methodName);
            msg.append(" -->\n ");
            FacesComponentUtility.addVerbatimText(component, msg);
        }
    }

    private String getInitInputsJavaScriptComponentId(AbstractConfigurationComponent configUIComponent) {
        return configUIComponent.getId() + INIT_INPUTS_JAVA_SCRIPT_COMPONENT_ID_SUFFIX;
    }

    private void addPropSetModalPanel(ConfigurationSetComponent configurationSetComponent) {
        UIForm configSetForm = FacesComponentUtility.getEnclosingForm((UIComponent)configurationSetComponent);
        HtmlModalPanel modalPanel = FacesComponentUtility.createComponent(HtmlModalPanel.class);
        String modalPanelId = ConfigurationSetComponent.getPropSetModalPanelId(configurationSetComponent);
        modalPanel.setId(modalPanelId);
        modalPanel.setWidth(715);
        modalPanel.setHeight(535);
        modalPanel.setTrimOverlayedElements(false);
        modalPanel.setStyle("overflow-y: auto;");
        modalPanel.setOnbeforeshow("sizeAppropriately('configSetForm:" + modalPanelId + "')");
        modalPanel.setOnresize("keepCentered('configSetForm:" + modalPanelId + "')");
        int index = ConfigRenderer.getComponentIndex(configSetForm);
        configSetForm.getParent().getChildren().add(index + 1, modalPanel);
        HtmlForm propSetForm = new HtmlForm();
        modalPanel.getChildren().add(propSetForm);
        String propSetFormId = ConfigurationSetComponent.getPropSetFormId(configurationSetComponent);
        propSetForm.setId(propSetFormId);
        propSetForm.setOnsubmit("prepareInputsForSubmission(this)");
        this.forwardParameter(propSetForm, "id");
        this.forwardParameter(propSetForm, "groupId");
        this.forwardParameter(propSetForm, "arcuId");
        this.forwardParameter(propSetForm, "apcuId");
        this.forwardParameter(propSetForm, "mode");
        this.addPropSetButtons(configurationSetComponent, propSetForm);
        HtmlAjaxRegion ajaxRegion = FacesComponentUtility.createComponent(HtmlAjaxRegion.class);
        propSetForm.getChildren().add(ajaxRegion);
        HtmlAjaxOutputPanel ajaxOutputPanel = FacesComponentUtility.createComponent(HtmlAjaxOutputPanel.class);
        ajaxRegion.getChildren().add(ajaxOutputPanel);
        ajaxOutputPanel.setLayout("block");
        ajaxOutputPanel.setAjaxRendered(true);
        ajaxOutputPanel.setKeepTransient(true);
        PropertySetComponent propertySet = new PropertySetComponent();
        ajaxOutputPanel.getChildren().add(propertySet);
        propertySet.setId(PROPERTY_SET_COMPONENT_ID);
        propertySet.setReadOnly(configurationSetComponent.isReadOnly());
        propertySet.setListIndex(configurationSetComponent.getListIndex());
        ValueExpression valueExpression = FacesExpressionUtility.createValueExpression("#{param.propertyExpressionString}", String.class);
        propertySet.setValueExpression("propertyExpressionString", valueExpression);
        propertySet.setValueExpression("configurationSet", configurationSetComponent.getValueExpression("configurationSet"));
        this.addPropSetButtons(configurationSetComponent, propSetForm);
    }

    private void forwardParameter(HtmlForm modalPanelForm, String paramName) {
        Map requestParamMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String paramValue = (String)requestParamMap.get(paramName);
        if (paramValue != null) {
            FacesComponentUtility.addVerbatimText((UIComponent)modalPanelForm, "<input type='hidden' name='" + paramName + "' value='" + paramValue + "'/>");
        }
    }

    private void addPropSetButtons(ConfigurationSetComponent configurationSetComponent, HtmlForm modalPanelForm) {
        String modalPanelClientId = modalPanelForm.getParent().getClientId(FacesContext.getCurrentInstance());
        HtmlPanelGrid panelGrid = FacesComponentUtility.addPanelGrid((UIComponent)modalPanelForm, null, 2, "buttons-table");
        HtmlAjaxCommandLink okLink = FacesComponentUtility.createComponent(HtmlAjaxCommandLink.class);
        panelGrid.getChildren().add(okLink);
        okLink.setTitle("OK");
        FacesComponentUtility.addParameter((UIComponent)okLink, null, "refresh", configurationSetComponent.getId());
        FacesComponentUtility.addButton((UIComponent)okLink, "OK", "buttonmed");
        if (!configurationSetComponent.isReadOnly()) {
            HtmlOutputLink cancelLink = FacesComponentUtility.addOutputLink((UIComponent)panelGrid, null, "#");
            cancelLink.setOnclick("Richfaces.hideModalPanel('" + modalPanelClientId + "'); return false;");
            cancelLink.setTitle("Cancel");
            FacesComponentUtility.addButton((UIComponent)cancelLink, "CANCEL", "buttonmed");
        }
    }

    private static int getComponentIndex(UIForm component) {
        if (component.getParent() == null) {
            return -1;
        }
        List children = component.getParent().getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) != component) continue;
            return i;
        }
        throw new IllegalStateException("Unable to determine index of component " + component);
    }
}

