/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.transport;

import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.xml.ws.WebServiceException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.web.WebPermissionMapping;
import org.jboss.wsf.container.jboss50.deployment.tomcat.WebMetaDataModifier;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

public class WebAppDeploymentAspect
extends DeploymentAspect {
    private WebMetaDataModifier webMetaDataModifier;

    public void setWebMetaDataModifier(WebMetaDataModifier webMetaDataModifier) {
        this.webMetaDataModifier = webMetaDataModifier;
    }

    public void create(Deployment dep) {
        JBossWebMetaData jbwmd = (JBossWebMetaData)dep.getAttachment(JBossWebMetaData.class);
        if (jbwmd == null) {
            throw new WebServiceException("Cannot find web meta data");
        }
        DeploymentUnit unit = (DeploymentUnit)dep.getAttachment(DeploymentUnit.class);
        if (unit != null) {
            try {
                this.webMetaDataModifier.modifyMetaData(dep);
                try {
                    this.generateJACCPermissions(dep.getSimpleName(), jbwmd);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception generating JACC perms:", e);
                }
                unit.addAttachment(JBossWebMetaData.class, (Object)jbwmd);
                unit.addAttachment("org.jboss.ws.generated.webapp", (Object)Boolean.TRUE);
            }
            catch (Exception ex) {
                WSFDeploymentException.rethrow((Throwable)ex);
            }
        } else {
            throw new IllegalStateException("Cannot obtain deployment unit");
        }
    }

    protected void generateJACCPermissions(String depName, JBossWebMetaData jbwmd) throws Exception {
        PolicyConfigurationFactory policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        PolicyConfiguration policyConfiguration = policyConfigurationFactory.getPolicyConfiguration(depName, false);
        WebPermissionMapping.createPermissions((JBossWebMetaData)jbwmd, (PolicyConfiguration)policyConfiguration);
        policyConfiguration.commit();
    }
}

