/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownComponentTypes;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationProperty;
import org.rhq.core.clientapi.descriptor.configuration.ListProperty;
import org.rhq.core.clientapi.descriptor.configuration.MapProperty;
import org.rhq.core.clientapi.descriptor.configuration.PropertyType;
import org.rhq.core.clientapi.descriptor.configuration.SimpleProperty;
import org.rhq.core.clientapi.descriptor.plugin.MetricDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.OperationDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ResourceDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ServiceDescriptor;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.plugins.jbossas5.helper.MoreKnownComponentTypes;
import org.rhq.plugins.jbossas5.util.MetadataConversionUtils;
import org.rhq.plugins.jbossas5.util.RhqNamespacePrefixMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDescriptorGenerator {
    private static final Log LOG = LogFactory.getLog(PluginDescriptorGenerator.class);
    private static final QName SIMPLE_PROPERTY_QNAME = new QName("urn:xmlns:rhq-configuration", "simple-property");
    private static final QName LIST_PROPERTY_QNAME = new QName("urn:xmlns:rhq-configuration", "list-property");
    private static final QName MAP_PROPERTY_QNAME = new QName("urn:xmlns:rhq-configuration", "map-property");
    private static Map<PropertySimpleType, PropertyType> TYPE_MAP = new HashMap<PropertySimpleType, PropertyType>();

    public static void generatePluginDescriptor(ManagementView managementView, File tempDir) throws Exception {
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        PluginDescriptorGenerator.addComponentsToDescriptor(managementView, pluginDescriptor);
        PluginDescriptorGenerator.addDeploymentsToDescriptor(managementView, pluginDescriptor);
        File tempFile = File.createTempFile("rhq-plugin", ".xml", tempDir);
        PluginDescriptorGenerator.writeToFile(pluginDescriptor, tempFile);
    }

    private static void addDeploymentsToDescriptor(ManagementView managementView, PluginDescriptor pluginDescriptor) throws Exception {
        Set<String> knownDeploymentTypeNames = PluginDescriptorGenerator.getKnownDeploymentTypeNames();
        for (String deploymentTypeName : knownDeploymentTypeNames) {
            Set deploymentNames = managementView.getDeploymentNamesForType(deploymentTypeName);
            if (deploymentNames == null || deploymentNames.isEmpty()) {
                LOG.warn((Object)("No deployments of type [" + deploymentTypeName + "] found."));
                continue;
            }
            ManagedDeployment deployment = null;
            for (String deploymentName : deploymentNames) {
                try {
                    deployment = managementView.getDeployment(deploymentName);
                    break;
                }
                catch (NoSuchDeploymentException e) {
                    LOG.warn((Object)e);
                }
            }
            if (deployment == null) {
                LOG.warn((Object)("Unable to successfully retrieve a Deployment of type [" + deploymentTypeName + "] due to https://jira.jboss.org/jira/browse/JBAS-5640."));
                continue;
            }
            ResourceType resourceType = MetadataConversionUtils.convertDeploymentToResourceType(deploymentTypeName, deployment);
            PluginDescriptorGenerator.convertAndMergeResourceType(pluginDescriptor, resourceType);
        }
    }

    private static void addComponentsToDescriptor(ManagementView managementView, PluginDescriptor pluginDescriptor) throws Exception {
        Set<ComponentType> knownComponentTypes = PluginDescriptorGenerator.getKnownComponentTypes();
        for (ComponentType componentType : knownComponentTypes) {
            Set components = managementView.getComponentsForType(componentType);
            if (components == null || components.isEmpty()) {
                LOG.warn((Object)("No components of type [" + componentType + "] found."));
                continue;
            }
            if (componentType.getSubtype().equals("*")) {
                for (ManagedComponent component : components) {
                    PluginDescriptorGenerator.addComponentToDescriptor(pluginDescriptor, component);
                }
                continue;
            }
            ManagedComponent component = (ManagedComponent)components.iterator().next();
            PluginDescriptorGenerator.addComponentToDescriptor(pluginDescriptor, component);
        }
    }

    private static void addComponentToDescriptor(PluginDescriptor pluginDescriptor, ManagedComponent component) {
        ResourceType resourceType = MetadataConversionUtils.convertComponentToResourceType(component);
        PluginDescriptorGenerator.convertAndMergeResourceType(pluginDescriptor, resourceType);
    }

    private static void convertAndMergeResourceType(PluginDescriptor pluginDescriptor, ResourceType resourceType) {
        List services = pluginDescriptor.getServices();
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.setName(resourceType.getName());
        if (resourceType.isSingleton()) {
            serviceDescriptor.setSingleton(Boolean.valueOf(resourceType.isSingleton()));
        }
        PluginDescriptorGenerator.convertAndMergeOperationDefinitions(resourceType, (ResourceDescriptor)serviceDescriptor);
        PluginDescriptorGenerator.convertAndMergeMetricDefinitions(resourceType, serviceDescriptor);
        PluginDescriptorGenerator.convertAndMergeResourceConfiguration(resourceType, serviceDescriptor);
        services.add(serviceDescriptor);
    }

    private static void convertAndMergeResourceConfiguration(ResourceType resourceType, ServiceDescriptor serviceDescriptor) {
        ConfigurationDefinition resourceConfigDef = resourceType.getResourceConfigurationDefinition();
        ConfigurationDescriptor resourceConfigDescriptor = PluginDescriptorGenerator.convertConfigurationDefinitionToConfigurationDescriptor(resourceConfigDef);
        serviceDescriptor.setResourceConfiguration(resourceConfigDescriptor);
    }

    private static void convertAndMergeMetricDefinitions(ResourceType resourceType, ServiceDescriptor serviceDescriptor) {
        List metricDescriptors = serviceDescriptor.getMetric();
        for (MeasurementDefinition metricDef : resourceType.getMetricDefinitions()) {
            MetricDescriptor metricDescriptor = new MetricDescriptor();
            metricDescriptors.add(metricDescriptor);
            if (metricDef.getCategory() != null) {
                metricDescriptor.setCategory(metricDef.getCategory().name().toLowerCase());
            }
            metricDescriptor.setDataType(metricDef.getDataType().name().toLowerCase());
            metricDescriptor.setDefaultInterval(Integer.valueOf((int)metricDef.getDefaultInterval()));
            metricDescriptor.setDefaultOn(Boolean.valueOf(metricDef.isDefaultOn()));
            metricDescriptor.setDescription(metricDef.getDescription());
            metricDescriptor.setDestinationType(metricDef.getDestinationType());
            metricDescriptor.setDisplayName(metricDef.getDisplayName());
            if (metricDef.getDisplayType() != null) {
                metricDescriptor.setDisplayType(metricDef.getDisplayType().name().toLowerCase());
            }
            if (metricDef.getNumericType() != null) {
                metricDescriptor.setMeasurementType(metricDef.getNumericType().name().toLowerCase());
            }
            metricDescriptor.setProperty(metricDef.getName());
        }
    }

    private static void convertAndMergeOperationDefinitions(ResourceType resourceType, ResourceDescriptor resourceDescriptor) {
        List operationDescriptors = resourceDescriptor.getOperation();
        for (OperationDefinition opDef : resourceType.getOperationDefinitions()) {
            OperationDescriptor operationDescriptor = new OperationDescriptor();
            operationDescriptors.add(operationDescriptor);
            operationDescriptor.setDescription(opDef.getDescription());
            operationDescriptor.setDisplayName(opDef.getDisplayName());
            operationDescriptor.setName(opDef.getName());
            ConfigurationDefinition paramsConfigDef = opDef.getParametersConfigurationDefinition();
            ConfigurationDescriptor paramsConfigDescriptor = PluginDescriptorGenerator.convertConfigurationDefinitionToConfigurationDescriptor(paramsConfigDef);
            operationDescriptor.setParameters(paramsConfigDescriptor);
            ConfigurationDefinition resultsConfigDef = opDef.getResultsConfigurationDefinition();
            ConfigurationDescriptor resultsConfigDescriptor = PluginDescriptorGenerator.convertConfigurationDefinitionToConfigurationDescriptor(resultsConfigDef);
            operationDescriptor.setResults(resultsConfigDescriptor);
            operationDescriptor.setTimeout(opDef.getTimeout());
        }
    }

    private static ConfigurationDescriptor convertConfigurationDefinitionToConfigurationDescriptor(ConfigurationDefinition configDef) {
        if (configDef == null) {
            return null;
        }
        ConfigurationDescriptor configDescriptor = new ConfigurationDescriptor();
        configDescriptor.setNotes(configDef.getDescription());
        for (PropertyDefinition propDef : configDef.getPropertyDefinitions().values()) {
            ConfigurationProperty configProp = PluginDescriptorGenerator.convertPropertyDefinitionToConfigurationProperty(propDef);
            JAXBElement<? extends ConfigurationProperty> propElement = PluginDescriptorGenerator.getJAXBElement(configProp);
            configDescriptor.getConfigurationProperty().add(propElement);
        }
        return configDescriptor;
    }

    private static ConfigurationProperty convertPropertyDefinitionToConfigurationProperty(PropertyDefinition propDef) {
        ListProperty configProp;
        if (propDef instanceof PropertyDefinitionSimple) {
            PropertyDefinitionSimple propDefSimple = (PropertyDefinitionSimple)propDef;
            SimpleProperty simpleProp = new SimpleProperty();
            simpleProp.setDefaultValue(propDefSimple.getDefaultValue());
            simpleProp.setDefaultValueDescription(propDefSimple.getDefaultValue());
            simpleProp.setInitialValue(propDefSimple.getDefaultValue());
            if (propDefSimple.getType() != PropertySimpleType.STRING) {
                simpleProp.setType(TYPE_MAP.get(propDefSimple.getType()));
            }
            configProp = simpleProp;
        } else if (propDef instanceof PropertyDefinitionList) {
            PropertyDefinitionList propDefList = (PropertyDefinitionList)propDef;
            ListProperty listProp = new ListProperty();
            ConfigurationProperty memberConfigProp = PluginDescriptorGenerator.convertPropertyDefinitionToConfigurationProperty(propDefList.getMemberDefinition());
            JAXBElement<? extends ConfigurationProperty> propElement = PluginDescriptorGenerator.getJAXBElement(memberConfigProp);
            listProp.setConfigurationProperty(propElement);
            configProp = listProp;
        } else if (propDef instanceof PropertyDefinitionMap) {
            PropertyDefinitionMap propDefMap = (PropertyDefinitionMap)propDef;
            MapProperty mapProp = new MapProperty();
            for (PropertyDefinition itemPropDef : propDefMap.getPropertyDefinitions().values()) {
                ConfigurationProperty itemConfigProp = PluginDescriptorGenerator.convertPropertyDefinitionToConfigurationProperty(itemPropDef);
                JAXBElement<? extends ConfigurationProperty> propElement = PluginDescriptorGenerator.getJAXBElement(itemConfigProp);
                mapProp.getConfigurationProperty().add(propElement);
            }
            configProp = mapProp;
        } else {
            throw new IllegalStateException("Invalid property definition type: " + propDef.getClass().getName());
        }
        configProp.setDescription(propDef.getDescription());
        configProp.setName(propDef.getName());
        if (propDef.isReadOnly()) {
            configProp.setReadOnly(Boolean.valueOf(propDef.isReadOnly()));
        }
        if (!propDef.isRequired()) {
            configProp.setRequired(Boolean.valueOf(propDef.isRequired()));
        }
        if (propDef.isSummary()) {
            configProp.setSummary(Boolean.valueOf(propDef.isSummary()));
        }
        return configProp;
    }

    private static JAXBElement<? extends ConfigurationProperty> getJAXBElement(ConfigurationProperty configProp) {
        QName qname;
        if (configProp instanceof SimpleProperty) {
            qname = SIMPLE_PROPERTY_QNAME;
        } else if (configProp instanceof ListProperty) {
            qname = LIST_PROPERTY_QNAME;
        } else if (configProp instanceof MapProperty) {
            qname = MAP_PROPERTY_QNAME;
        } else {
            throw new IllegalStateException();
        }
        JAXBElement propElement = new JAXBElement(qname, configProp.getClass(), (Object)configProp);
        return propElement;
    }

    private static Set<String> getKnownDeploymentTypeNames() {
        LinkedHashSet<String> knownDeploymentTypeNames = new LinkedHashSet<String>();
        for (KnownDeploymentTypes type : KnownDeploymentTypes.values()) {
            knownDeploymentTypeNames.add(type.getType());
        }
        return knownDeploymentTypeNames;
    }

    private static Set<ComponentType> getKnownComponentTypes() {
        LinkedHashSet<ComponentType> knownComponentTypes = new LinkedHashSet<ComponentType>();
        for (KnownComponentTypes.DataSourceTypes dataSourceTypes : KnownComponentTypes.DataSourceTypes.values()) {
            knownComponentTypes.add(dataSourceTypes.getType());
        }
        for (KnownComponentTypes.ConnectionFactoryTypes connectionFactoryTypes : KnownComponentTypes.ConnectionFactoryTypes.values()) {
            knownComponentTypes.add(connectionFactoryTypes.getType());
        }
        for (KnownComponentTypes.JMSDestination jMSDestination : KnownComponentTypes.JMSDestination.values()) {
            knownComponentTypes.add(jMSDestination.getType());
        }
        for (KnownComponentTypes.EJB eJB : KnownComponentTypes.EJB.values()) {
            knownComponentTypes.add(eJB.getType());
        }
        for (KnownComponentTypes.MBean mBean : KnownComponentTypes.MBean.values()) {
            knownComponentTypes.add(mBean.getType());
        }
        for (MoreKnownComponentTypes.MBean mBean : MoreKnownComponentTypes.MBean.values()) {
            knownComponentTypes.add(mBean.getType());
        }
        for (KnownComponentTypes.MCBean mCBean : KnownComponentTypes.MCBean.values()) {
            knownComponentTypes.add(mCBean.getType());
        }
        for (MoreKnownComponentTypes.MCBean mCBean : MoreKnownComponentTypes.MCBean.values()) {
            knownComponentTypes.add(mCBean.getType());
        }
        for (MoreKnownComponentTypes.WAR wAR : MoreKnownComponentTypes.WAR.values()) {
            knownComponentTypes.add(wAR.getType());
        }
        return knownComponentTypes;
    }

    private static void writeToFile(PluginDescriptor pluginDescriptor, File file) throws Exception {
        LOG.info((Object)("Writing plugin descriptor to [" + file + "]..."));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.rhq.core.clientapi.descriptor.plugin");
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new RhqNamespacePrefixMapper());
        marshaller.marshal((Object)pluginDescriptor, (OutputStream)outputStream);
        ((OutputStream)outputStream).close();
    }

    static {
        TYPE_MAP.put(PropertySimpleType.BOOLEAN, PropertyType.BOOLEAN);
        TYPE_MAP.put(PropertySimpleType.DIRECTORY, PropertyType.DIRECTORY);
        TYPE_MAP.put(PropertySimpleType.DOUBLE, PropertyType.DOUBLE);
        TYPE_MAP.put(PropertySimpleType.FILE, PropertyType.FILE);
        TYPE_MAP.put(PropertySimpleType.FLOAT, PropertyType.FLOAT);
        TYPE_MAP.put(PropertySimpleType.INTEGER, PropertyType.INTEGER);
        TYPE_MAP.put(PropertySimpleType.LONG, PropertyType.LONG);
        TYPE_MAP.put(PropertySimpleType.LONG_STRING, PropertyType.LONG_STRING);
        TYPE_MAP.put(PropertySimpleType.PASSWORD, PropertyType.PASSWORD);
        TYPE_MAP.put(PropertySimpleType.STRING, PropertyType.STRING);
    }
}

