/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.net.jar;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gatein.common.jar.JarEntryInfo;
import org.gatein.common.jar.JarInfo;
import org.gatein.common.net.URLFilter;
import org.gatein.common.net.URLNavigationProvider;
import org.gatein.common.net.URLVisitor;

public class JarURLNavigationProvider
implements URLNavigationProvider {
    public void visit(URL url, URLVisitor visitor, URLFilter filter) throws IllegalArgumentException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null URL not accepted");
        }
        if (!"jar".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Only jar URL are accepted, not " + url.getProtocol());
        }
        JarURLConnection conn = (JarURLConnection)url.openConnection();
        this.visit(conn, visitor, filter);
    }

    private void visit(JarURLConnection conn, URLVisitor visitor, URLFilter filter) throws IOException {
        JarFile jarFile = conn.getJarFile();
        URL jarURL = conn.getJarFileURL();
        JarEntry rootEntry = conn.getJarEntry();
        if (rootEntry != null) {
            JarEntry testDirEntry = conn.getJarFile().getJarEntry(rootEntry + "/");
            if (testDirEntry != null) {
                rootEntry = testDirEntry;
            }
        } else {
            rootEntry = new JarEntry("/");
        }
        JarEntryInfo rootEntryInfo = new JarEntryInfo(rootEntry);
        JarInfo jarInfo = new JarInfo(jarFile);
        boolean enabled = true;
        Stack stack = new Stack(jarURL, rootEntryInfo);
        Iterator<JarEntryInfo> i = jarInfo.entries();
        while (i.hasNext()) {
            URL url;
            String name;
            JarEntryInfo entryInfo = i.next();
            if (!entryInfo.equals(rootEntryInfo) && !entryInfo.isDescendantOf(rootEntryInfo)) continue;
            List<String> relPath = rootEntryInfo.size() > 1 ? entryInfo.getNames().subList(rootEntryInfo.size() - 1, entryInfo.size()) : entryInfo.getNames();
            while (stack.size() < relPath.size() - 1 && enabled) {
                boolean visit;
                name = relPath.get(stack.size());
                stack.push(name, true);
                url = stack.getURL();
                boolean bl = visit = filter == null || filter.acceptDir(url);
                if (visit) {
                    visitor.startDir(url, name);
                    continue;
                }
                enabled = false;
            }
            while (stack.size() > relPath.size() - 1) {
                URL url2 = stack.getURL();
                Stack.Entry entry = stack.pop();
                if (enabled) {
                    String name2 = entry.name;
                    visitor.endDir(url2, name2);
                }
                enabled = true;
            }
            if (!enabled) continue;
            if (entryInfo.isDirectory()) {
                boolean visit;
                name = relPath.get(relPath.size() - 1);
                stack.push(name, true);
                url = stack.getURL();
                boolean bl = visit = filter == null || filter.acceptDir(url);
                if (visit) {
                    visitor.startDir(url, name);
                    continue;
                }
                enabled = false;
                continue;
            }
            name = relPath.get(relPath.size() - 1);
            stack.push(name, false);
            url = stack.getURL();
            if (filter.acceptFile(url)) {
                visitor.file(url, name);
            }
            stack.pop();
        }
        while (stack.size() > 0) {
            URL url = stack.getURL();
            Stack.Entry entry = stack.pop();
            if (enabled) {
                String name = entry.name;
                visitor.endDir(url, name);
            }
            enabled = true;
        }
    }

    private static class Stack {
        final URL jarURL;
        final JarEntryInfo root;
        final LinkedList<Entry> entries;
        boolean enabled;

        public Stack(URL jarURL, JarEntryInfo root) {
            this.jarURL = jarURL;
            this.root = root;
            this.entries = new LinkedList();
        }

        int size() {
            return this.entries.size();
        }

        void push(String name, boolean dir) {
            this.entries.addLast(new Entry(name, dir));
        }

        Entry pop() {
            return this.entries.removeLast();
        }

        Entry peek() {
            return this.entries.getLast();
        }

        URL getURL() throws MalformedURLException {
            int i;
            StringBuffer tmp = new StringBuffer(this.jarURL.toString()).append("!/");
            for (i = 0; i < this.root.size() - 1; ++i) {
                String name = this.root.getName(i);
                if (!tmp.toString().endsWith("/")) {
                    tmp.append("/");
                }
                if (name.equals("/")) continue;
                tmp.append(name);
            }
            for (i = 0; i < this.entries.size(); ++i) {
                Entry entry = this.entries.get(i);
                String name = entry.name;
                if (!tmp.toString().endsWith("/")) {
                    tmp.append("/");
                }
                if (name.equals("/")) continue;
                tmp.append(name);
            }
            Entry entry = this.peek();
            if (entry.dir && !entry.name.equals("/") && !tmp.toString().endsWith("/")) {
                tmp.append('/');
            }
            return new URL("jar", "", tmp.toString());
        }

        static class Entry {
            final String name;
            final boolean dir;

            public Entry(String name, boolean dir) {
                this.name = name;
                this.dir = dir;
            }
        }
    }
}

