/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import java.io.Serializable;
import java.text.DateFormat;
import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
public class MeasurementDataPK
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="TIME_STAMP")
    long timestamp;
    @Column(name="SCHEDULE_ID")
    int scheduleId;

    protected MeasurementDataPK() {
    }

    public MeasurementDataPK(int scheduleId) {
        this.timestamp = System.currentTimeMillis();
        this.scheduleId = scheduleId;
    }

    public MeasurementDataPK(long timestamp, int scheduleId) {
        this.timestamp = timestamp;
        this.scheduleId = scheduleId;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.scheduleId;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeasurementDataPK)) {
            return false;
        }
        MeasurementDataPK other = (MeasurementDataPK)obj;
        if (this.scheduleId != other.scheduleId) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }

    public String toString() {
        return "MeasurementDataPK: timestamp=[" + DateFormat.getInstance().format(this.timestamp) + "], scheduleId=[" + this.scheduleId + "]";
    }
}

