/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.ejb.EJBContext;
import javax.ejb.NoSuchEJBException;
import javax.persistence.EntityManager;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulBeanContextReference;
import org.jboss.ejb3.stateful.StatefulContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxiedStatefulBeanContext
extends StatefulBeanContext
implements Externalizable {
    private static final long serialVersionUID = -5156610459343035743L;
    private transient StatefulBeanContext delegate;
    private Object oid;
    private String containerId;
    private StatefulBeanContextReference parentRef;

    public ProxiedStatefulBeanContext(StatefulBeanContext delegate) {
        this.delegate = delegate;
        this.oid = delegate.getId();
        assert (this.oid != null) : "delegate.getId() is null";
        this.containerId = delegate.getContainer().getObjectName().getCanonicalName();
        this.parentRef = new StatefulBeanContextReference(delegate.getContainedIn());
    }

    public ProxiedStatefulBeanContext() {
    }

    protected StatefulBeanContext getDelegate() {
        if (this.delegate == null) {
            for (StatefulBeanContext ctx : this.parentRef.getBeanContext().getContains()) {
                Object matchingOid = ctx.getId();
                if (!this.oid.equals(matchingOid) || !ctx.getContainer().getObjectName().getCanonicalName().equals(this.containerId)) continue;
                this.delegate = ctx;
                break;
            }
            if (this.delegate == null) {
                throw new RuntimeException("Failed to read delegate");
            }
            this.markedForReplication = true;
        }
        return this.delegate;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.oid);
        out.writeUTF(this.containerId);
        out.writeObject(this.parentRef);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.oid = in.readObject();
        this.containerId = in.readUTF();
        this.parentRef = (StatefulBeanContextReference)in.readObject();
        assert (this.parentRef != null) : "parentRef is null";
    }

    @Override
    public List<StatefulBeanContext> getContains() {
        return this.getDelegate().getContains();
    }

    @Override
    public EntityManager getExtendedPersistenceContext(String id) {
        return this.getDelegate().getExtendedPersistenceContext(id);
    }

    @Override
    public void addExtendedPersistenceContext(String id, EntityManager pc) {
        this.getDelegate().addExtendedPersistenceContext(id, pc);
    }

    @Override
    public Map<String, EntityManager> getExtendedPersistenceContexts() {
        return this.getDelegate().getExtendedPersistenceContexts();
    }

    @Override
    public void removeExtendedPersistenceContext(String id) {
        this.getDelegate().removeExtendedPersistenceContext(id);
    }

    @Override
    public boolean scanForExtendedPersistenceContext(String id, StatefulBeanContext ignore) {
        return this.getDelegate().scanForExtendedPersistenceContext(id, ignore);
    }

    @Override
    public StatefulBeanContext getContainedIn() {
        return this.getDelegate().getContainedIn();
    }

    @Override
    public void addContains(StatefulBeanContext ctx) {
        this.getDelegate().addContains(ctx);
    }

    @Override
    public void removeContains(StatefulBeanContext ctx) {
        this.getDelegate().removeContains(ctx);
    }

    @Override
    public StatefulBeanContext pushContainedIn() {
        return this.getDelegate().pushContainedIn();
    }

    @Override
    public void popContainedIn() {
        this.getDelegate().popContainedIn();
    }

    @Override
    public StatefulBeanContext getUltimateContainedIn() {
        return this.getDelegate().getUltimateContainedIn();
    }

    @Override
    public boolean isInUse() {
        return super.isInUse();
    }

    @Override
    public void setInUse(boolean inUse) {
        super.setInUse(inUse);
        this.getDelegate().setInUse(inUse);
        if (!inUse) {
            this.delegate = null;
        }
    }

    @Override
    public boolean isDiscarded() {
        return this.getDelegate().isDiscarded();
    }

    @Override
    public void setDiscarded(boolean discarded) {
        this.getDelegate().setDiscarded(discarded);
    }

    @Override
    public boolean isRemoved() {
        return this.getDelegate().isRemoved();
    }

    @Override
    public ReentrantLock getLock() {
        return this.getDelegate().getLock();
    }

    @Override
    public boolean isInInvocation() {
        return this.getDelegate().isInInvocation();
    }

    @Override
    public void setInInvocation(boolean inInvocation) {
        this.getDelegate().setInInvocation(inInvocation);
    }

    @Override
    public Object getId() {
        return this.getDelegate().getId();
    }

    @Override
    public boolean isTxSynchronized() {
        return this.getDelegate().isTxSynchronized();
    }

    @Override
    public void setTxSynchronized(boolean txSynchronized) {
        this.getDelegate().setTxSynchronized(txSynchronized);
    }

    @Override
    public void remove() {
        StatefulBeanContext del = null;
        try {
            del = this.getDelegate();
        }
        catch (NoSuchEJBException gone) {
            return;
        }
        del.remove();
    }

    @Override
    public StatefulContainer getContainer() {
        return this.getDelegate().getContainer();
    }

    @Override
    public Object getInstance() {
        return this.getDelegate().getInstance();
    }

    @Override
    public SimpleMetaData getMetaData() {
        return this.getDelegate().getMetaData();
    }

    @Override
    public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos) {
        return this.getDelegate().getInterceptorInstances(interceptorInfos);
    }

    @Override
    public void extractBeanAndInterceptors() {
        this.getDelegate().extractBeanAndInterceptors();
    }

    @Override
    public EJBContext getEJBContext() {
        return this.getDelegate().getEJBContext();
    }

    @Override
    public void prePassivate() {
    }

    @Override
    public void postActivate() {
    }

    @Override
    public void passivateAfterReplication() {
    }

    @Override
    public void activateAfterReplication() {
    }

    @Override
    public boolean getCanPassivate() {
        if (this.delegate == null) {
            return true;
        }
        return !this.isInUse();
    }

    @Override
    public boolean getCanRemoveFromCache() {
        return this.getDelegate().getCanRemoveFromCache();
    }

    @Override
    public boolean getReplicationIsPassivation() {
        return this.getDelegate().getReplicationIsPassivation();
    }

    @Override
    public void setReplicationIsPassivation(boolean replicationIsPassivation) {
        this.getDelegate().setReplicationIsPassivation(replicationIsPassivation);
    }

    @Override
    public void preReplicate() {
    }

    @Override
    public void postReplicate() {
    }

    @Override
    public Object getInvokedMethodKey() {
        return this.getDelegate().getInvokedMethodKey();
    }

    @Override
    public Object getInterceptor(Class<?> interceptorClass) throws IllegalArgumentException {
        return this.getDelegate().getInterceptor(interceptorClass);
    }

    @Override
    public void initialiseInterceptorInstances() {
        this.getDelegate().initialiseInterceptorInstances();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProxiedStatefulBeanContext) {
            ProxiedStatefulBeanContext other = (ProxiedStatefulBeanContext)obj;
            return this.containerId.equals(other.containerId) && this.oid.equals(other.oid);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 11;
        result = 29 * result + this.containerId.hashCode();
        result = 29 * result + this.oid.hashCode();
        return result;
    }
}

