/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarFile;
import org.jboss.virtual.plugins.context.jar.AbstractStructuredJarHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarHandler
extends AbstractStructuredJarHandler<Object> {
    private static final long serialVersionUID = 1L;

    public JarHandler(VFSContext context, VirtualFileHandler parent, URL url, String name) throws IOException {
        super(context, parent, url, ((JarURLConnection)JarHandler.openConnection(url)).getJarFile(), null, name);
        this.setVfsUrl(new URL("vfs" + url));
        try {
            this.initJarFile();
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
    }

    public JarHandler(VFSContext context, VirtualFileHandler parent, File file, URL url, String name) throws IOException {
        super(context, parent, url, new JarFile(file), null, name);
        this.setVfsUrl(new URL("vfs" + url));
        try {
            this.initJarFile();
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
    }

    @Override
    public boolean removeChild(String path) throws IOException {
        return false;
    }

    @Override
    public boolean delete(int gracePeriod) throws IOException {
        this.getJar().close();
        File jarFile = new File(this.getJar().getName());
        return jarFile.delete();
    }

    @Override
    public boolean isNested() throws IOException {
        return false;
    }
}

