/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.util.Set;
import javax.xml.ws.Holder;
import org.gatein.common.text.TextTools;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.cache.CacheScope;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.consumer.InvocationHandler;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RequestPrecursor;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.oasis.wsrp.v1.CacheControl;
import org.oasis.wsrp.v1.GetMarkup;
import org.oasis.wsrp.v1.MarkupContext;
import org.oasis.wsrp.v1.MarkupParams;
import org.oasis.wsrp.v1.MarkupResponse;
import org.oasis.wsrp.v1.RuntimeContext;
import org.oasis.wsrp.v1.SessionContext;
import org.oasis.wsrp.v1.UserContext;

public class RenderHandler
extends InvocationHandler {
    private static final org.gatein.pc.api.cache.CacheControl DEFAULT_CACHE_CONTROL = new org.gatein.pc.api.cache.CacheControl(0, CacheScope.PRIVATE, null);

    public RenderHandler(WSRPConsumerImpl consumer) {
        super(consumer);
    }

    protected Object prepareRequest(RequestPrecursor requestPrecursor, PortletInvocation invocation) {
        if (!(invocation instanceof RenderInvocation)) {
            throw new IllegalArgumentException("RenderHandler can only handle RenderInvocations!");
        }
        org.oasis.wsrp.v1.PortletContext portletContext = requestPrecursor.getPortletContext();
        log.debug("Consumer about to attempt rendering portlet '" + portletContext.getPortletHandle() + "'");
        return WSRPTypeFactory.createMarkupRequest((org.oasis.wsrp.v1.PortletContext)portletContext, (RuntimeContext)requestPrecursor.runtimeContext, (MarkupParams)requestPrecursor.markupParams);
    }

    protected PortletInvocationResponse processResponse(Object response, PortletInvocation invocation, RequestPrecursor requestPrecursor) {
        String mimeType;
        MarkupResponse markupResponse = (MarkupResponse)response;
        log.debug("Starting processing response");
        this.consumer.getSessionHandler().updateSessionIfNeeded(markupResponse.getSessionContext(), invocation, requestPrecursor.getPortletHandle());
        MarkupContext markupContext = markupResponse.getMarkupContext();
        String markup = markupContext.getMarkupString();
        byte[] binary = markupContext.getMarkupBinary();
        if (markup != null && binary != null) {
            return new ErrorResponse((Throwable)new IllegalArgumentException("Markup response cannot contain both string and binary markup. Per Section 6.1.10 of the WSRP specification, this is a Producer error."));
        }
        if (markup == null && binary == null && !markupContext.isUseCachedMarkup().booleanValue()) {
            return new ErrorResponse((Throwable)new IllegalArgumentException("Markup response must contain at least string or binary markup. Per Section 6.1.10 of the WSRP specification, this is a Producer error."));
        }
        if (markup != null && markup.length() > 0) {
            markup = this.processMarkup(markup, invocation, Boolean.TRUE.equals(markupContext.isRequiresUrlRewriting()));
        }
        if ((mimeType = markupContext.getMimeType()) == null || mimeType.length() == 0) {
            return new ErrorResponse((Throwable)new IllegalArgumentException("No MIME type was provided for portlet content."));
        }
        org.gatein.pc.api.cache.CacheControl cacheControl = this.createCacheControl(markupContext);
        FragmentResponse result = new FragmentResponse(null, null, mimeType, null, markup, markupContext.getPreferredTitle(), cacheControl, invocation.getPortalContext().getModes());
        log.debug("Response processed");
        return result;
    }

    protected void updateUserContext(Object request, UserContext userContext) {
        this.getRenderRequest(request).setUserContext(userContext);
    }

    protected void updateRegistrationContext(Object request) throws PortletInvokerException {
        this.getRenderRequest(request).setRegistrationContext(this.consumer.getRegistrationContext());
    }

    protected RuntimeContext getRuntimeContextFrom(Object request) {
        return this.getRenderRequest(request).getRuntimeContext();
    }

    protected Object performRequest(Object request) throws Exception {
        GetMarkup renderRequest = this.getRenderRequest(request);
        log.debug("getMarkup on '" + renderRequest.getPortletContext().getPortletHandle() + "'");
        Holder sessionContextHolder = new Holder();
        Holder markupContextHolder = new Holder();
        this.consumer.getMarkupService().getMarkup(renderRequest.getRegistrationContext(), renderRequest.getPortletContext(), renderRequest.getRuntimeContext(), renderRequest.getUserContext(), renderRequest.getMarkupParams(), markupContextHolder, sessionContextHolder, new Holder());
        MarkupResponse markupResponse = new MarkupResponse();
        markupResponse.setMarkupContext((MarkupContext)markupContextHolder.value);
        markupResponse.setSessionContext((SessionContext)sessionContextHolder.value);
        return markupResponse;
    }

    private GetMarkup getRenderRequest(Object request) {
        if (request instanceof GetMarkup) {
            return (GetMarkup)request;
        }
        throw new IllegalArgumentException("RenderHandler: Request is not a GetMarkup request!");
    }

    private String processMarkup(String markup, PortletInvocation invocation, boolean needsRewriting) {
        if (needsRewriting) {
            String prefix = this.getNamespaceFrom(invocation.getWindowContext());
            markup = TextTools.replace((String)markup, (String)"wsrp_rewrite_", (String)prefix);
            URLFormat format = new URLFormat(Boolean.valueOf(invocation.getSecurityContext().isSecure()), Boolean.valueOf(invocation.getSecurityContext().isAuthenticated()), Boolean.valueOf(true), Boolean.valueOf(true));
            markup = TextTools.replaceBoundedString((String)markup, (String)"wsrp_rewrite?", (String)"/wsrp_rewrite", (TextTools.StringReplacementGenerator)new ResourceURLStringReplacementGenerator(invocation.getContext(), format, this.consumer, invocation.getTarget()), (boolean)true, (boolean)false);
        }
        return markup;
    }

    private org.gatein.pc.api.cache.CacheControl createCacheControl(MarkupContext markupContext) {
        CacheControl cacheControl = markupContext.getCacheControl();
        org.gatein.pc.api.cache.CacheControl result = DEFAULT_CACHE_CONTROL;
        if (cacheControl != null) {
            int expires = cacheControl.getExpires();
            String userScope = cacheControl.getUserScope();
            if (this.consumer.supportsUserScope(userScope)) {
                CacheScope scope;
                log.debug("RenderHandler.processRenderRequest: trying to cache markup " + userScope + " for " + expires + " seconds.");
                if ("wsrp:forAll".equals(userScope)) {
                    scope = CacheScope.PUBLIC;
                } else if ("wsrp:perUser".equals(userScope)) {
                    scope = CacheScope.PRIVATE;
                } else {
                    throw new IllegalArgumentException("Unknown CacheControl user scope: " + userScope);
                }
                result = new org.gatein.pc.api.cache.CacheControl(expires, scope, cacheControl.getValidateTag());
            }
        }
        return result;
    }

    private static String getResourceURL(String urlAsString, WSRPResourceURL resource) {
        String resourceURL = resource.getResourceURL().toExternalForm();
        log.info("URL '" + urlAsString + "' refers to a resource which are not currently well supported. " + "Attempting to craft a URL that we might be able to work with: '" + resourceURL + "'");
        return resourceURL;
    }

    static class ResourceURLStringReplacementGenerator
    implements TextTools.StringReplacementGenerator {
        private final PortletInvocationContext context;
        private final URLFormat format;
        private final Set<String> supportedCustomModes;
        private final Set<String> supportedCustomWindowStates;
        private final String serverAddress;
        private final String portletApplicationName;

        private ResourceURLStringReplacementGenerator(PortletInvocationContext context, URLFormat format, WSRPConsumer consumer, PortletContext target) {
            this.context = context;
            this.format = format;
            ProducerInfo info = consumer.getProducerInfo();
            this.supportedCustomModes = info.getSupportedCustomModes();
            this.supportedCustomWindowStates = info.getSupportedCustomWindowStates();
            this.serverAddress = info.getEndpointConfigurationInfo().getRemoteHostAddress();
            this.portletApplicationName = target.getApplicationName();
        }

        public String getReplacementFor(String match) {
            WSRPPortletURL portletURL = WSRPPortletURL.create((String)match, this.supportedCustomModes, this.supportedCustomWindowStates);
            if (portletURL instanceof WSRPResourceURL) {
                WSRPResourceURL resource = (WSRPResourceURL)portletURL;
                String replacement = RenderHandler.getResourceURL(match, resource);
                if (replacement.startsWith("/")) {
                    replacement = WSRPResourceURL.createAbsoluteURLFrom((String)replacement, (String)this.serverAddress, (String)this.portletApplicationName);
                }
                return replacement;
            }
            return this.context.renderURL((ContainerURL)portletURL, this.format);
        }
    }
}

