/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.server;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.backup.BackupChain;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.impl.JobWorkspaceRestore;
import org.exoplatform.services.jcr.ext.backup.server.BackupDirNotFoundException;
import org.exoplatform.services.jcr.ext.backup.server.BackupLogNotFoundException;
import org.exoplatform.services.jcr.ext.backup.server.BackupNotFoundException;
import org.exoplatform.services.jcr.ext.backup.server.WorkspaceRestoreExeption;
import org.exoplatform.services.jcr.ext.backup.server.bean.BackupConfigBean;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.BackupServiceInfoBean;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.DetailedInfo;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.DetailedInfoEx;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.ShortInfo;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.ShortInfoList;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/jcr-backup/")
public class HTTPBackupAgent
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger("ext.HTTPBackupAgent");
    private static final CacheControl noCache = new CacheControl();
    private RepositoryService repositoryService;
    private BackupManager backupManager;
    private ThreadLocalSessionProviderService sessionProviderService;

    public HTTPBackupAgent(RepositoryService repoService, BackupManager backupManager, ThreadLocalSessionProviderService sessionProviderService) {
        this.repositoryService = repoService;
        this.backupManager = backupManager;
        this.sessionProviderService = sessionProviderService;
        log.info("HTTPBackupAgent inited");
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/start/{repo}/{ws}")
    public Response start(BackupConfigBean bConfigBeen, @PathParam(value="repo") String repository, @PathParam(value="ws") String workspace) {
        String failMessage;
        Response.Status status;
        Throwable exception;
        try {
            File backupDir = new File(bConfigBeen.getBackupDir());
            if (!backupDir.exists()) {
                throw new BackupDirNotFoundException("The backup folder not exists :  " + backupDir.getAbsolutePath());
            }
            BackupConfig config = new BackupConfig();
            config.setBackupType(bConfigBeen.getBackupType());
            config.setRepository(repository);
            config.setWorkspace(workspace);
            config.setBackupDir(backupDir);
            config.setIncrementalJobPeriod(bConfigBeen.getIncrementalJobPeriod());
            config.setIncrementalJobNumber(bConfigBeen.getIncrementalRepetitionNumber());
            this.validateRepositoryName(repository);
            this.validateWorkspaceName(repository, workspace);
            this.validateOneBackupInstants(repository, workspace);
            BackupChain chain = this.backupManager.startBackup(config);
            ShortInfo shortInfo = new ShortInfo(-1, chain);
            return Response.ok((Object)shortInfo).cacheControl(noCache).build();
        }
        catch (NoSuchWorkspaceException e) {
            exception = e;
            status = Response.Status.NOT_FOUND;
            failMessage = e.getMessage();
        }
        catch (LoginException e) {
            exception = e;
            status = Response.Status.UNAUTHORIZED;
            failMessage = e.getMessage();
        }
        catch (RepositoryException e) {
            exception = e;
            status = Response.Status.INTERNAL_SERVER_ERROR;
            failMessage = e.getMessage();
        }
        catch (RepositoryConfigurationException e) {
            exception = e;
            status = Response.Status.NOT_FOUND;
            failMessage = e.getMessage();
        }
        catch (WorkspaceRestoreExeption e) {
            exception = e;
            status = Response.Status.NOT_FOUND;
            failMessage = e.getMessage();
        }
        catch (BackupOperationException e) {
            exception = e;
            status = Response.Status.INTERNAL_SERVER_ERROR;
            failMessage = e.getMessage();
        }
        catch (BackupConfigurationException e) {
            exception = e;
            status = Response.Status.NOT_FOUND;
            failMessage = e.getMessage();
        }
        catch (Throwable e) {
            exception = e;
            status = Response.Status.INTERNAL_SERVER_ERROR;
            failMessage = e.getMessage();
        }
        log.error("Can not start backup", exception);
        return Response.status((Response.Status)status).entity((Object)("Can not start backup : " + failMessage)).type("text/plain").cacheControl(noCache).build();
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="/drop-workspace/{repo}/{ws}/{force-session-close}")
    public Response dropWorkspace(@PathParam(value="repo") String repository, @PathParam(value="ws") String workspace, @PathParam(value="force-session-close") Boolean forceSessionClose) {
        String failMessage;
        Response.Status status;
        Throwable exception;
        try {
            this.validateRepositoryName(repository);
            this.validateWorkspaceName(repository, workspace);
            if (forceSessionClose.booleanValue()) {
                this.forceCloseSession(repository, workspace);
            }
            RepositoryImpl repositoryImpl = (RepositoryImpl)this.repositoryService.getRepository(repository);
            repositoryImpl.removeWorkspace(workspace);
            this.repositoryService.getConfig().retain();
            return Response.ok().cacheControl(noCache).build();
        }
        catch (RepositoryException e) {
            exception = e;
            status = Response.Status.INTERNAL_SERVER_ERROR;
            failMessage = e.getMessage();
        }
        catch (RepositoryConfigurationException e) {
            exception = e;
            status = Response.Status.INTERNAL_SERVER_ERROR;
            failMessage = e.getMessage();
        }
        catch (Throwable e) {
            exception = e;
            status = Response.Status.INTERNAL_SERVER_ERROR;
            failMessage = e.getMessage();
        }
        log.error("Can not drop the workspace '/" + repository + "/" + workspace + "'", exception);
        return Response.status((Response.Status)status).entity((Object)("Can not drop the workspace '/" + repository + "/" + workspace + "' : " + failMessage)).type("text/plain").cacheControl(noCache).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/restore/{repo}/{id}")
    public Response restore(WorkspaceEntry wEntry, @PathParam(value="repo") String repository, @PathParam(value="id") String backupId) {
        String failMessage;
        Response.Status status;
        Throwable exception;
        try {
            this.validateOneRestoreInstants(repository, wEntry.getName());
            File backupLog = this.getBackupLogbyId(backupId);
            if (backupLog == null) {
                throw new BackupLogNotFoundException("The backup log file with id " + backupId + " not exists.");
            }
            this.validateRepositoryName(repository);
            if (this.isWorkspaceExist(repository, wEntry.getName())) {
                throw new Exception("Workspace " + wEntry.getName() + " already exist!");
            }
            BackupChainLog backupChainLog = new BackupChainLog(backupLog);
            this.backupManager.restore(backupChainLog, repository, wEntry, true);
            Thread.sleep(100L);
            List<JobWorkspaceRestore> restoreJobs = this.backupManager.getRestores();
            JobWorkspaceRestore restore = null;
            for (JobWorkspaceRestore curRestore : restoreJobs) {
                if (!curRestore.getRepositoryName().equals(repository) || !curRestore.getWorkspaceName().equals(wEntry.getName())) continue;
                restore = curRestore;
                break;
            }
            if (restore != null) {
                ShortInfo info = new ShortInfo(1, restore.getBackupChainLog(), restore.getStartTime(), restore.getEndTime(), restore.getStateRestore(), restore.getRepositoryName(), restore.getWorkspaceName());
                return Response.ok((Object)info).cacheControl(noCache).build();
            }
            return Response.ok().cacheControl(noCache).build();
        }
        catch (WorkspaceRestoreExeption e) {
            exception = e;
            status = Response.Status.FORBIDDEN;
            failMessage = e.getMessage();
        }
        catch (RepositoryException e) {
            exception = e;
            status = Response.Status.NOT_FOUND;
            failMessage = e.getMessage();
        }
        catch (RepositoryConfigurationException e) {
            exception = e;
            status = Response.Status.NOT_FOUND;
            failMessage = e.getMessage();
        }
        catch (BackupLogNotFoundException e) {
            exception = e;
            status = Response.Status.NOT_FOUND;
            failMessage = e.getMessage();
        }
        catch (Throwable e) {
            exception = e;
            status = Response.Status.INTERNAL_SERVER_ERROR;
            failMessage = e.getMessage();
        }
        log.error("Can not start restore the workspace '/" + repository + "/" + wEntry.getName() + "' from backup log with id '" + backupId + "'", exception);
        return Response.status((Response.Status)status).entity((Object)("Can not start restore the workspace '/" + repository + "/" + wEntry.getName() + "' from backup log with id '" + backupId + "' : " + failMessage)).type("text/plain").cacheControl(noCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/stop/{id}")
    public Response stop(@PathParam(value="id") String backupId) {
        String failMessage;
        Response.Status status;
        Throwable exception;
        try {
            BackupChain bch = this.backupManager.findBackup(backupId);
            if (bch == null) {
                throw new BackupNotFoundException("No active backup with id '" + backupId + "'");
            }
            this.backupManager.stopBackup(bch);
            ShortInfo shortInfo = null;
            for (BackupChainLog chainLog : this.backupManager.getBackupsLogs()) {
                if (!backupId.equals(chainLog.getBackupId())) continue;
                shortInfo = new ShortInfo(0, chainLog);
                System.out.println();
                break;
            }
            if (shortInfo == null) {
                throw new BackupNotFoundException("No completed backup with id '" + backupId + "'");
            }
            return Response.ok(shortInfo).cacheControl(noCache).build();
        }
        catch (BackupNotFoundException e) {
            exception = e;
            status = Response.Status.NOT_FOUND;
            failMessage = e.getMessage();
        }
        catch (Throwable e) {
            exception = e;
            status = Response.Status.INTERNAL_SERVER_ERROR;
            failMessage = e.getMessage();
        }
        log.error("Can not stop backup", exception);
        return Response.status((Response.Status)status).entity((Object)("Can not stop backup : " + failMessage)).type("text/plain").cacheControl(noCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/info")
    public Response info() {
        try {
            BackupServiceInfoBean infoBeen = new BackupServiceInfoBean(this.backupManager.getFullBackupType(), this.backupManager.getIncrementalBackupType(), this.backupManager.getBackupDirectory().getAbsolutePath(), this.backupManager.getDefaultIncrementalJobPeriod());
            return Response.ok((Object)infoBeen).cacheControl(noCache).build();
        }
        catch (Throwable e) {
            log.error("Can not get information about backup service", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Can not get information about backup service : " + e.getMessage())).type("text/plain").cacheControl(noCache).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/info/backup")
    public Response infoBackup() {
        try {
            ArrayList<ShortInfo> list = new ArrayList<ShortInfo>();
            for (BackupChain chain : this.backupManager.getCurrentBackups()) {
                list.add(new ShortInfo(-1, chain));
            }
            for (BackupChainLog chainLog : this.backupManager.getBackupsLogs()) {
                if (this.backupManager.findBackup(chainLog.getBackupId()) != null) continue;
                list.add(new ShortInfo(0, chainLog));
            }
            ShortInfoList shortInfoList = new ShortInfoList(list);
            return Response.ok((Object)shortInfoList).cacheControl(noCache).build();
        }
        catch (Throwable e) {
            log.error("Can not get information about current or completed backups", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Can not get information about current or completed backups" + e.getMessage())).type("text/plain").cacheControl(noCache).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/info/backup/{id}")
    public Response infoBackupId(@PathParam(value="id") String id) {
        try {
            BackupChain current = this.backupManager.findBackup(id);
            if (current != null) {
                DetailedInfo info = new DetailedInfo(-1, current);
                return Response.ok((Object)info).cacheControl(noCache).build();
            }
            BackupChainLog completed = null;
            for (BackupChainLog chainLog : this.backupManager.getBackupsLogs()) {
                if (!id.equals(chainLog.getBackupId())) continue;
                completed = chainLog;
            }
            if (completed != null) {
                DetailedInfo info = new DetailedInfo(0, completed);
                return Response.ok((Object)info).cacheControl(noCache).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No current or completed backup with 'id' " + id)).type("text/plain").cacheControl(noCache).build();
        }
        catch (Throwable e) {
            log.error("Can not get information about current or completed backup with 'id' " + id, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Can not get information about current or completed backup with 'id' " + id + " : " + e.getMessage())).type("text/plain").cacheControl(noCache).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/info/backup/current")
    public Response infoBackupCurrent() {
        try {
            ArrayList<ShortInfo> list = new ArrayList<ShortInfo>();
            for (BackupChain chain : this.backupManager.getCurrentBackups()) {
                list.add(new ShortInfo(-1, chain));
            }
            ShortInfoList shortInfoList = new ShortInfoList(list);
            return Response.ok((Object)shortInfoList).cacheControl(noCache).build();
        }
        catch (Throwable e) {
            log.error("Can not get information about current backups", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Can not get information about current backups" + e.getMessage())).type("text/plain").cacheControl(noCache).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/info/backup/completed")
    public Response infoBackupCompleted() {
        try {
            ArrayList<ShortInfo> completedList = new ArrayList<ShortInfo>();
            for (BackupChainLog chainLog : this.backupManager.getBackupsLogs()) {
                if (this.backupManager.findBackup(chainLog.getBackupId()) != null) continue;
                completedList.add(new ShortInfo(0, chainLog));
            }
            ShortInfoList list = new ShortInfoList(completedList);
            return Response.ok((Object)list).cacheControl(noCache).build();
        }
        catch (Throwable e) {
            log.error("Can not get information about completed backups", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Can not get information about completed backups" + e.getMessage())).type("text/plain").cacheControl(noCache).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/info/backup/{repo}/{ws}")
    public Response infoBackupByWorkspase(@PathParam(value="repo") String repository, @PathParam(value="ws") String workspace) {
        try {
            ArrayList<ShortInfo> list = new ArrayList<ShortInfo>();
            for (BackupChain chain : this.backupManager.getCurrentBackups()) {
                if (!repository.equals(chain.getBackupConfig().getRepository()) || !workspace.equals(chain.getBackupConfig().getWorkspace())) continue;
                list.add(new ShortInfo(-1, chain));
            }
            for (BackupChainLog chainLog : this.backupManager.getBackupsLogs()) {
                if (this.backupManager.findBackup(chainLog.getBackupId()) != null || !repository.equals(chainLog.getBackupConfig().getRepository()) || !workspace.equals(chainLog.getBackupConfig().getWorkspace())) continue;
                list.add(new ShortInfo(0, chainLog));
            }
            ShortInfoList shortInfoList = new ShortInfoList(list);
            return Response.ok((Object)shortInfoList).cacheControl(noCache).build();
        }
        catch (Throwable e) {
            log.error("Can not get information about current or completed backups", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Can not get information about current or completed backups" + e.getMessage())).type("text/plain").cacheControl(noCache).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/info/restore/{repo}/{ws}")
    public Response infoRestore(@PathParam(value="repo") String repository, @PathParam(value="ws") String workspace) {
        try {
            JobWorkspaceRestore restoreJob = this.backupManager.getLastRestore(repository, workspace);
            if (restoreJob != null) {
                DetailedInfoEx info = new DetailedInfoEx(1, restoreJob.getBackupChainLog(), restoreJob.getStartTime(), restoreJob.getEndTime(), restoreJob.getStateRestore(), restoreJob.getRepositoryName(), restoreJob.getWorkspaceName(), restoreJob.getWorkspaceEntry(), restoreJob.getRestoreException() == null ? "" : restoreJob.getRestoreException().getMessage());
                return Response.ok((Object)info).cacheControl(noCache).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No resrore for workspace /" + repository + "/" + workspace + "'")).type("text/plain").cacheControl(noCache).build();
        }
        catch (Throwable e) {
            log.error("Can not get information about current restore for workspace /" + repository + "/" + workspace + "'", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Can not get information about current restore for workspace /" + repository + "/" + workspace + "' : " + e.getMessage())).type("text/plain").cacheControl(noCache).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/info/restores")
    public Response infoRestores() {
        try {
            List<JobWorkspaceRestore> restoreJobs = this.backupManager.getRestores();
            ArrayList<JobWorkspaceRestore> jobs = new ArrayList<JobWorkspaceRestore>();
            for (int i = restoreJobs.size() - 1; i >= 0; --i) {
                JobWorkspaceRestore job = restoreJobs.get(i);
                boolean isUnique = true;
                for (JobWorkspaceRestore unJob : jobs) {
                    if (!unJob.getRepositoryName().equals(job.getRepositoryName()) || !unJob.getWorkspaceName().equals(job.getWorkspaceName())) continue;
                    isUnique = false;
                }
                if (!isUnique) continue;
                jobs.add(job);
            }
            ArrayList<ShortInfo> list = new ArrayList<ShortInfo>();
            for (JobWorkspaceRestore job : jobs) {
                ShortInfo info = new ShortInfo(1, job.getBackupChainLog(), job.getStartTime(), job.getEndTime(), job.getStateRestore(), job.getRepositoryName(), job.getWorkspaceName());
                list.add(info);
            }
            return Response.ok((Object)new ShortInfoList(list)).cacheControl(noCache).build();
        }
        catch (Throwable e) {
            log.error("Can not get information about current restores.", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Can not get information about current restores : " + e.getMessage())).type("text/plain").cacheControl(noCache).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/info/default-ws-config")
    public Response getDefaultWorkspaceConfig() {
        try {
            String defaultWorkspaceName = this.repositoryService.getDefaultRepository().getConfiguration().getDefaultWorkspaceName();
            for (WorkspaceEntry wEntry : this.repositoryService.getDefaultRepository().getConfiguration().getWorkspaceEntries()) {
                if (!defaultWorkspaceName.equals(wEntry.getName())) continue;
                return Response.ok((Object)wEntry).cacheControl(noCache).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Can not get default workspace configuration.").type("text/plain").cacheControl(noCache).build();
        }
        catch (Throwable e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Can not get default workspace configuration.").type("text/plain").cacheControl(noCache).build();
        }
    }

    private void validateRepositoryName(String repositoryName) throws RepositoryException, RepositoryConfigurationException {
        this.repositoryService.getRepository(repositoryName);
    }

    private void validateWorkspaceName(String repositoryName, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException, RepositoryConfigurationException {
        Session ses = this.sessionProviderService.getSessionProvider(null).getSession(workspaceName, this.repositoryService.getRepository(repositoryName));
        ses.logout();
    }

    private boolean isWorkspaceExist(String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException {
        for (String workspace : this.repositoryService.getRepository(repositoryName).getWorkspaceNames()) {
            if (!workspaceName.equals(workspace)) continue;
            return true;
        }
        return false;
    }

    private void validateOneBackupInstants(String repositoryName, String workspaceName) throws WorkspaceRestoreExeption {
        BackupChain bch = this.backupManager.findBackup(repositoryName, workspaceName);
        if (bch != null) {
            throw new WorkspaceRestoreExeption("The backup is already working on workspace '/" + repositoryName + "/" + workspaceName + "'");
        }
    }

    private void validateOneRestoreInstants(String repositoryName, String workspaceName) throws WorkspaceRestoreExeption {
        for (JobWorkspaceRestore job : this.backupManager.getRestores()) {
            if (!repositoryName.equals(job.getRepositoryName()) || !workspaceName.endsWith(job.getWorkspaceName()) || job.getStateRestore() != 4 && job.getStateRestore() != 1) continue;
            throw new WorkspaceRestoreExeption("The workspace '/" + repositoryName + "/" + workspaceName + "' is already restoring.");
        }
    }

    private int forceCloseSession(String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository mr = this.repositoryService.getRepository(repositoryName);
        WorkspaceContainerFacade wc = mr.getWorkspaceContainer(workspaceName);
        SessionRegistry sessionRegistry = (SessionRegistry)wc.getComponent(SessionRegistry.class);
        return sessionRegistry.closeSessions(workspaceName);
    }

    private File getBackupLogbyId(String backupId) {
        FilenameFilter backupLogsFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml") && name.startsWith("backup-");
            }
        };
        File[] files = this.backupManager.getBackupDirectory().listFiles(backupLogsFilter);
        if (files.length != 0) {
            for (File f : files) {
                if (!f.getName().replaceAll(".xml", "").replaceAll("backup-", "").equals(backupId)) continue;
                return f;
            }
        }
        return null;
    }

    static {
        noCache.setNoCache(true);
        noCache.setNoStore(true);
    }

    public static final class Constants {
        public static final String DATE_FORMAT_RFC_1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
        public static final String BASE_URL = "/jcr-backup";

        private Constants() {
        }

        public static final class OperationType {
            public static final String START_BACKUP = "/start";
            public static final String RESTORE = "/restore";
            public static final String STOP_BACKUP = "/stop";
            public static final String CURRENT_AND_COMPLETED_BACKUPS_INFO = "/info/backup";
            public static final String CURRENT_AND_COMPLETED_BACKUPS_INFO_ON_WS = "/info/backup";
            public static final String CURRENT_BACKUPS_INFO = "/info/backup/current";
            public static final String CURRENT_OR_COMPLETED_BACKUP_INFO = "/info/backup";
            public static final String CURRENT_RESTORE_INFO_ON_WS = "/info/restore";
            public static final String CURRENT_RESTORES = "/info/restores";
            public static final String COMPLETED_BACKUPS_INFO = "/info/backup/completed";
            public static final String BACKUP_SERVICE_INFO = "/info";
            public static final String DROP_WORKSPACE = "/drop-workspace";
            public static final String GET_DEFAULT_WORKSPACE_CONFIG = "/info/default-ws-config";

            private OperationType() {
            }
        }
    }
}

