/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.JMException;
import javax.management.ObjectName;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerHA;
import org.jboss.invocation.http.interfaces.HttpInvokerProxyHA;
import org.jboss.invocation.http.server.HttpInvoker;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.system.Registry;

public class HttpInvokerHA
extends HttpInvoker
implements InvokerHA {
    protected HashMap targetMap = new HashMap();

    protected void startService() throws Exception {
        ObjectName name = super.getServiceName();
        Registry.bind((Object)name, (Object)this);
        super.checkInvokerURL();
        this.log.debug((Object)"Bound HttpHA invoker for JMX node");
    }

    protected void stopService() {
        ObjectName name = super.getServiceName();
        Registry.unbind((Object)name);
        this.log.debug((Object)"Unbound HttpHA invoker for JMX node");
    }

    protected void destroyService() {
        Registry.unbind((Object)this.serviceName);
    }

    public void registerBean(ObjectName targetName, HATarget target) throws Exception {
        Integer hash = new Integer(targetName.hashCode());
        this.log.debug((Object)("Registered targetName(" + targetName + "), hash=" + hash + ", target=" + target));
        if (this.targetMap.containsKey(hash)) {
            throw new IllegalStateException("Duplicate targetName(" + targetName + ") hashCode: " + hash);
        }
        this.targetMap.put(hash, target);
    }

    public void unregisterBean(ObjectName targetName) throws Exception {
        Integer hash = new Integer(targetName.hashCode());
        this.targetMap.remove(hash);
        this.log.debug((Object)("Unregistered targetName(" + targetName + "), hash=" + hash));
    }

    public Invoker createProxy(ObjectName targetName, LoadBalancePolicy policy, String proxyFamilyName) throws Exception {
        Integer hash = new Integer(targetName.hashCode());
        HATarget target = (HATarget)this.targetMap.get(hash);
        if (target == null) {
            throw new IllegalStateException("The targetName(" + targetName + "), hashCode(" + hash + ") not found");
        }
        HttpInvokerProxyHA proxy = new HttpInvokerProxyHA(target.getReplicants(), target.getCurrentViewId(), policy, proxyFamilyName);
        return proxy;
    }

    public Serializable getStub() {
        return super.getInvokerURL();
    }

    public Object invoke(Invocation invocation) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Integer nameHash = (Integer)invocation.getObjectName();
            ObjectName mbean = (ObjectName)Registry.lookup((Object)nameHash);
            Object[] args = new Object[]{invocation};
            String[] sig = new String[]{"org.jboss.invocation.Invocation"};
            Object rtn = super.getServer().invoke(mbean, "invoke", args, sig);
            Long clientViewId = (Long)invocation.getValue((Object)"CLUSTER_VIEW_ID");
            HARMIResponse rsp = new HARMIResponse();
            HATarget target = (HATarget)this.targetMap.get(nameHash);
            if (target == null) {
                throw new IllegalStateException("The name for hashCode(" + nameHash + ") was not found");
            }
            if (clientViewId.longValue() != target.getCurrentViewId()) {
                rsp.newReplicants = new ArrayList(target.getReplicants());
                rsp.currentViewId = target.getCurrentViewId();
            }
            rsp.response = rtn;
            HARMIResponse hARMIResponse = rsp;
            return hARMIResponse;
        }
        catch (Exception e2) {
            Throwable e2 = (Exception)JMXExceptionDecoder.decode((Throwable)e2);
            if (e2 instanceof JMException) {
                e2 = new GenericClusteringException(1, e2.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"operation failed", e2);
            }
            throw e2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

