/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.richfaces.model.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface TreeDataModelNodeAdaptor<T> {
    public static final TreeDataModelNodeAdaptor<TreeNode> classicTreeNodeAdaptor = new TreeDataModelNodeAdaptor<TreeNode>(){

        @Override
        public TreeNode getChild(TreeNode node, Object key) {
            return node.getChild(key);
        }

        @Override
        public Iterator<Map.Entry<Object, TreeNode>> getChildren(TreeNode node) {
            return node.getChildren();
        }

        @Override
        public TreeNode getParent(TreeNode node) {
            return node.getParent();
        }

        @Override
        public Object getRowData(TreeNode node) {
            return node.getData();
        }

        @Override
        public boolean isLeaf(TreeNode node) {
            return node.isLeaf();
        }

        @Override
        public Object getChildNodeId(TreeNode childNode) {
            TreeNode parentNode = this.getParent(childNode);
            if (childNode != null && parentNode != null) {
                Iterator iter = parentNode.getChildren();
                while (iter != null && iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (entry == null || !childNode.equals(entry.getValue())) continue;
                    return entry.getKey();
                }
            }
            return null;
        }
    };
    public static final TreeDataModelNodeAdaptor<javax.swing.tree.TreeNode> swingTreeNodeAdaptor = new TreeDataModelNodeAdaptor<javax.swing.tree.TreeNode>(){

        @Override
        public javax.swing.tree.TreeNode getChild(javax.swing.tree.TreeNode node, Object key) {
            int intKey = (Integer)key;
            if (intKey < node.getChildCount() && intKey >= 0) {
                return node.getChildAt(intKey);
            }
            return null;
        }

        @Override
        public Iterator<Map.Entry<Object, javax.swing.tree.TreeNode>> getChildren(final javax.swing.tree.TreeNode node) {
            if (node.getAllowsChildren()) {
                return new Iterator<Map.Entry<Object, javax.swing.tree.TreeNode>>(){
                    private final Enumeration<?> e;
                    private int counter;
                    {
                        this.e = node.children();
                        this.counter = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.e.hasMoreElements();
                    }

                    @Override
                    public Map.Entry<Object, javax.swing.tree.TreeNode> next() {
                        javax.swing.tree.TreeNode child = (javax.swing.tree.TreeNode)this.e.nextElement();
                        SwingNodeMapEntry entry = new SwingNodeMapEntry(this.counter++, child);
                        return entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return null;
        }

        @Override
        public javax.swing.tree.TreeNode getParent(javax.swing.tree.TreeNode node) {
            return node.getParent();
        }

        @Override
        public Object getRowData(javax.swing.tree.TreeNode node) {
            return node;
        }

        @Override
        public boolean isLeaf(javax.swing.tree.TreeNode node) {
            return !node.getAllowsChildren() || node.isLeaf();
        }

        @Override
        public Object getChildNodeId(javax.swing.tree.TreeNode childNode) {
            javax.swing.tree.TreeNode parentNode = this.getParent(childNode);
            if (childNode != null && parentNode != null) {
                Iterator<Map.Entry<Object, javax.swing.tree.TreeNode>> iter = this.getChildren(parentNode);
                while (iter != null && iter.hasNext()) {
                    Map.Entry<Object, javax.swing.tree.TreeNode> entry = iter.next();
                    if (entry == null || !childNode.equals(entry.getValue())) continue;
                    return entry.getKey();
                }
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SwingNodeMapEntry
        implements Map.Entry<Object, javax.swing.tree.TreeNode> {
            private Object key;
            private javax.swing.tree.TreeNode child;

            public SwingNodeMapEntry(int i, javax.swing.tree.TreeNode child) {
                this.key = i;
                this.child = child;
            }

            @Override
            public Object getKey() {
                return this.key;
            }

            @Override
            public javax.swing.tree.TreeNode getValue() {
                return this.child;
            }

            @Override
            public javax.swing.tree.TreeNode setValue(javax.swing.tree.TreeNode value) {
                javax.swing.tree.TreeNode node = this.child;
                this.child = value;
                return node;
            }
        }
    };

    public T getParent(T var1);

    public boolean isLeaf(T var1);

    public T getChild(T var1, Object var2);

    public Iterator<Map.Entry<Object, T>> getChildren(T var1);

    public Object getRowData(T var1);

    public Object getChildNodeId(T var1);
}

