/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.servlet;

import javax.servlet.ServletContext;

public class ServletContextSupport {
    private ServletContext servletContext = null;

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected String getContextInitParam(String paramName) {
        return this.getServletContext().getInitParameter(paramName);
    }

    private ServletContext getServletContextNullCheck() {
        ServletContext servletContext = this.getServletContext();
        if (servletContext == null) {
            String msg = "ServletContext property must be set via the setServletContext method.";
            throw new IllegalStateException(msg);
        }
        return servletContext;
    }

    protected void setAttribute(String key, Object value) {
        this.getServletContextNullCheck().setAttribute(key, value);
    }

    protected Object getAttribute(String key) {
        return this.getServletContextNullCheck().getAttribute(key);
    }

    protected void removeAttribute(String key) {
        this.getServletContextNullCheck().removeAttribute(key);
    }

    protected void bind(String name, String key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " argument cannot be null.");
        }
        if (this.getAttribute(key) != null) {
            String msg = name + " already bound to ServletContext.  Please check your configuration to ensure " + "you don't have mutliple SecurityManager Loaders configured (listener, servlet, etc).";
            throw new IllegalStateException(msg);
        }
        this.setAttribute(key, value);
    }
}

