/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.event.Observer;
import javax.inject.Current;
import javax.inject.DuplicateBindingTypeException;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventObserver<T> {
    private final Type eventType;
    private final List<Annotation> eventBindings;
    private final Observer<T> observer;
    private final ManagerImpl manager;

    public EventObserver(Observer<T> observer, Type eventType, ManagerImpl manager, Annotation ... eventBindings) {
        this.observer = observer;
        this.eventType = eventType;
        this.eventBindings = new ArrayList<Annotation>();
        this.manager = manager;
        this.checkEventBindings(eventBindings);
    }

    private void checkEventBindings(Annotation[] bindingAnnotations) {
        for (Annotation annotation : bindingAnnotations) {
            if (!Reflections.isBindings(annotation)) {
                throw new IllegalArgumentException(annotation + " is not a binding type for " + this);
            }
            if (this.eventBindings.contains(annotation)) {
                throw new DuplicateBindingTypeException(annotation + " is already present in the bindings list for " + this);
            }
            if (annotation.annotationType().equals(Current.class)) continue;
            this.eventBindings.add(annotation);
        }
    }

    public final Type getEventType() {
        return this.eventType;
    }

    public final List<Annotation> getEventBindings() {
        return this.eventBindings;
    }

    public final Observer<? extends T> getObserver() {
        return this.observer;
    }

    public boolean isObserverInterested(Annotation ... bindings) {
        if (this.eventBindings.isEmpty()) {
            return true;
        }
        for (Annotation x : this.eventBindings) {
            boolean found = false;
            for (Annotation y : bindings) {
                if (!((MetaDataCache)this.manager.getServices().get(MetaDataCache.class)).getBindingTypeModel(x.annotationType()).isEqual(x, y)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventBindings == null ? 0 : ((Object)this.eventBindings).hashCode());
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = 31 * result + (this.observer == null ? 0 : this.observer.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof EventObserver)) {
            return false;
        }
        EventObserver otherObserver = (EventObserver)other;
        if (!this.eventType.equals(otherObserver.getEventType())) {
            return false;
        }
        if (!((Object)this.eventBindings).equals(otherObserver.getEventBindings())) {
            return false;
        }
        return this.observer.equals(otherObserver.getObserver());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Event Observer:\n");
        buffer.append("  Event Type: " + this.eventType + "\n");
        buffer.append(Strings.collectionToString("  Event Bindings: ", this.eventBindings));
        buffer.append("  Observer: " + this.observer);
        return buffer.toString();
    }
}

