/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode<K, V> {
    protected ConcurrentMap children;
    protected Fqn fqn;
    protected short flags = 0;

    protected final boolean isFlagSet(NodeFlags flag) {
        return (this.flags & flag.mask) != 0;
    }

    protected final void setFlag(NodeFlags flag, boolean value) {
        if (value) {
            this.setFlag(flag);
        } else {
            this.unsetFlag(flag);
        }
    }

    protected final void setFlag(NodeFlags flag) {
        this.flags = (short)(this.flags | flag.mask);
    }

    protected final void unsetFlag(NodeFlags flag) {
        this.flags = (short)(this.flags & ~flag.mask);
    }

    public boolean isRemoved() {
        return this.isFlagSet(NodeFlags.REMOVED);
    }

    public void setResident(boolean resident) {
        this.setFlag(NodeFlags.RESIDENT, resident);
    }

    public void setRemoved(boolean marker) {
        this.markAsRemoved(marker, false);
    }

    public abstract void markAsRemoved(boolean var1, boolean var2);

    public boolean isResident() {
        return this.isFlagSet(NodeFlags.RESIDENT);
    }

    public IdentityLock getLock() {
        throw new UnsupportedOperationException("Not supported in this implementation!");
    }

    public void setVersion(DataVersion version) {
        throw new UnsupportedOperationException("Versioning not supported");
    }

    public DataVersion getVersion() {
        throw new UnsupportedOperationException("Versioning not supported");
    }

    public boolean equals(Object another) {
        if (another instanceof AbstractNode) {
            AbstractNode anotherNode = (AbstractNode)another;
            return this.fqn == null && anotherNode.fqn == null || this.fqn != null && anotherNode.fqn != null && this.fqn.equals(anotherNode.fqn);
        }
        return false;
    }

    public int hashCode() {
        return this.fqn.hashCode();
    }

    public InternalNode<K, V> getChild(Fqn f) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public InternalNode<K, V> getChild(Object childName) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public Set<InternalNode<K, V>> getChildren() {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public Set<InternalNode<K, V>> getChildren(boolean includeMarkedForRemoval) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public Map<Object, InternalNode<K, V>> getChildrenMap() {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public void addChild(Object nodeName, InternalNode<K, V> nodeToAdd) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public void addChild(InternalNode<K, V> child) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public void addChild(InternalNode<K, V> child, boolean safe) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public void setChildrenMap(ConcurrentMap<Object, InternalNode<K, V>> children) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public NodeSPI<K, V> getChildDirect(Fqn fqn) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public NodeSPI<K, V> getChildDirect(Object childName) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public Set<NodeSPI<K, V>> getChildrenDirect() {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public Set<NodeSPI<K, V>> getChildrenDirect(boolean includeMarkedForRemoval) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public Map<Object, Node<K, V>> getChildrenMapDirect() {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public void setChildrenMapDirect(Map<Object, Node<K, V>> children) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public void addChildDirect(Object nodeName, Node<K, V> nodeToAdd) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public void addChildDirect(NodeSPI<K, V> child) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public NodeSPI<K, V> addChildDirect(Fqn f) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public NodeSPI<K, V> addChildDirect(Fqn f, boolean notify) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public NodeSPI<K, V> addChildDirect(Object o, boolean notify) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    public NodeSPI<K, V> getOrCreateChild(Object childName, GlobalTransaction gtx) {
        throw new UnsupportedOperationException("Not supported in " + this.getClass().getSimpleName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeFlags {
        CHILDREN_LOADED(1),
        DATA_LOADED(2),
        LOCK_FOR_CHILD_INSERT_REMOVE(4),
        VALID(8),
        REMOVED(16),
        RESIDENT(32),
        MODIFIED_IN_WORKSPACE(64),
        CREATED_IN_WORKSPACE(128),
        CHILDREN_MODIFIED_IN_WORKSPACE(256),
        VERSIONING_IMPLICIT(512),
        RESURRECTED_IN_WORKSPACE(1024);

        protected final short mask;

        private NodeFlags(int mask) {
            this.mask = (short)mask;
        }
    }
}

