/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.management.ObjectName;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.AllowedOperationsFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerServiceFacade
implements TimerService {
    private ObjectName objectName;
    private TimerService delegate;

    protected TimerServiceFacade(ObjectName objectName, TimerService delegate) {
        this.objectName = objectName;
        this.delegate = delegate;
    }

    private void assertAllowedIn(String timerMethod) {
        AllowedOperationsAssociation.assertAllowedIn((String)timerMethod, (int)(AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD));
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createTimer");
        return this.delegate.createTimer(initialExpiration, intervalDuration, info);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createTimer");
        return this.delegate.createTimer(expiration, info);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createTimer");
        return this.delegate.createTimer(initialDuration, intervalDuration, info);
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.createTimer");
        return this.delegate.createTimer(duration, info);
    }

    protected ObjectName getContainerId() {
        return this.objectName;
    }

    public Collection<?> getTimers() throws IllegalStateException, EJBException {
        this.assertAllowedIn("TimerService.getTimers");
        return this.delegate.getTimers();
    }
}

