/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.JCRItemExistsException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;

public class SQLExceptionHandler {
    private final String containerName;
    private final JDBCStorageConnection conn;

    SQLExceptionHandler(String containerName, JDBCStorageConnection conn) {
        this.containerName = containerName;
        this.conn = conn;
    }

    protected String handleAddException(SQLException e, ItemData item) throws RepositoryException, InvalidItemStateException {
        String itemInfo;
        String message;
        block17: {
            message = "[" + this.containerName + "] ADD " + (item.isNode() ? "NODE. " : "PROPERTY. ");
            String errMessage = e.getMessage();
            itemInfo = item.getQPath().getAsString() + ", ID: " + item.getIdentifier() + ", ParentID: " + item.getParentIdentifier() + (errMessage != null ? ". Cause >>>> " + errMessage : "");
            if (errMessage != null) {
                String umsg = errMessage.toLowerCase().toUpperCase();
                if (umsg.indexOf(this.conn.JCR_FK_ITEM_PARENT) >= 0) {
                    message = message + "Parent not found. Item " + itemInfo;
                    throw new JCRInvalidItemStateException(message, item.getIdentifier(), 1, e);
                }
                if (umsg.indexOf(this.conn.JCR_PK_ITEM) >= 0) {
                    message = message + "Item already exists. Condition: ID. " + itemInfo;
                    throw new JCRInvalidItemStateException(message, item.getIdentifier(), 1, e);
                }
                if (umsg.indexOf(this.conn.JCR_IDX_ITEM_PARENT) >= 0 || umsg.indexOf(this.conn.JCR_IDX_ITEM_PARENT_NAME) >= 0) {
                    message = message + "Item already exists. Condition: parent ID, name, index. " + itemInfo;
                    throw new ItemExistsException(message, (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_IDX_ITEM_PARENT_ID) >= 0) {
                    message = message + "Item already exists. Condition: parent ID and ID. " + itemInfo;
                    throw new ItemExistsException(message, (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_FK_VALUE_PROPERTY) >= 0) {
                    message = message + "Property is not exist but the value is being created. Condition: property ID. " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_IDX_VALUE_PROPERTY) >= 0) {
                    message = message + "Property already exists. Condition: property ID, order number. " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_PK_VALUE) >= 0) {
                    message = message + "[FATAL] Value already exists with the ValueID. Impossible state, check is ValueID is autoincremented. " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_PK_REF) >= 0) {
                    message = message + "Reference chain already exists. Condition: node ID, property ID, order number. " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_IDX_REF_PROPERTY) >= 0) {
                    message = message + "Referenceable property value already exists. Condition: property ID, order number. " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
            }
            Object ownException = null;
            try {
                block18: {
                    NodeData parent = (NodeData)this.conn.getItemData(item.getParentIdentifier());
                    if (parent == null) break block17;
                    try {
                        ItemData me = this.conn.getItemData(item.getIdentifier());
                        if (me != null) {
                            message = message + "Item already exists in storage: " + itemInfo;
                            ownException = new JCRItemExistsException(message, me.getIdentifier(), 1, e);
                            throw ownException;
                        }
                        me = this.conn.getItemData(parent, new QPathEntry(item.getQPath().getName(), item.getQPath().getIndex()));
                        if (me != null) {
                            message = message + "Item already exists in storage: " + itemInfo;
                            ownException = new JCRItemExistsException(message, me.getIdentifier(), 1, e);
                            throw ownException;
                        }
                    }
                    catch (Exception ep) {
                        if (ownException == null) break block18;
                        throw ownException;
                    }
                }
                if (e.getClass().getName().indexOf("MySQLIntegrityConstraintViolationException") >= 0 && errMessage.indexOf(item.getIdentifier()) >= 0) {
                    message = message + "Item already exists. Condition: ID. " + itemInfo;
                    throw new JCRInvalidItemStateException(message, item.getIdentifier(), 1, e);
                }
                message = message + "Error of item add. " + itemInfo;
                ownException = new RepositoryException(message, (Throwable)e);
                throw ownException;
            }
            catch (Exception ep) {
                if (ownException == null) break block17;
                throw ownException;
            }
        }
        message = message + "Error of item add. " + itemInfo;
        throw new JCRInvalidItemStateException(message, item.getIdentifier(), 1, e);
    }

    protected String handleAddException(IOException e, ItemData item) throws RepositoryException, InvalidItemStateException {
        String itemInfo;
        String message;
        block6: {
            message = "[" + this.containerName + "] ADD " + (item.isNode() ? "NODE. " : "PROPERTY. ");
            String errMessage = e.getMessage();
            itemInfo = item.getQPath().getAsString() + ", ID: " + item.getIdentifier() + ", ParentID: " + item.getParentIdentifier() + (errMessage != null ? ". Cause >>>> " + errMessage : "");
            Throwable ownException = null;
            try {
                block7: {
                    NodeData parent = (NodeData)this.conn.getItemData(item.getParentIdentifier());
                    if (parent == null) break block6;
                    try {
                        ItemData me = this.conn.getItemData(item.getIdentifier());
                        if (me != null) {
                            message = message + "Item already exists in storage: " + itemInfo;
                            ownException = new ItemExistsException(message, (Throwable)e);
                            throw ownException;
                        }
                        me = this.conn.getItemData(parent, new QPathEntry(item.getQPath().getName(), item.getQPath().getIndex()));
                        if (me != null) {
                            message = message + "Item already exists in storage: " + itemInfo;
                            ownException = new ItemExistsException(message, (Throwable)e);
                            throw ownException;
                        }
                    }
                    catch (Exception ep) {
                        if (ownException == null) break block7;
                        throw ownException;
                    }
                }
                message = message + "Error of item add. " + itemInfo;
                ownException = new RepositoryException(message, (Throwable)e);
                throw ownException;
            }
            catch (Exception ep) {
                if (ownException == null) break block6;
                throw ownException;
            }
        }
        message = message + "Error of item add. " + itemInfo;
        throw new JCRInvalidItemStateException(message, item.getIdentifier(), 1, e);
    }

    protected String handleDeleteException(SQLException e, ItemData item) throws RepositoryException, InvalidItemStateException {
        String message = "[" + this.containerName + "] DELETE " + (item.isNode() ? "NODE. " : "PROPERTY. ");
        String errMessage = e.getMessage();
        String itemInfo = item.getQPath().getAsString() + " " + item.getIdentifier() + (errMessage != null ? ". Cause >>>> " + errMessage : "");
        if (errMessage != null) {
            String umsg = errMessage.toLowerCase().toUpperCase();
            if (umsg.indexOf(this.conn.JCR_FK_ITEM_PARENT) >= 0) {
                message = message + "Can not delete parent till childs exists. Item " + itemInfo;
                throw new JCRInvalidItemStateException(message, item.getIdentifier(), 4, e);
            }
            if (umsg.indexOf(this.conn.JCR_FK_VALUE_PROPERTY) >= 0) {
                message = message + "[FATAL] Can not delete property item till it contains values. Condition: property ID. " + itemInfo;
                throw new RepositoryException(message, (Throwable)e);
            }
        }
        message = message + "Error of item delete " + itemInfo;
        throw new RepositoryException(message, (Throwable)e);
    }

    protected String handleUpdateException(SQLException e, ItemData item) throws RepositoryException, InvalidItemStateException {
        String itemInfo;
        String message;
        block6: {
            message = "[" + this.containerName + "] EDIT " + (item.isNode() ? "NODE. " : "PROPERTY. ");
            String errMessage = e.getMessage();
            itemInfo = item.getQPath().getAsString() + " " + item.getIdentifier() + (errMessage != null ? ". Cause >>>> " + errMessage : "");
            if (errMessage != null) {
                if (errMessage.toLowerCase().toUpperCase().indexOf(this.conn.JCR_FK_VALUE_PROPERTY) >= 0) {
                    message = message + "Property is not exists but the value is being created. Condition: property ID. " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
                if (errMessage.toLowerCase().toUpperCase().indexOf(this.conn.JCR_PK_ITEM) >= 0) {
                    message = message + "Item already exists. Condition: ID. " + itemInfo;
                    throw new JCRInvalidItemStateException(message, item.getIdentifier(), 2, e);
                }
            }
            RepositoryException ownException = null;
            try {
                ItemData me = this.conn.getItemData(item.getIdentifier());
                if (me != null) {
                    message = message + "Item already exists. But update errors. " + itemInfo;
                    ownException = new RepositoryException(message, (Throwable)e);
                    throw ownException;
                }
            }
            catch (Exception ep) {
                if (ownException == null) break block6;
                throw ownException;
            }
        }
        message = message + "Error of item update. " + itemInfo;
        throw new JCRInvalidItemStateException(message, item.getIdentifier(), 2, e);
    }
}

