/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DBInitializer {
    public static String SQL_DELIMITER = ";";
    public static String SQL_DELIMITER_COMMENT_PREFIX = "/*$DELIMITER:";
    public static String SQL_CREATETABLE = "^(CREATE(\\s)+TABLE(\\s)+(IF(\\s)+NOT(\\s)+EXISTS(\\s)+)*){1}";
    public static String SQL_CREATEVIEW = "^(CREATE(\\s)+VIEW(\\s)+(IF(\\s)+NOT(\\s)+EXISTS(\\s)+)*){1}";
    public static String SQL_OBJECTNAME = "((JCR_[A-Z_]+){1}(\\s*?|(\\(\\))*?)+)+?";
    public static String SQL_CREATEINDEX = "^(CREATE(\\s)+(UNIQUE(\\s)+)*INDEX(\\s)+){1}";
    public static String SQL_ONTABLENAME = "(ON(\\s)+(JCR_[A-Z_]+){1}(\\s*?|(\\(\\))*?)+){1}";
    public static String SQL_CREATESEQUENCE = "^(CREATE(\\s)+SEQUENCE(\\s)+){1}";
    public static String SQL_CREATETRIGGER = "^(CREATE(\\s)+(OR(\\s){1}REPLACE(\\s)+)*TRIGGER(\\s)+){1}";
    public static String SQL_TRIGGERNAME = "(([A-Z_]+JCR_[A-Z_]+){1}(\\s*?|(\\(\\))*?)+)+?";
    protected final Log LOG = ExoLogger.getLogger((String)"jcr.DBInitializer");
    protected final Connection connection;
    protected final String containerName;
    protected final String script;
    protected final Pattern creatTablePattern;
    protected final Pattern creatViewPattern;
    protected final Pattern dbObjectNamePattern;
    protected final Pattern creatIndexPattern;
    protected final Pattern onTableNamePattern;
    protected final Pattern creatSequencePattern;
    protected final Pattern creatTriggerPattern;
    protected final Pattern dbTriggerNamePattern;

    public DBInitializer(String containerName, Connection connection, String scriptPath) throws IOException {
        this.connection = connection;
        this.containerName = containerName;
        this.script = this.script(scriptPath);
        this.creatTablePattern = Pattern.compile(SQL_CREATETABLE, 2);
        this.creatViewPattern = Pattern.compile(SQL_CREATEVIEW, 2);
        this.dbObjectNamePattern = Pattern.compile(SQL_OBJECTNAME, 2);
        this.creatIndexPattern = Pattern.compile(SQL_CREATEINDEX, 2);
        this.onTableNamePattern = Pattern.compile(SQL_ONTABLENAME, 2);
        this.creatSequencePattern = Pattern.compile(SQL_CREATESEQUENCE, 2);
        this.creatTriggerPattern = Pattern.compile(SQL_CREATETRIGGER, 2);
        this.dbTriggerNamePattern = Pattern.compile(SQL_TRIGGERNAME, 2);
    }

    protected String script(String scriptPath) throws IOException {
        return this.readScriptResource(scriptPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readScriptResource(String path) throws IOException {
        String string;
        InputStream is = this.getClass().getResourceAsStream(path);
        InputStreamReader isr = new InputStreamReader(is);
        try {
            StringBuilder sbuff = new StringBuilder();
            char[] buff = new char[is.available()];
            int r = 0;
            while ((r = isr.read(buff)) > 0) {
                sbuff.append(buff, 0, r);
            }
            string = sbuff.toString();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                is.close();
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return string;
    }

    public String cleanWhitespaces(String string) {
        if (string != null) {
            char[] cc = string.toCharArray();
            for (int ci = cc.length - 1; ci > 0; --ci) {
                if (!Character.isWhitespace(cc[ci])) continue;
                cc[ci] = 32;
            }
            return new String(cc);
        }
        return string;
    }

    protected boolean isTableExists(Connection conn, String tableName) throws SQLException {
        ResultSet trs = conn.getMetaData().getTables(null, null, tableName, null);
        boolean res = false;
        while (trs.next()) {
            res = true;
        }
        return res;
    }

    protected boolean isIndexExists(Connection conn, String tableName, String indexName) throws SQLException {
        ResultSet irs = conn.getMetaData().getIndexInfo(null, null, tableName, false, true);
        boolean res = false;
        while (irs.next()) {
            if (irs.getShort("TYPE") == 0 || !irs.getString("INDEX_NAME").equalsIgnoreCase(indexName)) continue;
            res = true;
        }
        return res;
    }

    protected boolean isSequenceExists(Connection conn, String sequenceName) throws SQLException {
        return false;
    }

    protected boolean isTriggerExists(Connection conn, String triggerName) throws SQLException {
        return false;
    }

    public boolean isObjectExists(Connection conn, String sql) throws SQLException {
        Matcher tMatcher = this.creatTablePattern.matcher(sql);
        if (tMatcher.find()) {
            String tableName;
            tMatcher = this.dbObjectNamePattern.matcher(sql);
            if (tMatcher.find() && this.isTableExists(conn, tableName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Table is already exists " + tableName));
                }
                return true;
            }
        } else {
            tMatcher = this.creatViewPattern.matcher(sql);
            if (tMatcher.find()) {
                String tableName;
                tMatcher = this.dbObjectNamePattern.matcher(sql);
                if (tMatcher.find() && this.isTableExists(conn, tableName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)("View is already exists " + tableName));
                    }
                    return true;
                }
            } else {
                tMatcher = this.creatIndexPattern.matcher(sql);
                if (tMatcher.find()) {
                    tMatcher = this.dbObjectNamePattern.matcher(sql);
                    if (tMatcher.find()) {
                        String indexName = sql.substring(tMatcher.start(), tMatcher.end());
                        tMatcher = this.onTableNamePattern.matcher(sql);
                        if (tMatcher.find()) {
                            String onTableName = sql.substring(tMatcher.start(), tMatcher.end());
                            if ((tMatcher = this.dbObjectNamePattern.matcher(onTableName)).find()) {
                                String tableName = onTableName.substring(tMatcher.start(), tMatcher.end());
                                if (this.isIndexExists(conn, tableName, indexName)) {
                                    if (this.LOG.isDebugEnabled()) {
                                        this.LOG.debug((Object)("Index is already exists " + indexName));
                                    }
                                    return true;
                                }
                            } else {
                                this.LOG.warn((Object)("Index found but $TABLE_NAME is not detected '" + sql + "'"));
                            }
                        } else {
                            this.LOG.warn((Object)("Index found but ON $TABLE_NAME clause is not detected '" + sql + "'"));
                        }
                    } else {
                        this.LOG.warn((Object)("Create index clause found but $INDEX_NAME is not detected '" + sql + "'"));
                    }
                } else {
                    tMatcher = this.creatSequencePattern.matcher(sql);
                    if (tMatcher.find()) {
                        String sequenceName;
                        tMatcher = this.dbObjectNamePattern.matcher(sql);
                        if (tMatcher.find() && this.isSequenceExists(conn, sequenceName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                            if (this.LOG.isDebugEnabled()) {
                                this.LOG.debug((Object)("Sequence is already exists " + sequenceName));
                            }
                            return true;
                        }
                    } else {
                        tMatcher = this.creatTriggerPattern.matcher(sql);
                        if (tMatcher.find()) {
                            String triggerName;
                            tMatcher = this.dbTriggerNamePattern.matcher(sql);
                            if (tMatcher.find() && this.isTriggerExists(conn, triggerName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                                if (this.LOG.isDebugEnabled()) {
                                    this.LOG.debug((Object)("Trigger is already exists " + triggerName));
                                }
                                return true;
                            }
                        } else if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug((Object)("Command is not detected for check '" + sql + "'"));
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public void init() throws DBInitializerException {
        block16: {
            String[] scripts = null;
            if (this.script.startsWith(SQL_DELIMITER_COMMENT_PREFIX)) {
                try {
                    String s = this.script.substring(SQL_DELIMITER_COMMENT_PREFIX.length());
                    int endOfDelimIndex = s.indexOf("*/");
                    String delim = s.substring(0, endOfDelimIndex).trim();
                    s = s.substring(endOfDelimIndex + 2).trim();
                    scripts = s.split(delim);
                }
                catch (IndexOutOfBoundsException e) {
                    this.LOG.warn((Object)("Error of parse SQL-script file. Invalid DELIMITER configuration. Valid format is '" + SQL_DELIMITER_COMMENT_PREFIX + "XXX*/' at begin of the SQL-script file, where XXX - DELIMITER string." + " Spaces will be trimed. "), (Throwable)e);
                    this.LOG.info((Object)("Using DELIMITER:[" + SQL_DELIMITER + "]"));
                    scripts = this.script.split(SQL_DELIMITER);
                }
            } else {
                scripts = this.script.split(SQL_DELIMITER);
            }
            String sql = null;
            this.connection.setAutoCommit(false);
            for (String scr : scripts) {
                String s = this.cleanWhitespaces(scr.trim());
                if (s.length() <= 0 || this.isObjectExists(this.connection, sql = s)) continue;
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Execute script: \n[" + sql + "]"));
                }
                this.connection.createStatement().executeUpdate(sql);
            }
            this.postInit(this.connection);
            this.connection.commit();
            this.LOG.info((Object)("DB schema of DataSource: '" + this.containerName + "' initialized succesfully"));
            Object var9_16 = null;
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                this.LOG.error((Object)("Error of a connection closing. " + e), (Throwable)e);
            }
            break block16;
            {
                catch (SQLException e) {
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException re) {
                        this.LOG.error((Object)("Rollback error " + e), (Throwable)e);
                    }
                    SQLException next = e.getNextException();
                    String errorTrace = "";
                    while (next != null) {
                        errorTrace = errorTrace + next.getMessage() + "; ";
                        next = e.getNextException();
                    }
                    Throwable cause = e.getCause();
                    String msg = "Could not create db schema of DataSource: '" + this.containerName + "'. Reason: " + e.getMessage() + "; " + errorTrace + (cause != null ? " (Cause: " + cause.getMessage() + ")" : "") + ". Last command: " + sql;
                    throw new DBInitializerException(msg, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_17 = null;
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    this.LOG.error((Object)("Error of a connection closing. " + e), (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    protected void postInit(Connection connection) throws SQLException {
    }
}

