/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.connectionmanager;

import java.util.Set;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.aop.AbstractInterceptor;
import org.jboss.jca.spi.ComponentStack;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedConnectionInterceptor
extends AbstractInterceptor {
    private static final Logger log = Logger.getLogger(CachedConnectionInterceptor.class);
    private final Set<String> unsharableResources;

    public CachedConnectionInterceptor(Set<String> unsharableResources) {
        this.unsharableResources = unsharableResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        EJBContainerInvocation containerInvocation = (EJBContainerInvocation)invocation;
        Object container = CachedConnectionInterceptor.getEJBContainer(invocation);
        ComponentStack ccm = ((EJBContainer)container).getCachedConnectionManager();
        if (ccm == null) {
            log.warn((Object)"EJBTHREE-1028: No ejb3 CachedConnectionManager installed");
            return containerInvocation.invokeNext();
        }
        Object key = containerInvocation.getBeanContext().getInstance();
        ccm.pushMetaAwareObject(key, this.unsharableResources);
        try {
            Object object = containerInvocation.invokeNext();
            return object;
        }
        finally {
            ccm.popMetaAwareObject(this.unsharableResources);
        }
    }
}

