/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.mc;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.exoplatform.container.mc.MCIntegration;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.ComponentAdapter;

public class MCIntegrationInvoker {
    private static Log log = ExoLogger.getLogger(MCIntegrationInvoker.class);
    private static MCIntegration mcInt;
    private static boolean permFailure;

    public static synchronized ComponentAdapter getMCAdapter(ComponentAdapter componentAdapter) {
        MCIntegration mcInt = MCIntegrationInvoker.getMCIntegration();
        if (mcInt == null) {
            return componentAdapter;
        }
        return mcInt.getMCAdapter(componentAdapter);
    }

    public static synchronized boolean hasMCKernel(ComponentAdapter adapter) {
        MCIntegration mcInt = MCIntegrationInvoker.getMCIntegration();
        if (mcInt == null) {
            return false;
        }
        return mcInt.hasMCKernel(adapter);
    }

    public static synchronized void initThreadCtx(ServletContext ctx) {
        MCIntegration mcInt = MCIntegrationInvoker.getMCIntegration();
        if (mcInt == null) {
            return;
        }
        mcInt.initThreadCtx(ctx);
    }

    public static synchronized void resetThreadCtx(ServletContext ctx) {
        MCIntegration mcInt = MCIntegrationInvoker.getMCIntegration();
        if (mcInt == null) {
            return;
        }
        mcInt.resetThreadCtx(ctx);
    }

    private static MCIntegration getMCIntegration() {
        if (mcInt == null && !permFailure) {
            Class clazz = null;
            try {
                clazz = MCIntegrationInvoker.loadClass("org.exoplatform.container.mc.impl.MCIntegrationImpl");
                Method m = clazz.getMethod("getInstance", new Class[0]);
                mcInt = (MCIntegration)m.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException ignored) {
                permFailure = true;
                log.debug((Object)("MC integration not available in this environment (missing class: " + ignored.getMessage() + ")"));
                return null;
            }
            catch (Exception e) {
                permFailure = true;
                throw new RuntimeException("MC Integration initialization error", e);
            }
        }
        return mcInt;
    }

    static Class loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                clazz = cl.loadClass(name);
            }
        }
        catch (ClassNotFoundException ignored) {
            clazz = Class.forName(name);
        }
        return clazz;
    }
}

