/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins.helpers;

import bsh.Interpreter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.servlet.ServletConfig;
import org.jboss.console.manager.PluginManager;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.ResourceTreeNode;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;
import org.jboss.console.plugins.helpers.AbstractPluginWrapper;
import org.jboss.console.plugins.helpers.PluginContext;
import org.jboss.console.plugins.helpers.ScriptPlugin;
import org.jboss.logging.Logger;

public class BasePluginWrapper
extends AbstractPluginWrapper {
    protected Interpreter interpreter = null;
    protected String pluginName = null;
    protected String pluginVersion = null;
    protected String scriptName = null;
    protected String scriptContent = null;
    protected ScriptPlugin script = null;
    protected PluginContext pluginCtx = null;

    public void init(ServletConfig servletConfig) throws Exception {
        super.init(servletConfig);
        this.loadScript(this.scriptName);
        this.pluginCtx = new SimplePluginContext();
    }

    public void readConfigurationParameters(ServletConfig config) {
        super.readConfigurationParameters(config);
        this.scriptName = config.getInitParameter("ScriptName");
    }

    protected String getPluginIdentifier() {
        try {
            return this.script.getName(this.pluginCtx);
        }
        catch (UndeclaredThrowableException ute) {
            return "ServletPluginHelper Wrapping script '" + this.scriptName + "'";
        }
    }

    protected String getPluginVersion() {
        try {
            System.out.println("Version : " + this.script.getVersion(this.pluginCtx));
            return this.script.getVersion(this.pluginCtx);
        }
        catch (UndeclaredThrowableException ute) {
            return "unknown version";
        }
    }

    protected TreeNode getTreeForResource(String profile, ManageableResource resource) {
        try {
            TreeNode result = this.script.getTreeForResource(resource, this.pluginCtx);
            return result;
        }
        catch (UndeclaredThrowableException ute) {
            ute.printStackTrace();
            return null;
        }
    }

    protected boolean isResourceToBeManaged(ManageableResource resource) {
        if (this.checker != null) {
            return super.isResourceToBeManaged(resource);
        }
        try {
            return this.isResourceToBeManaged_Script(this.pm, resource);
        }
        catch (UndeclaredThrowableException ute) {
            ute.printStackTrace();
            return false;
        }
    }

    protected boolean isResourceToBeManaged_Script(PluginManager master, ManageableResource resource) throws UndeclaredThrowableException {
        return this.script.isResourceToBeManaged(resource, this.pluginCtx);
    }

    protected void loadScript(String scriptName) throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(scriptName);
        if (url == null) {
            throw new IllegalArgumentException("Resource not found: " + scriptName);
        }
        this.interpreter = new Interpreter();
        this.interpreter.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.interpreter.eval((Reader)new InputStreamReader(url.openStream()));
        this.script = (ScriptPlugin)this.interpreter.getInterface(ScriptPlugin.class);
    }

    public class SimplePluginContext
    implements PluginContext {
        public String localizeUrl(String source) {
            return BasePluginWrapper.this.fixUrl(source);
        }

        public MBeanServer getLocalMBeanServer() {
            return BasePluginWrapper.this.mbeanServer;
        }

        public ObjectInstance[] getMBeansForClass(String scope, String className) {
            return BasePluginWrapper.this.getMBeansForClass(scope, className);
        }

        public Logger getLogger() {
            return BasePluginWrapper.this.log;
        }

        public TreeNode createTreeNode(String name, String description, String iconUrl, String defaultUrl, TreeNodeMenuEntry[] menuEntries, TreeNode[] subNodes, ResourceTreeNode[] subResNodes) throws Exception {
            return BasePluginWrapper.this.createTreeNode(name, description, iconUrl, defaultUrl, menuEntries, subNodes, subResNodes);
        }

        public ResourceTreeNode createResourceNode(String name, String description, String iconUrl, String defaultUrl, TreeNodeMenuEntry[] menuEntries, TreeNode[] subNodes, ResourceTreeNode[] subResNodes, String jmxObjectName, String jmxClassName) throws Exception {
            return BasePluginWrapper.this.createResourceNode(name, description, iconUrl, defaultUrl, menuEntries, subNodes, subResNodes, jmxObjectName, jmxClassName);
        }

        public ResourceTreeNode createResourceNode(String name, String description, String iconUrl, String defaultUrl, TreeNodeMenuEntry[] menuEntries, TreeNode[] subNodes, ResourceTreeNode[] subResNodes, ManageableResource resource) throws Exception {
            return BasePluginWrapper.this.createResourceNode(name, description, iconUrl, defaultUrl, menuEntries, subNodes, subResNodes, resource);
        }

        public TreeNodeMenuEntry[] createMenus(String[] content) throws Exception {
            return BasePluginWrapper.this.createMenus(content);
        }

        public String encode(String source) {
            return BasePluginWrapper.this.encode(source);
        }
    }
}

