/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.model.ScrollableTableDataRange;
import org.richfaces.model.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScrollableTableDataModel<T>
extends ExtendedDataModel {
    private static final Log log = LogFactory.getLog(ScrollableTableDataModel.class);
    private Object rowKey;
    private Map<Object, T> mapping;
    protected SortOrder lastSortOrder;

    public abstract List<T> loadData(int var1, int var2, SortOrder var3);

    @Override
    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Starting walk");
        }
        ScrollableTableDataRange sequenceRange = (ScrollableTableDataRange)range;
        int startIndex = sequenceRange.getFirst();
        int last = sequenceRange.getLast();
        this.lastSortOrder = sequenceRange.getSortOrder();
        List<T> objects = this.loadData(startIndex, last, this.lastSortOrder);
        this.mapping = new HashMap<Object, T>();
        int i = 0;
        while (i < objects.size()) {
            T data = objects.get(i);
            Object key = this.getId(data);
            if (key == null) {
                key = new SimpleRowKey(startIndex);
            }
            this.mapping.put(key, data);
            visitor.process(context, key, argument);
            ++i;
            ++startIndex;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Ending walk");
        }
    }

    public T getObjectById(Object id) {
        if (id instanceof SimpleRowKey) {
            int i = ((SimpleRowKey)id).intValue();
            List<T> l = this.loadData(i, i + 1, this.lastSortOrder);
            return l.get(0);
        }
        return null;
    }

    public Object getId(T o) {
        return null;
    }

    public Object getRowData() {
        if (this.mapping != null && this.mapping.containsKey(this.rowKey)) {
            return this.mapping.get(this.rowKey);
        }
        return this.loadAndMap(this.rowKey);
    }

    public int getRowIndex() {
        return -1;
    }

    public boolean isRowAvailable() {
        return this.getRowData() != null;
    }

    public void setRowIndex(int index) {
    }

    @Override
    public Object getRowKey() {
        return this.rowKey;
    }

    @Override
    public void setRowKey(Object key) {
        this.rowKey = key;
    }

    private Object loadAndMap(Object id) {
        T t;
        if (log.isTraceEnabled()) {
            log.trace((Object)("loadAndMap " + id));
        }
        if ((t = this.getObjectById(id)) != null) {
            if (this.mapping == null) {
                this.mapping = new HashMap<Object, T>();
            }
            this.mapping.put(id, t);
        }
        return t;
    }

    public static class SimpleRowKey
    extends Number
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String PREFIX = "srk";
        private int i;

        public SimpleRowKey(int i) {
            this.i = i;
        }

        public int intValue() {
            return this.i;
        }

        public String toString() {
            return PREFIX + String.valueOf(this.i);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.i;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleRowKey other = (SimpleRowKey)obj;
            return this.i == other.i;
        }

        public double doubleValue() {
            return this.i;
        }

        public float floatValue() {
            return this.i;
        }

        public long longValue() {
            return this.i;
        }
    }
}

