/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd.transport;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.cometd.transport.DelegateMessage;

@Path(value="/continuation/")
public class RESTContinuationService
implements ResourceContainer {
    private final Log log = ExoLogger.getLogger((String)"ws.RestServiceForCometdTransport");
    private final ContinuationService continuation;

    public RESTContinuationService(ContinuationService continuationService) {
        this.continuation = continuationService;
    }

    @GET
    @Path(value="/gettoken/{exoID}/")
    @Produces(value={"text/plain"})
    public Response getToken(@PathParam(value="exoID") String exoID) {
        String token = this.continuation.getUserToken(exoID);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Client with exoId " + exoID + " get token " + token));
        }
        return Response.ok((Object)token, (String)"text/plain").header("Content-Length", (Object)Integer.toString(token.length())).build();
    }

    @GET
    @Path(value="/issubscribed/{exoID}/")
    @Produces(value={"text/plain"})
    public Response isSubscribed(@PathParam(value="exoID") String exoID, @QueryParam(value="channel") String channel) {
        Boolean b = this.continuation.isSubscribe(exoID, channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Is subcribed client " + exoID + " on channel " + channel + " " + b));
        }
        return Response.ok((Object)b.toString(), (String)"text/plain").build();
    }

    @GET
    @Path(value="/haschannel/")
    @Produces(value={"text/plain"})
    public Response hasChannel(@QueryParam(value="channel") String channel) {
        Boolean b = this.continuation.hasChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Has channel " + channel + " " + b));
        }
        return Response.ok((Object)b.toString(), (String)"text/plain").header("Content-Length", (Object)Integer.toString(b.toString().length())).build();
    }

    @POST
    @Path(value="/sendprivatemessage/")
    @Consumes(value={"application/json"})
    public Response sendMessage(DelegateMessage data) {
        this.continuation.sendMessage(data.getExoId(), data.getChannel(), data.getMessage(), data.getId());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Send private message " + data.getMessage() + " on channel " + data.getChannel() + " to client " + data.getExoId()));
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/sendbroadcastmessage/")
    @Consumes(value={"application/json"})
    public Response sendBroadcastMessage(DelegateMessage data) {
        this.continuation.sendBroadcastMessage(data.getChannel(), data.getMessage(), data.getId());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Send broadcast message " + data.getMessage() + " on channel " + data.getChannel()));
        }
        return Response.ok().build();
    }
}

