/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.RspList;

public class Deadlock2Test
extends ChannelTestBase {
    private static boolean DEADLOCK_DETECTION = true;
    private String name = "Deadlock2Test";

    public Deadlock2Test(String name) {
        super(name);
    }

    public void testOneChannel() throws Exception {
        JChannel channel = this.createChannel();
        ServerObject serverObject = new ServerObject("obj1");
        RpcDispatcher disp = new RpcDispatcher((Channel)channel, null, null, serverObject, DEADLOCK_DETECTION);
        serverObject.setRpcDispatcher(disp);
        ((Channel)channel).connect(this.name);
        Address localAddress = ((Channel)channel).getLocalAddress();
        MethodCall call = new MethodCall("outerMethod", new Object[0], new Class[0]);
        Deadlock2Test.log("calling outerMethod() on all members");
        RspList rspList = disp.callRemoteMethods(null, call, 2, 0L);
        Deadlock2Test.log("results of outerMethod(): " + rspList);
        Deadlock2Test.assertEquals((int)1, (int)rspList.size());
        Deadlock2Test.assertEquals((Object)"outerMethod[innerMethod]", (Object)rspList.getValue(localAddress));
        Deadlock2Test.assertTrue((boolean)rspList.isReceived(localAddress));
        Deadlock2Test.assertFalse((boolean)rspList.isSuspected(localAddress));
        ((Channel)channel).disconnect();
        ((Channel)channel).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoChannels() throws Throwable {
        ServerObject obj2 = null;
        JChannel c1 = this.createChannel("A");
        ServerObject obj1 = new ServerObject("obj1");
        RpcDispatcher disp1 = new RpcDispatcher((Channel)c1, null, null, obj1, DEADLOCK_DETECTION);
        obj1.setRpcDispatcher(disp1);
        ((Channel)c1).connect(this.name);
        JChannel c2 = this.createChannel("A");
        obj2 = new ServerObject("obj2");
        RpcDispatcher disp2 = new RpcDispatcher((Channel)c2, null, null, obj2, DEADLOCK_DETECTION);
        obj2.setRpcDispatcher(disp2);
        ((Channel)c2).connect(this.name);
        Address localAddress2 = ((Channel)c2).getLocalAddress();
        try {
            MethodCall call = new MethodCall("outerMethod", new Object[0], new Class[0]);
            Deadlock2Test.log("calling outerMethod() on " + localAddress2);
            Object retval = disp1.callRemoteMethod(localAddress2, call, 2, 0L);
            Deadlock2Test.log("results of outerMethod(): " + retval);
            Object var11_10 = null;
            ((Channel)c2).close();
            ((Channel)c1).close();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            ((Channel)c2).close();
            ((Channel)c1).close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoChannelsWithInitialMulticast() throws Exception {
        ServerObject obj2 = null;
        JChannel c1 = this.createChannel("A");
        ServerObject obj1 = new ServerObject("obj1");
        RpcDispatcher disp1 = new RpcDispatcher((Channel)c1, null, null, obj1, DEADLOCK_DETECTION);
        obj1.setRpcDispatcher(disp1);
        ((Channel)c1).connect(this.name);
        JChannel c2 = this.createChannel("A");
        obj2 = new ServerObject("obj2");
        RpcDispatcher disp2 = new RpcDispatcher((Channel)c2, null, null, obj2, DEADLOCK_DETECTION);
        obj2.setRpcDispatcher(disp2);
        ((Channel)c2).connect(this.name);
        Vector<Address> dests = new Vector<Address>();
        dests.add(((Channel)c1).getLocalAddress());
        dests.add(((Channel)c2).getLocalAddress());
        try {
            MethodCall call = new MethodCall("outerMethod", new Object[0], new Class[0]);
            Deadlock2Test.log("calling outerMethod() on all members");
            RspList rsps = disp1.callRemoteMethods(dests, call, 2, 0L);
            Deadlock2Test.log("results of outerMethod():\n" + rsps);
            Deadlock2Test.assertEquals((int)2, (int)rsps.size());
            Object var11_10 = null;
            ((Channel)c2).close();
            ((Channel)c1).close();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            ((Channel)c2).close();
            ((Channel)c1).close();
            throw throwable;
        }
    }

    public static Test suite() {
        return new TestSuite(Deadlock2Test.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)Deadlock2Test.suite());
        System.exit(0);
    }

    static void log(String msg) {
        System.out.println("[" + Thread.currentThread() + "] " + msg);
    }

    public static class ServerObject {
        String myName;
        private RpcDispatcher disp;

        public ServerObject(String name) {
            this.myName = name;
        }

        public void setRpcDispatcher(RpcDispatcher rpcDispatcher) {
            this.disp = rpcDispatcher;
        }

        public String outerMethod() {
            Deadlock2Test.log("**** outerMethod() received, calling innerMethod() on all members");
            MethodCall call = new MethodCall("innerMethod", new Object[0], new Class[0]);
            RspList rspList = this.disp.callRemoteMethods(null, call, 2, 0L);
            Vector<Object> results = rspList.getResults();
            Deadlock2Test.log("results of calling innerMethod():\n" + rspList);
            StringBuilder sb = new StringBuilder("outerMethod[");
            Enumeration<Object> e = results.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                sb.append(s);
                if (!e.hasMoreElements()) continue;
                sb.append(";");
            }
            sb.append("]");
            return sb.toString();
        }

        public static String innerMethod() {
            Deadlock2Test.log("**** innerMethod() received, returning result");
            return "innerMethod";
        }
    }
}

