/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.bridge;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.EJBException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.CMPFieldStateFactory;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCResultSetReader;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCType;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory;
import org.jboss.ejb.plugins.cmp.jdbc.LockingStrategy;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.logging.Logger;

public abstract class JDBCAbstractCMPFieldBridge
implements JDBCCMPFieldBridge {
    protected final Logger log;
    protected final JDBCStoreManager manager;
    private final JDBCType jdbcType;
    protected final String fieldName;
    private final Class fieldType;
    protected final boolean readOnly;
    protected final long readTimeOut;
    protected final boolean primaryKeyMember;
    private final Class primaryKeyClass;
    private final Field primaryKeyField;
    protected final int jdbcContextIndex;
    protected final int tableIndex;
    protected CMPFieldStateFactory stateFactory;
    protected boolean checkDirtyAfterGet;
    protected byte defaultFlags = 0;
    private LockingStrategy lockingStrategy = LockingStrategy.NONE;

    public JDBCAbstractCMPFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata) throws DeploymentException {
        this(manager, metadata, manager.getJDBCTypeFactory().getJDBCType(metadata));
    }

    public JDBCAbstractCMPFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata, JDBCType jdbcType) throws DeploymentException {
        this.manager = manager;
        this.fieldName = metadata.getFieldName();
        this.fieldType = metadata.getFieldType();
        this.jdbcType = jdbcType;
        this.readOnly = metadata.isReadOnly();
        this.readTimeOut = metadata.getReadTimeOut();
        this.primaryKeyMember = metadata.isPrimaryKeyMember();
        this.primaryKeyClass = metadata.getEntity().getPrimaryKeyClass();
        this.primaryKeyField = metadata.getPrimaryKeyField();
        JDBCEntityBridge entityBridge = (JDBCEntityBridge)manager.getEntityBridge();
        this.jdbcContextIndex = entityBridge.getNextJDBCContextIndex();
        this.tableIndex = !metadata.isRelationTableField() ? entityBridge.addTableField(this) : -1;
        JDBCTypeFactory typeFactory = manager.getJDBCTypeFactory();
        this.stateFactory = JDBCTypeFactory.getCMPFieldStateFactory(typeFactory, metadata.getStateFactory(), this.fieldType);
        this.checkDirtyAfterGet = JDBCTypeFactory.checkDirtyAfterGet(typeFactory, metadata.getCheckDirtyAfterGet(), this.fieldType);
        this.log = this.createLogger(manager, this.fieldName);
    }

    public JDBCAbstractCMPFieldBridge(JDBCStoreManager manager, String fieldName, Class fieldType, JDBCType jdbcType, boolean readOnly, long readTimeOut, Class primaryKeyClass, Field primaryKeyField, int jdbcContextIndex, int tableIndex, boolean checkDirtyAfterGet, CMPFieldStateFactory stateFactory) {
        this.manager = manager;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.jdbcType = jdbcType;
        this.readOnly = readOnly;
        this.readTimeOut = readTimeOut;
        this.primaryKeyMember = false;
        this.primaryKeyClass = primaryKeyClass;
        this.primaryKeyField = primaryKeyField;
        this.jdbcContextIndex = jdbcContextIndex;
        this.tableIndex = tableIndex;
        this.stateFactory = stateFactory;
        this.checkDirtyAfterGet = checkDirtyAfterGet;
        this.log = this.createLogger(manager, fieldName);
    }

    public byte getDefaultFlags() {
        return this.defaultFlags;
    }

    public void addDefaultFlag(byte flag) {
        this.defaultFlags = (byte)(this.defaultFlags | flag);
    }

    public JDBCEntityPersistenceStore getManager() {
        return this.manager;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    public Class getFieldType() {
        return this.fieldType;
    }

    public boolean isPrimaryKeyMember() {
        return this.primaryKeyMember;
    }

    public Field getPrimaryKeyField() {
        return this.primaryKeyField;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public long getReadTimeOut() {
        return this.readTimeOut;
    }

    public Object getValue(EntityEnterpriseContext ctx) {
        Object value = this.getInstanceValue(ctx);
        if (ctx.isValid()) {
            this.lockingStrategy.accessed(this, ctx);
            if (this.checkDirtyAfterGet) {
                this.setDirtyAfterGet(ctx);
            }
        }
        return value;
    }

    public void setValue(EntityEnterpriseContext ctx, Object value) {
        if (this.isReadOnly()) {
            throw new EJBException("Field is read-only: fieldName=" + this.fieldName);
        }
        if (this.primaryKeyMember && JDBCEntityBridge.isEjbCreateDone(ctx)) {
            throw new IllegalStateException("A CMP field that is a member of the primary key can only be set in ejbCreate [EJB 2.0 Spec. 10.3.5].");
        }
        if (ctx.isValid()) {
            if (!this.isLoaded(ctx)) {
                this.manager.loadField(this, ctx);
            }
            this.lockingStrategy.changed(this, ctx);
        }
        this.setInstanceValue(ctx, value);
    }

    public Object getPrimaryKeyValue(Object primaryKey) throws IllegalArgumentException {
        try {
            if (this.primaryKeyField != null) {
                if (primaryKey == null) {
                    return null;
                }
                return this.primaryKeyField.get(primaryKey);
            }
            return primaryKey;
        }
        catch (Exception e) {
            throw new EJBException("Internal error getting primary key field member " + this.getFieldName(), e);
        }
    }

    public Object setPrimaryKeyValue(Object primaryKey, Object value) throws IllegalArgumentException {
        try {
            if (this.primaryKeyField != null) {
                if (value == null && primaryKey == null) {
                    return null;
                }
                if (primaryKey == null) {
                    primaryKey = this.primaryKeyClass.newInstance();
                }
                this.primaryKeyField.set(primaryKey, value);
                return primaryKey;
            }
            return value;
        }
        catch (Exception e) {
            throw new EJBException("Internal error setting instance field " + this.getFieldName(), e);
        }
    }

    public abstract void resetPersistenceContext(EntityEnterpriseContext var1);

    public void initInstance(EntityEnterpriseContext ctx) {
        if (!this.readOnly) {
            Serializable value = this.fieldType == Boolean.TYPE ? Boolean.FALSE : (this.fieldType == Byte.TYPE ? new Byte(0) : (this.fieldType == Integer.TYPE ? new Integer(0) : (this.fieldType == Long.TYPE ? new Long(0L) : (this.fieldType == Short.TYPE ? new Short(0) : (this.fieldType == Character.TYPE ? (Serializable)new Character('\u0000') : (Serializable)(this.fieldType == Double.TYPE ? (Number)new Double(0.0) : (Number)(this.fieldType == Float.TYPE ? new Float(0.0f) : null)))))));
            this.setInstanceValue(ctx, value);
        }
    }

    public int setInstanceParameters(PreparedStatement ps, int parameterIndex, EntityEnterpriseContext ctx) {
        Object instanceValue = this.getInstanceValue(ctx);
        return this.setArgumentParameters(ps, parameterIndex, instanceValue);
    }

    public int setPrimaryKeyParameters(PreparedStatement ps, int parameterIndex, Object primaryKey) throws IllegalArgumentException {
        Object primaryKeyValue = this.getPrimaryKeyValue(primaryKey);
        return this.setArgumentParameters(ps, parameterIndex, primaryKeyValue);
    }

    public int setArgumentParameters(PreparedStatement ps, int parameterIndex, Object arg) {
        try {
            int[] jdbcTypes = this.jdbcType.getJDBCTypes();
            for (int i = 0; i < jdbcTypes.length; ++i) {
                Object columnValue = this.jdbcType.getColumnValue(i, arg);
                this.jdbcType.getParameterSetter()[i].set(ps, parameterIndex++, jdbcTypes[i], columnValue, this.log);
            }
            return parameterIndex;
        }
        catch (SQLException e) {
            throw new EJBException("Internal error setting parameters for field " + this.getFieldName(), (Exception)e);
        }
    }

    public int loadInstanceResults(ResultSet rs, int parameterIndex, EntityEnterpriseContext ctx) {
        try {
            Object[] argumentRef = new Object[1];
            parameterIndex = this.loadArgumentResults(rs, parameterIndex, argumentRef);
            this.setInstanceValue(ctx, argumentRef[0]);
            this.lockingStrategy.loaded(this, ctx);
            return parameterIndex;
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Internal error getting results for field " + this.getFieldName(), e);
        }
    }

    public int loadPrimaryKeyResults(ResultSet rs, int parameterIndex, Object[] pkRef) throws IllegalArgumentException {
        Object[] argumentRef = new Object[1];
        parameterIndex = this.loadArgumentResults(rs, parameterIndex, argumentRef, true);
        pkRef[0] = argumentRef[0] == null ? null : this.setPrimaryKeyValue(pkRef[0], argumentRef[0]);
        return parameterIndex;
    }

    public int loadArgumentResults(ResultSet rs, int parameterIndex, Object[] argumentRef) throws IllegalArgumentException {
        return this.loadArgumentResults(rs, parameterIndex, argumentRef, false);
    }

    public boolean isRelationTableField() {
        return this.tableIndex < 0;
    }

    public final int getFieldIndex() {
        return this.jdbcContextIndex;
    }

    public Class getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public int getTableIndex() {
        return this.tableIndex;
    }

    public void setLockingStrategy(LockingStrategy lockingStrategy) {
        this.lockingStrategy = lockingStrategy;
    }

    protected abstract void setDirtyAfterGet(EntityEnterpriseContext var1);

    public boolean isCMPField() {
        return true;
    }

    private int loadArgumentResults(ResultSet rs, int parameterIndex, Object[] argumentRef, boolean nullColumnNullifiesResult) throws IllegalArgumentException {
        try {
            argumentRef[0] = null;
            Class[] javaTypes = this.jdbcType.getJavaTypes();
            JDBCResultSetReader[] rsReaders = this.jdbcType.getResultSetReaders();
            for (int i = 0; i < javaTypes.length; ++i) {
                Object columnValue = rsReaders[i].get(rs, parameterIndex++, javaTypes[i], this.log);
                if (nullColumnNullifiesResult && columnValue == null) {
                    argumentRef[0] = null;
                    parameterIndex += javaTypes.length - i - 1;
                    break;
                }
                argumentRef[0] = this.jdbcType.setColumnValue(i, argumentRef[0], columnValue);
            }
            return parameterIndex;
        }
        catch (SQLException e) {
            throw new EJBException("Internal error getting results for field member " + this.getFieldName(), (Exception)e);
        }
    }

    private Logger createLogger(JDBCStoreManager manager, String fieldName) {
        return Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName() + "#" + fieldName));
    }
}

