/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.BagAttribute;
import org.jboss.security.xacml.sunxacml.attr.BooleanAttribute;
import org.jboss.security.xacml.sunxacml.cond.BagFunction;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;

public class ConditionBagFunction
extends BagFunction {
    private static HashMap argMap;

    public ConditionBagFunction(String functionName) {
        super(functionName, 0, ConditionBagFunction.getArguments(functionName));
    }

    public ConditionBagFunction(String functionName, String datatype) {
        super(functionName, 0, new String[]{datatype, datatype});
    }

    private static String[] getArguments(String functionName) {
        String[] args = (String[])argMap.get(functionName);
        if (args == null) {
            throw new IllegalArgumentException("unknown bag function: " + functionName);
        }
        return args;
    }

    public static Set getSupportedIdentifiers() {
        return Collections.unmodifiableSet(argMap.keySet());
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        AttributeValue item = argValues[0];
        BagAttribute bag = (BagAttribute)argValues[1];
        return new EvaluationResult(BooleanAttribute.getInstance(bag.contains(item)));
    }

    static {
        String[] args;
        int i;
        argMap = new HashMap();
        for (i = 0; i < baseTypes.length; ++i) {
            args = new String[]{baseTypes[i], baseTypes[i]};
            argMap.put("urn:oasis:names:tc:xacml:1.0:function:" + simpleTypes[i] + "-is-in", args);
        }
        for (i = 0; i < baseTypes2.length; ++i) {
            args = new String[]{baseTypes2[i], baseTypes2[i]};
            argMap.put("urn:oasis:names:tc:xacml:2.0:function:" + simpleTypes2[i] + "-is-in", args);
        }
    }
}

