/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.vfs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualFileSerializator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("rootUrl", URL.class), new ObjectStreamField("path", String.class)};
    private URL rootUrl;
    private String path;
    private transient VirtualFile file;

    public VirtualFileSerializator() {
    }

    public VirtualFileSerializator(VirtualFile file) {
        this.file = file;
    }

    public static List<VirtualFile> toVirtualFiles(List<VirtualFileSerializator> serializators) throws IOException {
        if (serializators == null) {
            return null;
        }
        if (serializators.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(serializators.size());
        for (VirtualFileSerializator serializator : serializators) {
            files.add(serializator.getFile());
        }
        return files;
    }

    public static List<VirtualFileSerializator> toVirtualFileSerializators(List<VirtualFile> files) throws IOException {
        if (files == null) {
            return null;
        }
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFileSerializator> serializators = new ArrayList<VirtualFileSerializator>(files.size());
        for (VirtualFile file : files) {
            serializators.add(new VirtualFileSerializator(file));
        }
        return serializators;
    }

    public VirtualFile getFile() throws IOException {
        if (this.file == null) {
            VirtualFile root = VFS.getRoot((URL)this.rootUrl);
            this.file = root.findChild(this.path);
        }
        return this.file;
    }

    private void writeObject(ObjectOutputStream out) throws IOException, URISyntaxException {
        String pathName;
        URL url = this.rootUrl;
        if (url == null) {
            VFS vfs = this.getFile().getVFS();
            url = vfs.getRoot().toURL();
        }
        if ((pathName = this.path) == null) {
            pathName = this.getFile().getPathName();
        }
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("rootUrl", url);
        fields.put("path", pathName);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.rootUrl = (URL)fields.get("rootUrl", null);
        this.path = (String)fields.get("path", null);
    }
}

