/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.transport.backchannel;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.coyote.RequestMap;
import org.jboss.ws.extensions.wsrm.transport.backchannel.RMCallbackHandler;

public final class RMBackPortsInvocationHandler
implements ServerInvocationHandler {
    private static final Logger LOG = Logger.getLogger(RMBackPortsInvocationHandler.class);
    private final List<RMCallbackHandler> callbacks = new LinkedList<RMCallbackHandler>();
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RMCallbackHandler getCallback(String requestPath) {
        this.lock.lock();
        try {
            RMCallbackHandler handler;
            Iterator<RMCallbackHandler> i$ = this.callbacks.iterator();
            do {
                if (i$.hasNext()) continue;
                Object var6_6 = null;
                this.lock.unlock();
                return null;
            } while (!(handler = i$.next()).getHandledPath().equals(requestPath));
            RMCallbackHandler rMCallbackHandler = handler;
            Object var6_5 = null;
            this.lock.unlock();
            return rMCallbackHandler;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(RMCallbackHandler callbackHandler) {
        this.lock.lock();
        try {
            this.callbacks.add(callbackHandler);
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(RMCallbackHandler callbackHandler) {
        this.lock.lock();
        try {
            this.callbacks.remove(callbackHandler);
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationRequest request) throws Throwable {
        this.lock.lock();
        try {
            RequestMap rm = (RequestMap)request.getRequestPayload();
            String requestPath = (String)rm.get((Object)"Path");
            boolean handlerExists = false;
            for (RMCallbackHandler handler : this.callbacks) {
                if (!handler.getHandledPath().equals(requestPath)) continue;
                handlerExists = true;
                LOG.debug((Object)("Handling request path: " + requestPath));
                handler.handle(request);
                break;
            }
            if (!handlerExists) {
                LOG.warn((Object)("No callback handler registered for path: " + requestPath));
            }
            Object var5_5 = null;
            Object var8_7 = null;
            this.lock.unlock();
            return var5_5;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public void addListener(InvokerCallbackHandler callbackHandler) {
    }

    public void removeListener(InvokerCallbackHandler callbackHandler) {
    }

    public void setInvoker(ServerInvoker arg0) {
    }

    public void setMBeanServer(MBeanServer arg0) {
    }
}

