/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import org.jboss.security.config.ApplicationPolicy;

public class SecurityConfiguration {
    private static HashMap<String, ApplicationPolicy> appPolicies = new HashMap();
    private static String cipherAlgorithm;
    private static int iterationCount;
    private static String salt;
    private static String keyStoreType;
    private static String keyStoreURL;
    private static String keyStorePass;
    private static String trustStoreType;
    private static String trustStorePass;
    private static String trustStoreURL;
    private static Key cipherKey;
    private static AlgorithmParameterSpec cipherSpec;
    private static boolean deepCopySubjectMode;

    public static void addApplicationPolicy(ApplicationPolicy aP) {
        if (aP == null) {
            throw new IllegalArgumentException("application policy is null");
        }
        appPolicies.put(aP.getName(), aP);
    }

    public static void removeApplicationPolicy(String name) {
        appPolicies.remove(name);
    }

    public static ApplicationPolicy getApplicationPolicy(String policyName) {
        return appPolicies.get(policyName);
    }

    public static String getCipherAlgorithm() {
        return cipherAlgorithm;
    }

    public static void setCipherAlgorithm(String ca) {
        cipherAlgorithm = ca;
    }

    public static Key getCipherKey() {
        return cipherKey;
    }

    public static void setCipherKey(Key ca) {
        cipherKey = ca;
    }

    public static AlgorithmParameterSpec getCipherSpec() {
        return cipherSpec;
    }

    public static void setCipherSpec(AlgorithmParameterSpec aps) {
        cipherSpec = aps;
    }

    public static int getIterationCount() {
        return iterationCount;
    }

    public static void setIterationCount(int count) {
        iterationCount = count;
    }

    public static String getSalt() {
        return salt;
    }

    public static void setSalt(String s) {
        salt = s;
    }

    public static String getKeyStoreType() {
        return keyStoreType;
    }

    public static void setKeyStoreType(String type) {
        keyStoreType = type;
    }

    public static String getKeyStoreURL() {
        return keyStoreURL;
    }

    public static void setKeyStoreURL(String storeURL) {
        keyStoreURL = storeURL;
    }

    public static String getKeyStorePass() {
        return keyStorePass;
    }

    public static void setKeyStorePass(String password) {
        keyStorePass = password;
    }

    public static String getTrustStoreType() {
        return trustStoreType;
    }

    public static void setTrustStoreType(String type) {
        trustStoreType = type;
    }

    public static String getTrustStorePass() {
        return trustStorePass;
    }

    public static void setTrustStorePass(String password) {
        trustStorePass = password;
    }

    public static String getTrustStoreURL() {
        return trustStoreURL;
    }

    public static void setTrustStoreURL(String storeURL) {
        trustStoreURL = storeURL;
    }

    public static boolean isDeepCopySubjectMode() {
        return deepCopySubjectMode;
    }

    public static void setDeepCopySubjectMode(boolean dcsm) {
        deepCopySubjectMode = dcsm;
    }
}

