/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.transaction;

import javax.inject.ExecutionException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.webbeans.transaction.spi.TransactionServices;

public class JBossTransactionServices
implements TransactionServices {
    protected TransactionManager transactionManager;

    public boolean isTransactionActive() {
        try {
            return this.getTransactionManager().getStatus() == 0;
        }
        catch (SystemException e) {
            throw new ExecutionException("Failed to determine transaction status", (Throwable)e);
        }
    }

    protected TransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            throw new IllegalArgumentException("Transaction manager is not yet set.");
        }
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void registerSynchronization(Synchronization synchronizedObserver) {
        try {
            this.getTransactionManager().getTransaction().registerSynchronization(synchronizedObserver);
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to register synchronization " + synchronizedObserver + " for current transaction", (Throwable)e);
        }
    }
}

