/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class ZipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFileOrDirectory(File fileOrDirToZip, File zipFile) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            ZipUtil.zipFileOrDirectory(fileOrDirToZip, zos);
        }
        finally {
            if (zos != null) {
                zos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFileOrDirectory(File fileOrDirToZip, ZipOutputStream zos) throws IOException {
        if (fileOrDirToZip.isDirectory()) {
            File[] files;
            for (File f : files = fileOrDirToZip.listFiles()) {
                ZipUtil.zipFileOrDirectory(f, zos);
            }
        } else {
            FileInputStream fis = null;
            try {
                int bytesIn;
                fis = new FileInputStream(fileOrDirToZip);
                ZipEntry zipEntry = new ZipEntry(fileOrDirToZip.getPath());
                zos.putNextEntry(zipEntry);
                byte[] readBuffer = new byte[4096];
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
    }

    public static void unzipFile(InputStream zipContent, File outputDir) throws IOException {
        ZipEntry e;
        boolean directoryMade;
        if (outputDir.exists() && !outputDir.isDirectory()) {
            throw new RuntimeException("Output directory already exists, but is a file, not a directory. File: " + outputDir.getAbsolutePath());
        }
        if (!outputDir.exists() && !(directoryMade = outputDir.mkdir())) {
            throw new RuntimeException("Could not create output directory for unzipped artifact: " + outputDir.getAbsolutePath());
        }
        ZipInputStream zis = new ZipInputStream(zipContent);
        while ((e = zis.getNextEntry()) != null) {
            int byteCount;
            String entryFileName = e.getName();
            File entryFile = new File(outputDir, entryFileName);
            if (e.isDirectory()) {
                entryFile.mkdirs();
                continue;
            }
            String parentDirectory = entryFile.getParent();
            File parentDirectoryFile = new File(parentDirectory);
            parentDirectoryFile.mkdirs();
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(entryFile));
            byte[] data = new byte[4096];
            while ((byteCount = zis.read(data)) != -1) {
                outputStream.write(data, 0, byteCount);
            }
            outputStream.close();
        }
        zipContent.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(File tempFile, File destDir) throws IOException {
        InputStream tempIs = null;
        try {
            tempIs = new BufferedInputStream(new FileInputStream(tempFile));
            destDir.mkdirs();
            ZipUtil.unzipFile(tempIs, destDir);
        }
        finally {
            if (tempIs != null) {
                tempIs.close();
            }
        }
    }

    private ZipUtil() {
    }
}

