/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.injection.finders;

import java.lang.reflect.Field;
import java.util.Collection;
import org.jboss.wsf.common.injection.InjectionException;
import org.jboss.wsf.common.injection.finders.ReflectionUtils;
import org.jboss.wsf.common.reflection.FieldFinder;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionFieldFinder
extends FieldFinder {
    private final InjectionMetaData injectionMD;

    public InjectionFieldFinder(InjectionMetaData injectionMD) {
        if (injectionMD == null) {
            throw new IllegalArgumentException("Injection metadata cannot be null");
        }
        this.injectionMD = injectionMD;
    }

    @Override
    public boolean matches(Field field) {
        if (field.getName().equals(this.injectionMD.getTargetName())) {
            if (this.injectionMD.getValueClass() != null) {
                Class expectedClass = this.injectionMD.getValueClass();
                Class<?> fieldClass = field.getType();
                return expectedClass.equals(fieldClass);
            }
            return true;
        }
        return false;
    }

    @Override
    public void validate(Collection<Field> fields) {
        super.validate(fields);
        if (fields.size() > 2) {
            throw new InjectionException("More than one field found matching the criteria: " + this.injectionMD);
        }
    }

    @Override
    public void validate(Field field) {
        super.validate(field);
        ReflectionUtils.assertNotVoidType(field);
        ReflectionUtils.assertNotStatic(field);
        ReflectionUtils.assertNotFinal(field);
        ReflectionUtils.assertNotPrimitiveType(field);
    }
}

