/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthArguments {
    private static final String SERVICE_PARAM = "OAUTH_SERVICE_NAME";
    private static final String TOKEN_PARAM = "OAUTH_TOKEN_NAME";
    private static final String REQUEST_TOKEN_PARAM = "OAUTH_REQUEST_TOKEN";
    private static final String REQUEST_TOKEN_SECRET_PARAM = "OAUTH_REQUEST_TOKEN_SECRET";
    private static final String USE_TOKEN_PARAM = "OAUTH_USE_TOKEN";
    private static final String CLIENT_STATE_PARAM = "oauthState";
    private static final String BYPASS_SPEC_CACHE_PARAM = "bypassSpecCache";
    private static final String SIGN_OWNER_PARAM = "signOwner";
    private static final String SIGN_VIEWER_PARAM = "signViewer";
    private static final String RECEIVED_CALLBACK_PARAM = "OAUTH_RECEIVED_CALLBACK";
    public static final String PROGRAMMATIC_CONFIG_PARAM = "OAUTH_PROGRAMMATIC_CONFIG";
    public static final String REQUEST_METHOD_PARAM = "OAUTH_REQUEST_METHOD";
    public static final String PARAM_LOCATION_PARAM = "OAUTH_PARAM_LOCATION";
    public static final String REQUEST_TOKEN_URL_PARAM = "OAUTH_REQUEST_TOKEN_URL";
    public static final String ACCESS_TOKEN_URL_PARAM = "OAUTH_ACCESS_TOKEN_URL";
    public static final String AUTHORIZATION_URL_PARAM = "OAUTH_AUTHORIZATION_URL";
    private UseToken useToken = UseToken.ALWAYS;
    private String serviceName = "";
    private String tokenName = "";
    private String requestToken = null;
    private String requestTokenSecret = null;
    private String origClientState = null;
    private boolean bypassSpecCache = false;
    private boolean signOwner = false;
    private boolean signViewer = false;
    private final Map<String, String> requestOptions = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    private boolean proxiedContentRequest = false;
    private String receivedCallbackUrl = null;

    public OAuthArguments(AuthType auth, HttpServletRequest request) throws GadgetException {
        this.useToken = OAuthArguments.parseUseToken(auth, OAuthArguments.getRequestParam(request, USE_TOKEN_PARAM, ""));
        this.serviceName = OAuthArguments.getRequestParam(request, SERVICE_PARAM, "");
        this.tokenName = OAuthArguments.getRequestParam(request, TOKEN_PARAM, "");
        this.requestToken = OAuthArguments.getRequestParam(request, REQUEST_TOKEN_PARAM, null);
        this.requestTokenSecret = OAuthArguments.getRequestParam(request, REQUEST_TOKEN_SECRET_PARAM, null);
        this.origClientState = OAuthArguments.getRequestParam(request, CLIENT_STATE_PARAM, null);
        this.bypassSpecCache = "1".equals(OAuthArguments.getRequestParam(request, BYPASS_SPEC_CACHE_PARAM, null));
        this.signOwner = Boolean.parseBoolean(OAuthArguments.getRequestParam(request, SIGN_OWNER_PARAM, "true"));
        this.signViewer = Boolean.parseBoolean(OAuthArguments.getRequestParam(request, SIGN_VIEWER_PARAM, "true"));
        this.receivedCallbackUrl = OAuthArguments.getRequestParam(request, RECEIVED_CALLBACK_PARAM, null);
        Enumeration<String> params = this.getParameterNames(request);
        while (params.hasMoreElements()) {
            String name = params.nextElement();
            this.requestOptions.put(name, request.getParameter(name));
        }
    }

    private Enumeration<String> getParameterNames(HttpServletRequest request) {
        return request.getParameterNames();
    }

    public OAuthArguments(RequestAuthenticationInfo info) throws GadgetException {
        this(info.getAuthType(), info.getAttributes());
        this.origClientState = null;
        this.bypassSpecCache = false;
        this.signOwner = info.isSignOwner();
        this.signViewer = info.isSignViewer();
    }

    public OAuthArguments(AuthType auth, Map<String, String> map) throws GadgetException {
        this.requestOptions.putAll(map);
        this.useToken = OAuthArguments.parseUseToken(auth, OAuthArguments.getAuthInfoParam(this.requestOptions, USE_TOKEN_PARAM, ""));
        this.serviceName = OAuthArguments.getAuthInfoParam(this.requestOptions, SERVICE_PARAM, "");
        this.tokenName = OAuthArguments.getAuthInfoParam(this.requestOptions, TOKEN_PARAM, "");
        this.requestToken = OAuthArguments.getAuthInfoParam(this.requestOptions, REQUEST_TOKEN_PARAM, null);
        this.requestTokenSecret = OAuthArguments.getAuthInfoParam(this.requestOptions, REQUEST_TOKEN_SECRET_PARAM, null);
        this.origClientState = OAuthArguments.getAuthInfoParam(this.requestOptions, CLIENT_STATE_PARAM, null);
        this.bypassSpecCache = "1".equals(OAuthArguments.getAuthInfoParam(this.requestOptions, BYPASS_SPEC_CACHE_PARAM, null));
        this.signOwner = Boolean.parseBoolean(OAuthArguments.getAuthInfoParam(this.requestOptions, SIGN_OWNER_PARAM, "true"));
        this.signViewer = Boolean.parseBoolean(OAuthArguments.getAuthInfoParam(this.requestOptions, SIGN_VIEWER_PARAM, "true"));
        this.receivedCallbackUrl = OAuthArguments.getAuthInfoParam(this.requestOptions, RECEIVED_CALLBACK_PARAM, null);
    }

    private static String getAuthInfoParam(Map<String, String> attrs, String name, String def) {
        String val = attrs.get(name);
        if (val == null) {
            val = def;
        }
        return val;
    }

    private static String getRequestParam(HttpServletRequest request, String name, String def) {
        String val = request.getParameter(name);
        if (val == null) {
            val = def;
        }
        return val;
    }

    private static UseToken parseUseToken(AuthType auth, String useTokenStr) throws GadgetException {
        if (useTokenStr.length() == 0) {
            if (auth == AuthType.SIGNED) {
                return UseToken.NEVER;
            }
            return UseToken.ALWAYS;
        }
        if ("always".equals(useTokenStr = useTokenStr.toLowerCase())) {
            return UseToken.ALWAYS;
        }
        if ("if_available".equals(useTokenStr)) {
            return UseToken.IF_AVAILABLE;
        }
        if ("never".equals(useTokenStr)) {
            return UseToken.NEVER;
        }
        throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Unknown use token value " + useTokenStr);
    }

    public OAuthArguments() {
    }

    public OAuthArguments(OAuthArguments orig) {
        this.useToken = orig.useToken;
        this.serviceName = orig.serviceName;
        this.tokenName = orig.tokenName;
        this.requestToken = orig.requestToken;
        this.requestTokenSecret = orig.requestTokenSecret;
        this.origClientState = orig.origClientState;
        this.bypassSpecCache = orig.bypassSpecCache;
        this.signOwner = orig.signOwner;
        this.signViewer = orig.signViewer;
        this.requestOptions.putAll(orig.requestOptions);
        this.proxiedContentRequest = orig.proxiedContentRequest;
    }

    public boolean mustUseToken() {
        return this.useToken == UseToken.ALWAYS;
    }

    public boolean mayUseToken() {
        return this.useToken == UseToken.IF_AVAILABLE || this.useToken == UseToken.ALWAYS;
    }

    public UseToken getUseToken() {
        return this.useToken;
    }

    public void setUseToken(UseToken useToken) {
        this.useToken = useToken;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public String getRequestToken() {
        return this.requestToken;
    }

    public void setRequestToken(String requestToken) {
        this.requestToken = requestToken;
    }

    public String getRequestTokenSecret() {
        return this.requestTokenSecret;
    }

    public void setRequestTokenSecret(String requestTokenSecret) {
        this.requestTokenSecret = requestTokenSecret;
    }

    public String getOrigClientState() {
        return this.origClientState;
    }

    public void setOrigClientState(String origClientState) {
        this.origClientState = origClientState;
    }

    public boolean getBypassSpecCache() {
        return this.bypassSpecCache;
    }

    public void setBypassSpecCache(boolean bypassSpecCache) {
        this.bypassSpecCache = bypassSpecCache;
    }

    public boolean getSignOwner() {
        return this.signOwner;
    }

    public void setSignOwner(boolean signOwner) {
        this.signOwner = signOwner;
    }

    public boolean getSignViewer() {
        return this.signViewer;
    }

    public void setSignViewer(boolean signViewer) {
        this.signViewer = signViewer;
    }

    public void setRequestOption(String name, String value) {
        this.requestOptions.put(name, value);
    }

    public void removeRequestOption(String name) {
        this.requestOptions.remove(name);
    }

    public String getRequestOption(String name) {
        return this.requestOptions.get(name);
    }

    public String getRequestOption(String name, String def) {
        String val = this.requestOptions.get(name);
        return val != null ? val : def;
    }

    public boolean isProxiedContentRequest() {
        return this.proxiedContentRequest;
    }

    public void setProxiedContentRequest(boolean proxiedContentRequest) {
        this.proxiedContentRequest = proxiedContentRequest;
    }

    public boolean programmaticConfig() {
        return Boolean.parseBoolean(this.requestOptions.get(PROGRAMMATIC_CONFIG_PARAM));
    }

    public String getReceivedCallbackUrl() {
        return this.receivedCallbackUrl;
    }

    public void setReceivedCallbackUrl(String receivedCallbackUrl) {
        this.receivedCallbackUrl = receivedCallbackUrl;
    }

    public int hashCode() {
        int result = this.bypassSpecCache ? 1231 : 1237;
        result = 31 * result + (this.origClientState == null ? 0 : this.origClientState.hashCode());
        result = 31 * result + (this.proxiedContentRequest ? 1231 : 1237);
        result = 31 * result + (this.requestToken == null ? 0 : this.requestToken.hashCode());
        result = 31 * result + (this.requestTokenSecret == null ? 0 : this.requestTokenSecret.hashCode());
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = 31 * result + (this.signOwner ? 1231 : 1237);
        result = 31 * result + (this.signViewer ? 1231 : 1237);
        result = 31 * result + (this.tokenName == null ? 0 : this.tokenName.hashCode());
        result = 31 * result + (this.useToken == null ? 0 : this.useToken.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OAuthArguments)) {
            return false;
        }
        OAuthArguments other = (OAuthArguments)obj;
        return this.bypassSpecCache == other.bypassSpecCache && StringUtils.equals((String)this.origClientState, (String)other.origClientState) && this.proxiedContentRequest == other.proxiedContentRequest && StringUtils.equals((String)this.requestToken, (String)other.requestToken) && StringUtils.equals((String)this.requestTokenSecret, (String)other.requestTokenSecret) && StringUtils.equals((String)this.tokenName, (String)other.tokenName) && this.signViewer == other.signViewer && this.useToken == other.useToken;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UseToken {
        NEVER,
        IF_AVAILABLE,
        ALWAYS;

    }
}

