/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.spi.BatchingManager;

class BatchingManagerImpl
implements BatchingManager {
    private static final Logger log = Logger.getLogger(BatchingManagerImpl.class);
    private final TransactionManager tm;

    BatchingManagerImpl(TransactionManager tm) {
        assert (tm != null) : " batchingManager is null";
        this.tm = tm;
    }

    public boolean isBatchInProgress() throws Exception {
        return this.tm.getTransaction() != null;
    }

    public void startBatch() throws Exception {
        this.tm.begin();
    }

    public void setBatchRollbackOnly() throws Exception {
        this.tm.setRollbackOnly();
    }

    public void endBatch() {
        try {
            if (this.tm.getTransaction().getStatus() != 1) {
                this.tm.commit();
            } else {
                log.debug((Object)"endBatch(): rolling back batch");
                this.tm.rollback();
            }
        }
        catch (RollbackException re) {
            log.warn((Object)("endBatch(): rolling back transaction with exception: " + (Object)((Object)re)));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("endTransaction(): Caught Exception ending batch: ", e);
        }
    }
}

