/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class StringConverter {
    private static String ILLEGAL_DNCHAR = "StringConverter: empty string for denormalization to char";
    private static final Pattern ENCODE_PATTERN = Pattern.compile("_x\\p{XDigit}{4}_");
    private static final int ENCODE_CHARS = 7;
    private static Log log = ExoLogger.getLogger((String)"jcr.StringConverter");

    public static String normalizeString(String s, boolean canonical) {
        StringBuffer strBuf = new StringBuffer();
        int len = s != null ? s.length() : 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ('_' == c) {
                if (len - i > 7) {
                    String spart = s.substring(i, i + 7);
                    Matcher encodeMatcher = ENCODE_PATTERN.matcher(spart);
                    if (encodeMatcher.matches()) {
                        strBuf.append(StringConverter.normalizeChar(c, canonical));
                        continue;
                    }
                    strBuf.append(c);
                    continue;
                }
                strBuf.append(c);
                continue;
            }
            strBuf.append(StringConverter.normalizeChar(c, canonical));
        }
        return new String(strBuf);
    }

    public static String denormalizeString(String s) {
        StringBuffer strBuf = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            try {
                DNChar dnc = StringConverter.denormalize(s.substring(i));
                strBuf.append(dnc.getDnChar());
                i += dnc.getDnLength();
            }
            catch (IllegalArgumentException e) {
                if (!e.getMessage().equals(ILLEGAL_DNCHAR)) {
                    throw e;
                }
                char c = s.charAt(i);
                strBuf.append(c);
                ++i;
            }
        }
        return new String(strBuf);
    }

    public static String normalizeChar(char c, boolean canonical) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '\r': {
                if (canonical) {
                    return "_x000D_";
                }
            }
            case '\n': {
                if (canonical) {
                    return "_x000A_";
                }
            }
            case '\t': {
                if (canonical) {
                    return "_x0009_";
                }
            }
            case ' ': {
                if (canonical) {
                    return "_x0020_";
                }
            }
            case '_': {
                if (!canonical) break;
                return "_x005f_";
            }
        }
        return "" + c;
    }

    public static char denormalizeChar(String string) {
        return StringConverter.denormalize(string).getDnChar();
    }

    private static DNChar denormalize(String string) {
        if (string.startsWith("&lt;")) {
            return new DNChar('<', 4);
        }
        if (string.startsWith("&gt;")) {
            return new DNChar('>', 4);
        }
        if (string.startsWith("&amp;")) {
            return new DNChar('&', 5);
        }
        if (string.startsWith("&quot;")) {
            return new DNChar('\"', 6);
        }
        if (string.startsWith("&apos;")) {
            return new DNChar('\'', 6);
        }
        if (string.startsWith("_x000D_")) {
            return new DNChar('\r', 7);
        }
        if (string.startsWith("_x000A_")) {
            return new DNChar('\n', 7);
        }
        if (string.startsWith("_x0009_")) {
            return new DNChar('\t', 7);
        }
        if (string.startsWith("_x0020_")) {
            return new DNChar(' ', 7);
        }
        if (string.startsWith("_x005f_")) {
            return new DNChar('_', 7);
        }
        throw new IllegalArgumentException(ILLEGAL_DNCHAR);
    }

    private static class DNChar {
        private char dnChar;
        private int dnLength;

        public DNChar(char dnChar, int dnLength) {
            this.dnChar = dnChar;
            this.dnLength = dnLength;
        }

        public char getDnChar() {
            return this.dnChar;
        }

        public int getDnLength() {
            return this.dnLength;
        }
    }
}

