/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.rmi.Remote;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.client.ServiceObjectFactory;
import org.jboss.ws.core.jaxrpc.client.ServiceExt;
import org.jboss.ws.core.jaxrpc.client.ServiceImpl;
import org.jboss.ws.core.jaxrpc.client.ServiceProxy;
import org.jboss.ws.core.server.PortComponentResolver;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public class ServiceObjectFactoryJAXRPC
extends ServiceObjectFactory {
    private static final Logger log = Logger.getLogger(ServiceObjectFactoryJAXRPC.class);

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        try {
            RefAddr pcLinkRef;
            Reference ref = (Reference)obj;
            UnifiedServiceRefMetaData serviceRef = null;
            RefAddr metaRefAddr = ref.get("SERVICE_REF_META_DATA");
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])metaRefAddr.getContent());
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                serviceRef = (UnifiedServiceRefMetaData)ois.readObject();
                ois.close();
            }
            catch (IOException ex) {
                NamingException ne = new NamingException("Cannot unmarshall service ref meta data");
                ne.setRootCause(ex);
                throw ne;
            }
            WSSecurityConfiguration securityConfig = null;
            RefAddr wsseRefAddr = ref.get("SECURITY_CONFIG");
            if (wsseRefAddr != null) {
                bais = new ByteArrayInputStream((byte[])wsseRefAddr.getContent());
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    securityConfig = (WSSecurityConfiguration)ois.readObject();
                    ois.close();
                }
                catch (IOException e) {
                    throw new NamingException("Cannot unmarshall security config, cause: " + e.toString());
                }
            }
            ServiceImpl jaxrpcService = null;
            URL wsdlLocation = serviceRef.getWsdlLocation();
            if (wsdlLocation != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Create jaxrpc service from wsdl");
                }
                QName serviceName = serviceRef.getServiceQName();
                JavaWsdlMapping javaWsdlMapping = this.getJavaWsdlMapping(serviceRef);
                jaxrpcService = new ServiceImpl(serviceName, wsdlLocation, javaWsdlMapping, securityConfig, serviceRef);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Create jaxrpc service with no wsdl");
                }
                jaxrpcService = new ServiceImpl(new QName("http://www.jboss.org/jbossws", "AnonymousService"));
            }
            ServiceMetaData serviceMetaData = jaxrpcService.getServiceMetaData();
            if (serviceRef.getCallProperties().size() > 0) {
                Properties callProps = new Properties();
                serviceMetaData.setProperties(callProps);
                for (UnifiedCallPropertyMetaData prop : serviceRef.getCallProperties()) {
                    callProps.setProperty(prop.getPropName(), prop.getPropValue());
                }
            }
            if ((pcLinkRef = ref.get("PORT_COMPONENT_LINK")) != null) {
                String pcLink = (String)pcLinkRef.getContent();
                log.debug((Object)("Resolving port-component-link: " + pcLink));
                String endpointAddress = null;
                try {
                    SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
                    EndpointRegistry epRegistry = spiProvider.getSPI(EndpointRegistryFactory.class).getEndpointRegistry();
                    Endpoint endpoint = epRegistry.resolve(new PortComponentResolver(pcLink));
                    if (endpoint == null) {
                        throw new WSException("Cannot resolve port-component-link: " + pcLink);
                    }
                    ServerEndpointMetaData sepMetaData = endpoint.getAttachment(ServerEndpointMetaData.class);
                    endpointAddress = sepMetaData.getEndpointAddress();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                if (endpointAddress == null) {
                    String servletPath = (String)ref.get("PORT_COMPONENT_LINK_SERVLET").getContent();
                    servletPath = servletPath + "?pcLink=" + URLEncoder.encode(pcLink, "UTF-8");
                    InputStream is = new URL(servletPath).openStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    endpointAddress = br.readLine();
                    is.close();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved to: " + endpointAddress));
                }
                if (serviceMetaData.getEndpoints().size() == 1) {
                    EndpointMetaData epMetaData = serviceMetaData.getEndpoints().get(0);
                    epMetaData.setEndpointAddress(endpointAddress);
                } else {
                    log.warn((Object)"Cannot set endpoint address for port-component-link, unsuported number of endpoints");
                }
            }
            this.narrowPortSelection(serviceRef, serviceMetaData);
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            Class<?> siClass = contextCL.loadClass(serviceRef.getServiceInterface());
            if (!Service.class.isAssignableFrom(siClass)) {
                throw new JAXRPCException("The service interface does not implement javax.xml.rpc.Service: " + siClass.getName());
            }
            for (UnifiedPortComponentRefMetaData pcr : serviceRef.getPortComponentRefs()) {
                Class<?> seiClass;
                String seiName = pcr.getServiceEndpointInterface();
                if (seiName == null || Remote.class.isAssignableFrom(seiClass = contextCL.loadClass(seiName))) continue;
                throw new IllegalArgumentException("The SEI does not implement java.rmi.Remote: " + seiClass.getName());
            }
            this.setupHandlerChain(jaxrpcService);
            ServiceProxy handler = new ServiceProxy(jaxrpcService, siClass);
            return Proxy.newProxyInstance(contextCL, new Class[]{siClass, ServiceExt.class}, (InvocationHandler)handler);
        }
        catch (Exception ex) {
            log.error((Object)"Cannot create service", (Throwable)ex);
            throw ex;
        }
    }

    private void setupHandlerChain(ServiceImpl jaxrpcService) throws Exception {
        List<EndpointMetaData> endpoints = jaxrpcService.getServiceMetaData().getEndpoints();
        for (EndpointMetaData epMetaData : endpoints) {
            jaxrpcService.setupHandlerChain(epMetaData);
        }
    }

    private JavaWsdlMapping getJavaWsdlMapping(UnifiedServiceRefMetaData serviceRef) {
        JavaWsdlMapping javaWsdlMapping = null;
        if (serviceRef.getMappingFile() != null) {
            String mappingFile = serviceRef.getMappingFile();
            try {
                JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
                URL mappingURL = serviceRef.getVfsRoot().findChild(mappingFile).toURL();
                javaWsdlMapping = mappingFactory.parse(mappingURL);
            }
            catch (Exception e) {
                throw new WSException("Cannot unmarshal jaxrpc-mapping-file: " + mappingFile, e);
            }
        }
        return javaWsdlMapping;
    }
}

